/*!
      * Sa11y, the accessibility quality assurance assistant.
      * @version 4.4.1
      * @author Adam Chaboryk
      * @license GPL-2.0-or-later
      * @copyright © 2020 - 2025 Toronto Metropolitan University.
      * @contact adam.chaboryk@torontomu.ca
      * GitHub: git+https://github.com/ryersondmp/sa11y.git | Website: https://sa11y.netlify.app
      * The above copyright notice shall be included in all copies or substantial portions of the Software.
    **/
const _n = {
  // Target area to check
  checkRoot: "body",
  fixedRoots: !1,
  // Exclusions
  containerIgnore: ".sa11y-ignore",
  contrastIgnore: ".sr-only",
  outlineIgnore: "",
  headerIgnore: "",
  headerIgnoreSpan: "",
  headerIgnoreStrings: "",
  imageIgnore: "",
  linkIgnore: "",
  linkIgnoreSpan: "",
  linkIgnoreStrings: [],
  ignoreContentOutsideRoots: !1,
  // Control panel settings
  aboutContent: "",
  panelPosition: "right",
  showMovePanelToggle: !0,
  checkAllHideToggles: !1,
  developerChecksOnByDefault: !1,
  // Page outline
  showHinPageOutline: !1,
  showTitleInPageOutline: !0,
  // Image outline
  showImageOutline: !0,
  editImageURLofCMS: "",
  relativePathImageSRC: "",
  relativePathImageID: "",
  ignoreEditImageURL: [],
  ignoreEditImageClass: [],
  // Other features
  delayCheck: 0,
  delayCustomCheck: 500,
  detectSPArouting: !1,
  doNotRun: "",
  headless: !1,
  selectorPath: !1,
  shadowComponents: "",
  autoDetectShadowComponents: !1,
  // Annotations
  showGoodImageButton: !0,
  showGoodLinkButton: !0,
  dismissAnnotations: !0,
  dismissAll: !0,
  ignoreHiddenOverflow: "",
  insertAnnotationBefore: "",
  // Readability
  readabilityPlugin: !0,
  readabilityRoot: "body",
  readabilityIgnore: "",
  // Contrast
  contrastPlugin: !0,
  contrastAlgorithm: "AA",
  // AA, AAA, APCA
  // Other plugins
  customChecks: !1,
  formLabelsPlugin: !0,
  embeddedContentPlugin: !0,
  developerPlugin: !0,
  externalDeveloperChecks: !1,
  colourFilterPlugin: !0,
  exportResultsPlugin: !1,
  // Options for accName computation: Ignore ARIA on these elements.
  ignoreAriaOnElements: !1,
  // e.g. 'h1,h2,h3,h4,h5,h6'
  ignoreTextInElements: !1,
  // e.g. '.inner-node-hidden-in-CSS'
  // Shared properties for some checks
  altPlaceholder: [],
  susAltStopWords: "",
  linkStopWords: "",
  extraPlaceholderStopWords: "",
  imageWithinLightbox: "",
  initialHeadingLevel: [],
  // All checks
  checks: {
    // Heading checks
    HEADING_SKIPPED_LEVEL: !0,
    HEADING_EMPTY_WITH_IMAGE: !0,
    HEADING_EMPTY: !0,
    HEADING_FIRST: !0,
    HEADING_LONG: {
      maxLength: 170
    },
    HEADING_MISSING_ONE: !0,
    // Image checks
    MISSING_ALT_LINK: !0,
    MISSING_ALT_LINK_HAS_TEXT: !0,
    MISSING_ALT: !0,
    IMAGE_DECORATIVE_CAROUSEL: {
      sources: ".carousel"
    },
    LINK_IMAGE_NO_ALT_TEXT: !0,
    LINK_IMAGE_TEXT: !0,
    IMAGE_FIGURE_DECORATIVE: !0,
    IMAGE_DECORATIVE: !0,
    LINK_ALT_FILE_EXT: !0,
    ALT_FILE_EXT: !0,
    LINK_PLACEHOLDER_ALT: !0,
    ALT_PLACEHOLDER: !0,
    LINK_SUS_ALT: !0,
    SUS_ALT: !0,
    LINK_IMAGE_LONG_ALT: {
      maxLength: 250
    },
    IMAGE_ALT_TOO_LONG: {
      maxLength: 250
    },
    LINK_IMAGE_ALT: {
      dismissAll: !0
    },
    LINK_IMAGE_ALT_AND_TEXT: !0,
    IMAGE_FIGURE_DUPLICATE_ALT: !0,
    IMAGE_PASS: {
      dismissAll: !0
    },
    ALT_UNPRONOUNCEABLE: !0,
    LINK_ALT_UNPRONOUNCEABLE: !0,
    ALT_MAYBE_BAD: {
      minLength: 15
    },
    LINK_ALT_MAYBE_BAD: {
      minLength: 15
    },
    // Link checks
    DUPLICATE_TITLE: {
      dismissAll: !0
    },
    LINK_EMPTY_LABELLEDBY: !0,
    LINK_EMPTY_NO_LABEL: !0,
    LINK_STOPWORD: !0,
    LINK_STOPWORD_ARIA: !0,
    LINK_SYMBOLS: !0,
    LINK_CLICK_HERE: !0,
    LINK_DOI: {
      dismissAll: !0
    },
    LINK_URL: {
      maxLength: 40
    },
    LINK_LABEL: {
      dismissAll: !0
    },
    LINK_EMPTY: !0,
    LINK_IDENTICAL_NAME: {
      dismissAll: !0
    },
    LINK_NEW_TAB: {
      dismissAll: !0
    },
    LINK_FILE_EXT: !0,
    // Form labels checks
    LABELS_MISSING_IMAGE_INPUT: !0,
    LABELS_INPUT_RESET: !0,
    LABELS_MISSING_LABEL: !0,
    LABELS_ARIA_LABEL_INPUT: !0,
    LABELS_NO_FOR_ATTRIBUTE: !0,
    LABELS_PLACEHOLDER: !0,
    // Embedded content checks
    EMBED_AUDIO: {
      sources: ""
    },
    EMBED_VIDEO: {
      sources: ""
    },
    EMBED_DATA_VIZ: {
      sources: ""
    },
    EMBED_UNFOCUSABLE: !0,
    EMBED_MISSING_TITLE: !0,
    EMBED_GENERAL: !0,
    // Quality assurance checks
    QA_BAD_LINK: {
      sources: ""
    },
    QA_STRONG_ITALICS: !0,
    QA_IN_PAGE_LINK: !0,
    QA_DOCUMENT: {
      sources: "",
      dismissAll: !0
    },
    QA_PDF: {
      dismissAll: !0
    },
    QA_BLOCKQUOTE: !0,
    TABLES_MISSING_HEADINGS: !0,
    TABLES_SEMANTIC_HEADING: !0,
    TABLES_EMPTY_HEADING: !0,
    QA_FAKE_HEADING: !0,
    QA_FAKE_LIST: !0,
    QA_UPPERCASE: !0,
    QA_UNDERLINE: !0,
    QA_SUBSCRIPT: !0,
    QA_NESTED_COMPONENTS: {
      sources: ""
    },
    QA_JUSTIFY: !0,
    QA_SMALL_TEXT: !0,
    // Meta checks
    META_LANG: !0,
    META_SCALABLE: !0,
    META_MAX: !0,
    META_REFRESH: !0,
    // Developer checks
    DUPLICATE_ID: !0,
    META_TITLE: !0,
    UNCONTAINED_LI: !0,
    TABINDEX_ATTR: !0,
    HIDDEN_FOCUSABLE: !0,
    LABEL_IN_NAME: !0,
    BTN_EMPTY: !0,
    BTN_EMPTY_LABELLEDBY: !0,
    BTN_ROLE_IN_NAME: !0,
    // Contrast checks
    CONTRAST_WARNING: {
      dismissAll: !0
    },
    CONTRAST_INPUT: !0,
    CONTRAST_ERROR: !0,
    CONTRAST_PLACEHOLDER: !0,
    CONTRAST_PLACEHOLDER_UNSUPPORTED: !0,
    CONTRAST_ERROR_GRAPHIC: !0,
    CONTRAST_WARNING_GRAPHIC: {
      dismissAll: !0
    },
    CONTRAST_UNSUPPORTED: {
      dismissAll: !0
    }
  }
}, f = {
  langStrings: {},
  addI18n(t) {
    this.langStrings = t;
  },
  _(t) {
    return this.translate(t);
  },
  sprintf(t, ...e) {
    let n = this._(t);
    return n = this.prepHTML(n), e?.length && e.forEach((s) => {
      n = n.replace(/%\([a-zA-z]+\)/, s);
    }), n;
  },
  translate(t) {
    return this.langStrings[t] || t;
  },
  prepHTML(t) {
    return t.replaceAll(/<hr>/g, '<hr aria-hidden="true">').replaceAll(/<a[\s]href=/g, '<a target="_blank" rel="noopener noreferrer" href=').replaceAll(/<\/a>/g, `<span class="visually-hidden"> (${f._("NEW_TAB")})</span></a>`).replaceAll(/{C}/g, 'class="colour"').replaceAll(/{B}/g, 'class="badge"').replaceAll(/{ALT}/g, `<strong class="badge">${f._("ALT")}</strong>`).replaceAll(
      /{L}/g,
      `<strong class="badge"><span class="link-icon"></span><span class="visually-hidden">${f._("LINKED")}</span></strong>`
    );
  }
};
function We() {
  const t = document.querySelector("sa11y-control-panel").shadowRoot, e = t.getElementById("panel-alert"), n = t.getElementById("panel-alert-text"), s = t.getElementById("panel-alert-preview");
  for (e.classList.remove("active"), s.classList.remove("panel-alert-preview"); n.firstChild; )
    n.removeChild(n.firstChild);
  for (; s.firstChild; )
    s.removeChild(s.firstChild);
}
function je(t, e, n) {
  We();
  const s = document.querySelector("sa11y-control-panel").shadowRoot, r = s.getElementById("panel-alert"), a = s.getElementById("panel-alert-text"), i = s.getElementById("panel-alert-preview"), l = s.getElementById("close-alert"), c = s.getElementById("skip-button");
  r.classList.add("active"), a.innerHTML = t;
  const p = n ? `<div class="element-preview">${n}</div>` : "";
  e && (i.classList.add("panel-alert-preview"), i.innerHTML = `${p}<div class="preview-message">${e}</div>`), setTimeout(() => l.focus(), 300);
  function o() {
    We(), (c.hasAttribute("disabled") ? s.getElementById("toggle") : c).focus();
  }
  l.addEventListener("click", o), r.onkeydown = (d) => {
    (d || window.event).key === "Escape" && r.classList.contains("active") && o();
  };
}
const u = /* @__PURE__ */ (function() {
  const e = {};
  function n(d) {
    e.html = document.querySelector("html"), e.headless = d.headless, e.panelPosition = d.panelPosition, e.dismissAnnotations = d.dismissAnnotations, e.aboutContent = d.aboutContent, e.shadowDetection = d.shadowComponents.length > 0 || d.autoDetectShadowComponents === !0, e.fixedRoots = d.fixedRoots, e.ignoreAriaOnElements = d.ignoreAriaOnElements, e.ignoreTextInElements = d.ignoreTextInElements, e.contrastSuggestions = d.contrastSuggestions, e.contrastAlgorithm = d.contrastAlgorithm.toUpperCase(), e.developerPlugin = d.developerPlugin, e.colourFilterPlugin = d.colourFilterPlugin, e.checkAllHideToggles = d.checkAllHideToggles, e.exportResultsPlugin = d.exportResultsPlugin, e.readabilityPlugin = d.readabilityPlugin, e.showImageOutline = d.showImageOutline, e.editImageURLofCMS = d.editImageURLofCMS, e.relativePathImageSRC = d.relativePathImageSRC, e.relativePathImageID = d.relativePathImageID, e.ignoreEditImageURL = d.ignoreEditImageURL, e.ignoreEditImageClass = d.ignoreEditImageClass, e.showMovePanelToggle = d.showMovePanelToggle;
    let m = !1;
    typeof window.matchMedia == "function" && (m = window.matchMedia("(prefers-reduced-motion: reduce)")), e.scrollBehaviour = !m || m.matches ? "auto" : "smooth", e.langDirection = e.html.getAttribute("dir") === "rtl" ? "rtl" : "ltr";
    const h = d.checks.QA_DOCUMENT.sources, A = 'a[href$=".doc"], a[href$=".docx"], a[href*=".doc?"], a[href*=".docx?"], a[href$=".ppt"], a[href$=".pptx"], a[href*=".ppt?"], a[href*=".pptx?"], a[href^="https://drive.google.com/file"], a[href^="https://docs.google."], a[href^="https://sway."]';
    h ? e.documentSources = `${A}, ${h}` : e.documentSources = A;
    const E = d.checks.EMBED_VIDEO.sources, y = 'video, [src*="Video"], [src*="video"], [src*="watch"], [src*="youtube.com"], [src*="vimeo.com"], [src*="panopto.com"], [src*="wistia.com"], [src*="dailymotion.com"], [src*="brightcove.com"], [src*="vidyard.com"]';
    if (E) {
      const _ = E.split(/\s*[\s,]\s*/).map((I) => `[src*="${I}"]`);
      e.VideoSources = `${y}, ${_.join(", ")}`;
    } else
      e.VideoSources = y;
    const b = d.checks.EMBED_AUDIO.sources, v = 'audio, [src*="soundcloud.com"], [src*="simplecast.com"], [src*="podbean.com"], [src*="buzzsprout.com"], [src*="blubrry.com"], [src*="transistor.fm"], [src*="fusebox.fm"], [src*="libsyn.com"], [src*="spotify.com"], [src*="podcasts.apple.com"], [src*="castbox.fm"], [src*="megaphone.fm"], [src*="spreaker.com"], [src*="anchor.fm"], [src*="rss.com"], [src*="redcircle.com"]';
    if (b) {
      const _ = b.split(/\s*[\s,]\s*/).map((I) => `[src*="${I}"]`);
      e.AudioSources = `${v}, ${_.join(", ")}`;
    } else
      e.AudioSources = v;
    const L = d.checks.EMBED_DATA_VIZ.sources, g = '[src*="datastudio"], [src*="tableau"], [src*="lookerstudio"], [src*="powerbi"], [src*="qlik"]';
    if (L) {
      const _ = L.split(/\s*[\s,]\s*/).map((I) => `[src*="${I}"]`);
      e.VisualizationSources = `${g}, ${_.join(", ")}`;
    } else
      e.VisualizationSources = g;
    e.AllEmbeddedContent = `${e.VideoSources}, ${e.AudioSources}, ${e.VisualizationSources}`;
  }
  const s = {};
  function r(d, m, h) {
    if (s.areaToCheck = [], s.Readability = [], h) {
      s.areaToCheck = h, s.Readability = h;
      return;
    }
    try {
      const A = document.querySelectorAll(d);
      A.length > 0 ? A.forEach((E) => {
        u.Root.areaToCheck.push(E);
      }) : console.error(`Sa11y: The target root (${d}) does not exist.`);
    } catch {
      s.areaToCheck.length = 0;
    }
    s.areaToCheck.length === 0 && e.headless === !1 && (je(f.sprintf("MISSING_ROOT", d)), s.areaToCheck.push(document.body));
    try {
      const A = document.querySelectorAll(m);
      A.length > 0 ? A.forEach((E) => {
        u.Root.Readability.push(E);
      }) : console.error(
        `Sa11y: The target readability root (${m}) does not exist.`
      );
    } catch {
      s.Readability.length = 0;
    }
    s.Readability.length === 0 && e.headless === !1 && (s.areaToCheck.length === 0 ? s.Readability.push(document.body) : (s.Readability = s.areaToCheck, setTimeout(() => {
      const { readabilityDetails: A, readabilityToggle: E } = u.Panel, y = E?.getAttribute("aria-pressed") === "true", b = u.Panel.readability.querySelector("#readability-alert");
      if (A && y && !b) {
        const v = s.areaToCheck.map((g) => g.id ? `#${g.id}` : g.className ? `.${g.className.split(/\s+/).filter(Boolean).join(".")}` : g.tagName.toLowerCase()).join(", "), L = document.createElement("div");
        L.id = "readability-alert", L.innerHTML = `<hr><p>${f.sprintf("MISSING_READABILITY_ROOT", v, m)}</p>`, A.insertAdjacentElement("afterend", L);
      }
    }, 100)));
  }
  const a = {};
  function i() {
    const d = document.querySelector("sa11y-control-panel").shadowRoot;
    a.panel = d.getElementById("panel"), a.content = d.getElementById("panel-content"), a.controls = d.getElementById("panel-controls"), a.outline = d.getElementById("outline-panel"), a.outlineContent = d.getElementById("outline-content"), a.outlineList = d.getElementById("outline-list"), a.outlineHeader = d.getElementById("outline-header"), a.images = d.getElementById("images-panel"), a.imagesContent = d.getElementById("images-content"), a.imagesList = d.getElementById("images-list"), a.imagesHeader = d.getElementById("images-header"), a.notifBadge = d.getElementById("notification-badge"), a.notifCount = d.getElementById("notification-count"), a.notifText = d.getElementById("notification-text"), a.status = d.getElementById("status"), a.pageIssues = d.getElementById("page-issues"), a.pageIssuesList = d.getElementById("page-issues-list"), a.pageIssuesHeader = d.getElementById("page-issues-header"), a.pageIssuesContent = d.getElementById("page-issues-content"), a.settings = d.getElementById("settings-panel"), a.settingsHeader = d.getElementById("settings-header"), a.settingsContent = d.getElementById("settings-content"), a.developerToggle = d.getElementById("developer-toggle"), a.readabilityToggle = d.getElementById("readability-toggle"), a.themeToggle = d.getElementById("theme-toggle"), a.developerItem = d.getElementById("developer-item"), a.readabilityItem = d.getElementById("readability-item"), a.darkModeItem = d.getElementById("dark-mode-item"), a.colourPanel = d.getElementById("panel-colour-filters"), a.colourFilterItem = d.getElementById("colour-filter-item"), a.colourFilterSelect = d.getElementById("colour-filter-select"), a.colourFilterIcon = d.getElementById("filter-icon"), a.toggle = d.getElementById("toggle"), a.outlineToggle = d.getElementById("outline-toggle"), a.imagesToggle = d.getElementById("images-toggle"), a.settingsToggle = d.getElementById("settings-toggle"), a.movePanelToggle = d.getElementById("move-panel"), a.skipButton = d.getElementById("skip-button"), a.dismissButton = d.getElementById("dismiss-button"), a.dismissTooltip = d.getElementById("dismiss-tooltip"), a.skipToPageIssues = d.getElementById("skip-to-page-issues"), a.exportHTML = d.getElementById("export-html"), a.exportCSV = d.getElementById("export-csv"), a.alert = d.getElementById("panel-alert"), a.alertText = d.getElementById("panel-alert-text"), a.alertPreview = d.getElementById("panel-alert-preview"), a.alertClose = d.getElementById("close-alert"), a.readability = d.getElementById("readability-panel"), a.readabilityInfo = d.getElementById("readability-info"), a.readabilityDetails = d.getElementById("readability-details");
  }
  const l = {};
  function c(d) {
    if (d.readabilityPlugin) {
      l.Lang = f._("LANG_CODE").substring(0, 2);
      const m = [
        "en",
        "fr",
        "es",
        "de",
        "nl",
        "it",
        "sv",
        "fi",
        "da",
        "no",
        "nb",
        "nn",
        "pt"
      ], h = u.Global.html.getAttribute("lang");
      if (!h)
        l.Plugin = !1;
      else {
        const A = h.toLowerCase().substring(0, 2);
        !m.includes(A) || !m.includes(l.Lang) ? l.Plugin = !1 : l.Plugin = !0;
      }
    }
  }
  const p = {};
  function o(d) {
    p.Sa11yElements = [
      "sa11y-heading-label",
      "sa11y-heading-anchor",
      "sa11y-annotation",
      "sa11y-tooltips",
      "sa11y-panel-tooltips",
      "sa11y-control-panel",
      "#sa11y-colour-filters",
      "#sa11y-colour-filters *"
    ];
    const m = ["style", "script", "noscript"];
    if (p.Container = ["#wpadminbar", "#wpadminbar *", ...m], d.containerIgnore) {
      const h = d.containerIgnore.split(",").map((A) => A.trim());
      p.Container = p.Container.concat(
        h.flatMap((A) => [`${A} *`, A])
      );
    }
    p.Contrast = [
      "link",
      "hr",
      "option",
      "audio",
      "audio *",
      "video",
      "video *",
      'input[type="color"]',
      'input[type="range"]',
      "progress",
      "progress *",
      "meter",
      "meter *",
      "iframe",
      "svg title",
      "svg desc",
      ...m
    ], d.contrastIgnore && (p.Contrast = d.contrastIgnore.split(",").map((h) => h.trim()).flatMap((h) => [h, `${h} *`]).concat(p.Contrast)), p.Readability = ["nav li", '[role="navigation"] li', ...m], d.readabilityIgnore && (p.Readability = d.readabilityIgnore.split(",").map((h) => h.trim()).flatMap((h) => [h, `${h} *`]).concat(p.Readability)), p.Headings = d.headerIgnore ? d.headerIgnore.split(",").map((h) => h.trim()) : [], p.HeaderSpan = d.headerIgnoreSpan ? d.headerIgnoreSpan.split(",").map((h) => h.trim()) : [], p.Outline = d.outlineIgnore ? d.outlineIgnore.split(",").map((h) => h.trim()) : [], p.Images = [
      'img[role="presentation"]:not(a img[role="presentation"]), img[aria-hidden="true"]:not(a img[aria-hidden="true"])'
    ], d.imageIgnore && (p.Images = d.imageIgnore.split(",").map((h) => h.trim()).concat(p.Images)), p.Links = [".anchorjs-link"], d.linkIgnore && (p.Links = d.linkIgnore.split(",").map((h) => h.trim()).concat(p.Links)), p.LinkSpan = d.linkIgnoreSpan ? d.linkIgnoreSpan.split(",").map((h) => h.trim()) : [];
  }
  return {
    initializeRoot: r,
    Root: s,
    initializeGlobal: n,
    Global: e,
    initializePanelSelectors: i,
    Panel: a,
    initializeReadability: c,
    Readability: l,
    initializeExclusions: o,
    Exclusions: p
  };
})();
function te(t, e, n) {
  const s = [];
  e === "document" ? (s.push(document.body), u.Global.fixedRoots && s.push(u.Global.fixedRoots)) : e === "root" ? s.push(u.Root.areaToCheck) : s.push(document.querySelectorAll(e));
  const r = u.Exclusions.Container.join(", "), a = n?.join(", ") || "", i = a ? `, ${a}` : "";
  let l = [];
  return s.flat().filter(Boolean)?.forEach((c) => {
    const p = c?.querySelectorAll("[data-sa11y-has-shadow-root]"), o = p ? ", [data-sa11y-has-shadow-root]" : "", d = Array.from(
      c.querySelectorAll(`:is(${t}${o}):not(${r}${i})`)
    );
    if (p.length) {
      const m = [];
      if (d.forEach((h, A) => {
        h?.matches?.("[data-sa11y-has-shadow-root]") && h?.shadowRoot && (m[A] = h.shadowRoot.querySelectorAll(
          `:is(${t}):not(${r}${i})`
        ));
      }), m.length > 0)
        for (let h = m.length - 1; h >= 0; h--)
          m[h] && d.splice(h, 1, ...m[h]);
    }
    l = l.concat(d.filter((m) => m.parentNode.tagName !== "SLOT"));
  }), l;
}
const M = /* @__PURE__ */ (function() {
  const e = {};
  function n(a) {
    e.Everything = te("*", "root", u.Exclusions.Sa11yElements), e.Contrast = e.Everything.filter((o) => !u.Exclusions.Contrast.some(
      (m) => o.matches(m)
    ) && !u.Exclusions.Contrast.includes(o)), e.Images = e.Everything.filter(
      (o) => o.tagName === "IMG" && !u.Exclusions.Images.some((d) => o.matches(d))
    ), e.Links = e.Everything.filter(
      (o) => (o.tagName === "A" || o.tagName === "a") && o.hasAttribute("href") && !o.matches('[role="button"]') && // Exclude links with [role="button"]
      !u.Exclusions.Links.some((d) => o.matches(d))
    ), e.Headings = te(
      'h1, h2, h3, h4, h5, h6, [role="heading"][aria-level]',
      a.ignoreContentOutsideRoots || a.fixedRoots ? "root" : "document",
      u.Exclusions.Headings
    ), e.HeadingOne = te(
      'h1, [role="heading"][aria-level="1"]',
      a.ignoreContentOutsideRoots || a.fixedRoots ? "root" : "document",
      u.Exclusions.Headings
    ), e.HeadingOverrideStart = /* @__PURE__ */ new WeakMap(), e.HeadingOverrideEnd = /* @__PURE__ */ new WeakMap(), a.initialHeadingLevel && a.initialHeadingLevel.forEach((o) => {
      const d = te(
        `${o.selector} :is(h1,h2,h3,h4,h5,h6,[aria-role=heading][aria-level])`,
        a.ignoreContentOutsideRoots || a.fixedRoots ? "root" : "document",
        u.Exclusions.Headings
      );
      d.length > 0 && (e.HeadingOverrideStart.set(d[0], o.previousHeading), e.HeadingOverrideEnd.set(d.pop(), o.previousHeading));
    }), e.ExcludedHeadings = e.Headings.filter(
      (o) => u.Exclusions.Headings.some((d) => o.matches(d))
    ), e.ExcludedOutlineHeadings = e.Headings.filter(
      (o) => u.Exclusions.Outline.some((d) => o.matches(d))
    ), e.OutlineIgnore = M.Found.ExcludedOutlineHeadings.concat(
      M.Found.ExcludedHeadings
    ), e.Paragraphs = e.Everything.filter(
      (o) => o.tagName === "P" && !o.closest("table")
    ), e.Lists = e.Everything.filter((o) => o.tagName === "LI"), e.Blockquotes = e.Everything.filter((o) => o.tagName === "BLOCKQUOTE"), e.Tables = e.Everything.filter(
      (o) => o.tagName === "TABLE" && !o.matches('[role="presentation"]') && !o.matches('[role="none"]')
    ), e.StrongItalics = e.Everything.filter((o) => ["STRONG", "EM"].includes(o.tagName)), e.Subscripts = e.Everything.filter((o) => ["SUP", "SUB"].includes(o.tagName));
    const i = a.checks.QA_BAD_LINK.sources;
    e.CustomErrorLinks = i.length ? e.Links.filter(
      (o) => i.split(",").some((d) => o.matches(d.trim()))
    ) : [];
    const l = (o) => u.Root.Readability.some((d) => d.contains(o)) && !u.Exclusions.Readability.some((d) => o.matches(d));
    e.Readability = [
      ...e.Paragraphs.filter(l),
      ...e.Lists.filter(l)
    ];
    const c = a.checks.QA_NESTED_COMPONENTS.sources || '[role="tablist"], details';
    e.NestedComponents = e.Everything.filter((o) => o.matches(c)), e.TabIndex = e.Everything.filter(
      (o) => o.hasAttribute("tabindex") && o.getAttribute("tabindex") !== "0" && !o.getAttribute("tabindex").startsWith("-")
    ), e.Svg = e.Everything.filter((o) => o.tagName === "svg"), e.Buttons = e.Everything.filter(
      (o) => o.tagName === "BUTTON" || o.matches('[role="button"]')
    ), e.Inputs = e.Everything.filter(
      (o) => ["INPUT", "SELECT", "TEXTAREA", "METER", "PROGRESS"].includes(o.tagName)
    ), e.Labels = e.Everything.filter((o) => o.tagName === "LABEL"), e.iframes = e.Everything.filter(
      (o) => ["IFRAME", "AUDIO", "VIDEO"].includes(o.tagName)
    ), e.Videos = e.iframes.filter((o) => o.matches(u.Global.VideoSources)), e.Audio = e.iframes.filter((o) => o.matches(u.Global.AudioSources)), e.Visualizations = e.iframes.filter(
      (o) => o.matches(u.Global.VisualizationSources)
    ), e.EmbeddedContent = e.iframes.filter(
      (o) => !o.matches(u.Global.AllEmbeddedContent)
    );
    const p = document.querySelector("html");
    e.Language = p.getAttribute("lang");
  }
  const s = {};
  function r() {
    s.Array = te("sa11y-annotation", "document"), s.Array.forEach((a, i) => {
      a.setAttribute("data-sa11y-position", i);
    });
  }
  return {
    initializeElements: n,
    Found: e,
    initializeAnnotations: r,
    Annotations: s
  };
})(), $s = "[data-sa11y-overflow]{overflow:auto!important}[data-sa11y-error]{outline-offset:2px;outline:5px solid var(--sa11y-error)!important}[data-sa11y-warning]:not([data-sa11y-error]){outline-offset:2px;outline:5px solid var(--sa11y-warning)!important}[data-sa11y-pulse-border]{box-shadow:0;animation:1s 2 pulse;outline:5px solid var(--sa11y-focus-color)!important}[data-sa11y-pulse-border]:hover,[data-sa11y-pulse-border]:focus{animation:none}@keyframes pulse{0%{box-shadow:0 0 0 5px var(--sa11y-focus-color)}50%{box-shadow:0 0 0 12px var(--sa11y-pulse-color)}to{box-shadow:0 0 0 5px var(--sa11y-pulse-color)}}img[data-sa11y-pulse-border],h1[data-sa11y-pulse-border],h2[data-sa11y-pulse-border],h3[data-sa11y-pulse-border],h4[data-sa11y-pulse-border],h5[data-sa11y-pulse-border],h6[data-sa11y-pulse-border]{animation:1s 2 pulse-scale}@keyframes pulse-scale{0%{opacity:1;transform:scale(1)}50%{opacity:.7;transform:scale(1.02)}to{opacity:1;transform:scale(1)}}@media(prefers-reduced-motion:reduce){[data-sa11y-pulse-border]{animation:none!important}}@media(forced-colors:active){[data-sa11y-error],[data-sa11y-warning],[data-sa11y-good],[data-sa11y-error-inline],[data-sa11y-warning-inline],[data-sa11y-pulse-border]{forced-color-adjust:none}}", xn = (t) => {
  if (t.shadowRoot.querySelectorAll(".sa11y-css-utilities").length === 0) {
    const n = document.createElement("style");
    n.setAttribute("class", "sa11y-css-utilities"), n.textContent = $s, t.shadowRoot.appendChild(n);
  }
};
function Fs(t) {
  if (t.autoDetectShadowComponents) {
    const e = u.Exclusions.Sa11yElements, n = document.querySelector(t.checkRoot);
    Array.from(n ? n.querySelectorAll(`*:not(${e})`) : document.body.querySelectorAll(`*:not(${e})`)).forEach((r) => {
      r.shadowRoot && r.shadowRoot.mode === "open" && (r.setAttribute("data-sa11y-has-shadow-root", ""), xn(r));
    });
  } else t.shadowComponents && document.querySelectorAll(t.shadowComponents).forEach((n) => {
    n.setAttribute("data-sa11y-has-shadow-root", ""), xn(n);
  });
}
function Ks(t) {
  document.readyState === "complete" ? t() : window.addEventListener("load", t);
}
function Ws(t) {
  const e = getComputedStyle(t);
  if (e.getPropertyValue("clip-path").startsWith("inset(50%)") || e.clip === "rect(1px, 1px, 1px, 1px)" || e.clip === "rect(0px, 0px, 0px, 0px)")
    return !0;
  const n = parseInt(e.textIndent, 10);
  return !Number.isNaN(n) && Math.abs(n) > 5e3 || e.overflow === "hidden" && parseFloat(e.width) < 2 && parseFloat(e.height) < 2 || e.position === "absolute" && ["left", "right", "top", "bottom"].some((s) => Math.abs(parseInt(e[s], 10)) > 5e3) ? !0 : parseFloat(e.fontSize) < 2;
}
function Me(t) {
  return t.hidden || getComputedStyle(t).getPropertyValue("display") === "none";
}
function pn(t) {
  return t.offsetWidth === 0 && t.offsetHeight === 0 || t.clientHeight === 1 && t.clientWidth === 1 ? !0 : Me(t);
}
function ct(t) {
  const e = document.createElement("div");
  return e.textContent = t, e.innerHTML.replaceAll('"', "&quot;").replaceAll("'", "&#039;").replaceAll("`", "&#x60;");
}
function zs(t) {
  return t.replace(/&(#?[a-zA-Z0-9]+);/g, (e, n) => {
    switch (n) {
      case "amp":
        return "&";
      case "lt":
        return "<";
      case "gt":
        return ">";
      case "quot":
        return "'";
      case "#39":
        return "'";
      // Convert single quotes to actual single quotes.
      default:
        return n.charAt(0) === "#" ? String.fromCharCode(
          n.charAt(1) === "x" ? parseInt(n.substr(2), 16) : parseInt(n.substr(1), 10)
        ) : e;
    }
  });
}
function Vs(t) {
  return t.replace(/<[^>]*>/g, "");
}
function Wt(t) {
  return t.replace(/[^\p{L}\p{N}\s]/gu, "").replace(/\s+/g, " ").trim();
}
function q(t) {
  return t.replace(/[^\w. ]/gi, (e) => `&#${e.charCodeAt(0)};`);
}
function Fe(t) {
  if (!t) return "#";
  const e = String(t).trim();
  if (/^javascript:/i.test(e) || /^data:/i.test(e)) return "#";
  if (!["http:", "https:", "mailto:", "tel:", "ftp:"].some(
    (a) => e.toLowerCase().startsWith(a)
  ) && !e.startsWith("/") && !e.startsWith("#"))
    return `./${e}`;
  const r = e.replace(/<[^>]*>/g, "");
  return encodeURI(r);
}
function Ne(t, e = !1) {
  const n = document.createElement("div");
  return n.innerHTML = t, ["script", "style", "noscript", "iframe", "form"].forEach((r) => {
    const a = n.getElementsByTagName(r);
    for (; a.length > 0; )
      a[0].parentNode.removeChild(a[0]);
  }), Array.from(n.getElementsByTagName("*")).forEach((r) => {
    Array.from(r.attributes).forEach((a) => {
      a.name.startsWith("on") && r.removeAttribute(a.name);
    }), e || r.removeAttribute("style");
  }), n.innerHTML;
}
function qe(t, e) {
  let n = "noscript,script,style,audio,video,form,iframe";
  e && e.length > 0 && (n = `${n},${e.join(",")}`);
  const s = t.cloneNode(!0), r = s.querySelectorAll(n);
  let a = r.length;
  for (; a--; )
    r[a].remove();
  return s;
}
const zt = /* @__PURE__ */ new WeakMap();
function j(t) {
  if (zt.has(t))
    return zt.get(t);
  const n = qe(t).textContent.replace(/[\r\n]+/g, "").replace(/\s+/g, " ").trim();
  return zt.set(t, n), n;
}
function be(t) {
  return t.replace(/[\r\n]+/g, " ").replace(/\s+/g, " ").trim();
}
function Se(t, e) {
  const n = t.substring(0, e).trimEnd();
  return t.length > e ? `${n}...` : t;
}
function Qs(t, e) {
  let n = null;
  return (...s) => {
    window.clearTimeout(n), n = window.setTimeout(() => {
      t(...s);
    }, e);
  };
}
function ht(t, e, n) {
  let s = t;
  for (; s; ) {
    if (window.getComputedStyle(s).getPropertyValue(e) === n)
      return s;
    s = s.parentElement;
  }
  return null;
}
function Vt(t) {
  const e = t.getBoundingClientRect(), n = window.pageYOffset || document.documentElement.scrollTop;
  return { top: e.top + n };
}
const P = {
  getItem(t) {
    try {
      return localStorage.getItem(t) === null ? sessionStorage.getItem(t) : localStorage.getItem(t);
    } catch {
      return !1;
    }
  },
  setItem(t, e) {
    try {
      localStorage.setItem(t, e);
    } catch {
      sessionStorage.setItem(t, e);
    }
    return !0;
  },
  removeItem(t) {
    try {
      localStorage.removeItem(t);
    } catch {
      sessionStorage.removeItem(t);
    }
    return !0;
  }
};
function Dt(t) {
  const e = "data-sa11y-pulse-border";
  t.setAttribute(e, ""), setTimeout(() => t.removeAttribute(e), 2500);
}
function N(t) {
  return String(t).replace(/([^0-9a-zA-Z])/g, "").substring(0, 256);
}
function Ys(t) {
  const e = [];
  let n = t;
  for (; n; ) {
    let s = n.localName;
    if (n.id) {
      s += `#${n.id}`, e.unshift(s);
      break;
    } else {
      const a = n.getAttribute ? n.getAttribute("class") : null;
      if (a) {
        const i = a.trim().replace(/\s+/g, ".");
        i && (s += `.${i}`);
      }
    }
    const r = n.parentNode;
    if (r) {
      const a = r.children;
      if (a.length > 1) {
        const i = Array.prototype.indexOf.call(a, n) + 1;
        s += `:nth-child(${i})`;
      }
      e.unshift(s);
    } else
      break;
    n = n.parentNode.host || n.parentNode;
  }
  return e.join(" > ");
}
function js(t) {
  const e = t.querySelectorAll(
    'a[href]:not([disabled]), button:not([disabled]), input[type="color"]'
  ), n = e[0], s = e[e.length - 1];
  t.addEventListener("keydown", (r) => {
    const a = r.key === "Tab" || r.keyCode === 9, i = t.getRootNode();
    a && (r.shiftKey ? i.activeElement === n && (s.focus(), r.preventDefault()) : i.activeElement === s && (n.focus(), r.preventDefault()));
  });
}
function ts(t, e) {
  t.forEach((n) => {
    te(`[${n}]`, `${e}`).forEach((r) => {
      r.removeAttribute(n);
    });
  });
}
function ns(t, e) {
  te(`${t}`, `${e}`).forEach((s) => {
    s?.parentNode?.removeChild(s);
  });
}
function gt(t, e, n) {
  setTimeout(() => {
    t.scrollHeight > e.clientHeight ? (e.classList.add("scrollable"), t.setAttribute("tabindex", "0"), n && (t.setAttribute("aria-label", n), t.setAttribute("role", "region"))) : e.classList.remove("scrollable");
  }, 50);
}
function ss(t) {
  const e = (i) => i?.split(/,\s+/).pop()?.trim()?.split(/\s+/)[0], n = (i) => i ? new URL(i, window.location.href).href : null, s = e(t.getAttribute("data-src") || t.getAttribute("srcset"));
  if (s)
    return n(s);
  const r = t.closest("picture")?.querySelector("source[srcset]")?.getAttribute("srcset"), a = e(r);
  return n(a || t.getAttribute("src"));
}
const qs = (t) => new Promise((e, n) => {
  const s = new FileReader();
  s.onloadend = () => {
    let { result: r } = s;
    const a = t?.type?.startsWith("image/") ? t.type : "image/png";
    r.startsWith("data:application/octet-stream") && (r = r.replace("data:application/octet-stream", `data:${a}`)), e(r);
  }, s.onerror = n, s.readAsDataURL(t);
});
function as(t, e = !1) {
  const n = t.element, s = Ne(t.htmlPath), r = Se(s, 600), a = `<pre><code>${ct(r)}</code></pre>`, i = (o) => {
    const d = j(o), m = Se(d, 100);
    return d.length ? q(m) : a;
  }, c = {
    SPAN: i,
    P: i,
    A: (o) => {
      const d = j(o), m = Se(d, 100);
      return d.length > 1 && o.href && !o.hasAttribute("role") ? `<a href="${Fe(o.href)}">${q(m)}</a>` : a;
    },
    IMG: (o) => {
      const d = o.closest("a[href]"), m = o.alt ? `alt="${q(o.alt)}"` : "alt", h = ss(o);
      function A(y) {
        return d ? `<a href="${Fe(d.href)}" rel="noopener noreferrer"><img src="${y}" ${m}/></a>` : `<img src="${y}" ${m}/>`;
      }
      if (e)
        return new Promise((y) => {
          if (h)
            if (new URL(h, window.location.origin).origin === window.location.origin)
              fetch(h).then((v) => v.blob()).then((v) => qs(v)).then((v) => {
                const L = v.startsWith("data:image/") ? v : Fe(v);
                y(A(L));
              }).catch(() => {
                y(A(h));
              });
            else {
              const v = h.startsWith("data:image/") ? h : Fe(h);
              y(A(v));
            }
          else
            y(a);
        });
      const E = h.startsWith("data:image/") ? h : Fe(h);
      return h ? A(E) : a;
    },
    IFRAME: (o) => {
      const d = o.src, m = o.title ? o.title : "", A = o.getAttribute("aria-label") || "";
      if (d) {
        const E = A || m;
        return `<iframe src="${Fe(d)}" aria-label="${q(E)}"></iframe>`;
      }
      return a;
    },
    AUDIO: () => Ne(t.htmlPath),
    VIDEO: () => Ne(t.htmlPath)
  }[n.tagName];
  return c ? c(n) : a;
}
function is(t, e, n = [], s) {
  let r = "";
  const a = n?.length ? n.join(",") : "", i = Array.isArray(s) ? s : null, l = (o = "") => i ? i.reduce((d, m) => d.replace(m, ""), o) : o;
  t.childNodes.forEach((o) => {
    o.nodeType === Node.TEXT_NODE && (r += l(o.textContent)), o.nodeType === Node.ELEMENT_NODE && (a && o.matches(a) || pn(o) || (r += l(j(o))));
  });
  const c = /[\p{Emoji_Presentation}\p{Extended_Pictographic}]/gu;
  let p = r.replace(c, "");
  return p = be(p).toLowerCase(), p === "x" ? !1 : p.length !== 0 && !e.toLowerCase().includes(p);
}
function Xs(t) {
  let e = t.getAttribute("href");
  return e = be(e).toLowerCase(), e.endsWith("/") && (e = e.slice(0, -1)), e = e.replace(/^https?:\/\/(www\.)?/, ""), e = e.replace(/\.(html|php|htm|asp|aspx)$/i, ""), e;
}
function rs(t, e) {
  let n = 0;
  const s = (r) => {
    if (!["ArrowUp", "ArrowDown", "Space"].includes(r.code))
      return;
    if (r.code === "Space") {
      e[n].click(), r.preventDefault();
      return;
    }
    e[n].setAttribute("tabindex", -1);
    let i;
    r.code === "ArrowDown" ? (i = n + 1, n === e.length - 1 && (i = 0)) : r.code === "ArrowUp" && (i = n - 1, n === 0 && (i = e.length - 1)), e[i].setAttribute("tabindex", 0), e[i].focus(), n = i, r.preventDefault();
  };
  t.addEventListener("focus", () => {
    e.length > 0 && (t.setAttribute("tabindex", -1), e[n].setAttribute("tabindex", 0), e[n].focus()), t.addEventListener("keydown", s);
  }), t.addEventListener("blur", () => {
    t.removeEventListener("keydown", s);
  });
}
function os() {
  return CSS.supports("anchor-name: --sa11y") && CSS.supports("position-anchor: --sa11y");
}
function Re(t, e = !1) {
  if (!t) return null;
  if (t instanceof RegExp) return t;
  let n = [];
  if (Array.isArray(t))
    n = t;
  else if (typeof t == "string")
    n = t.split(",").map((i) => i.trim());
  else
    return null;
  if (n = n.filter((i) => i && i.length > 0), n.length === 0) return null;
  const s = (i) => i.replace(/[.*+?^${}()|[\]\\]/g, "\\$&"), r = n.map(s).join("|"), a = e ? `^(?:${r})` : r;
  return new RegExp(a, "gi");
}
const Js = ":host{z-index:999999;background:var(--sa11y-panel-bg);border-top:5px solid var(--sa11y-panel-bg-splitter);width:100%;height:fit-content;display:block;position:fixed;bottom:0;left:0;right:0}*{font-size:var(--sa11y-normal-text);color:var(--sa11y-panel-primary);font-family:var(--sa11y-font-face)!important;-webkit-font-smoothing:auto!important;line-height:22px!important}#dialog{max-width:900px;margin:20px auto;padding:20px}h2{font-size:var(--sa11y-large-text);margin-top:0}a{color:var(--sa11y-hyperlink);cursor:pointer;text-decoration:underline}a:hover,a:focus{text-decoration:none}p{margin-top:0}.error{color:var(--sa11y-error-text);background:var(--sa11y-error);border:2px dashed #f08080;margin-bottom:0;padding:5px}", mt = '.visually-hidden{clip:rect(1px,1px,1px,1px);white-space:nowrap;clip-path:inset(50%);border:0;width:1px;height:1px;padding:0;display:block;position:absolute;overflow:hidden}[hidden]{display:none!important}h2,.header-text-inline,.header-text{font-size:var(--sa11y-large-text);color:var(--sa11y-panel-primary);margin-bottom:3px;font-weight:600;display:block}.header-text-inline{display:inline-block!important}code{font-size:calc(var(--sa11y-normal-text) - 1px);font-weight:600;font-family:monospace!important}pre code{white-space:pre-wrap;overflow:auto}pre,code,kbd,.kbd{color:var(--sa11y-panel-primary);background-color:var(--sa11y-panel-badge);border-radius:3.2px;padding:1.6px 4.8px}.bold{font-weight:600}.error .colour,.red-text{font-family:var(--sa11y-font-face);color:var(--sa11y-red-text)}.warning .colour,.yellow-text{font-family:var(--sa11y-font-face);color:var(--sa11y-yellow-text)}.normal-badge,.badge{min-width:10px;color:var(--sa11y-panel-primary);text-align:center;white-space:nowrap;vertical-align:baseline;background-color:var(--sa11y-panel-badge);border-radius:10px;outline:1px solid #0000;padding:1px 5px 1.75px;font-size:14px;line-height:1;display:inline;font-weight:700!important}.error .badge{color:var(--sa11y-error-text);background:var(--sa11y-error)}.error-badge{color:var(--sa11y-error-text)!important;background:var(--sa11y-error)!important}.warning .badge{color:var(--sa11y-panel-bg);background:var(--sa11y-yellow-text)}.warning-badge{color:var(--sa11y-panel-bg)!important;background:var(--sa11y-yellow-text)!important}.good-contrast{color:var(--sa11y-good-text)!important;background:var(--sa11y-good)!important}#contrast-preview{overflow-wrap:break-word;border:2px dashed var(--sa11y-panel-bg-splitter);background-color:#e8e8e8;background-image:linear-gradient(45deg,#ccc 25%,#0000 25% 75%,#ccc 75%,#ccc),linear-gradient(45deg,#ccc 25%,#0000 25% 75%,#ccc 75%,#ccc);background-position:0 0,5px 5px;background-size:10px 10px;border-radius:3.2px;max-height:100px;margin-top:10px;padding:5px;line-height:1;overflow:clip}#contrast-preview:empty{display:none}#color-pickers{justify-content:space-between;margin-top:10px;margin-bottom:10px;display:flex}#color-pickers label{align-items:center;display:flex}#color-pickers input{cursor:pointer;margin-inline-start:7px}#fg-color-wrapper.unknown,#bg-color-wrapper.unknown{display:inline-block;position:relative}:is(#fg-color-wrapper.unknown,#bg-color-wrapper.unknown):after{z-index:2;color:#fff;pointer-events:none;content:"?";justify-content:center;align-items:center;width:44px;height:44px;margin:-46px 7px;font-size:22px;display:flex;position:absolute}input[type=color i]{background:var(--sa11y-panel-bg-secondary);border-color:var(--sa11y-button-outline);border-style:solid;border-width:1px;border-radius:50%;block-size:44px;inline-size:44px;padding:2px}input[type=color i]::-webkit-color-swatch-wrapper{padding:1px}input[type=color i]::-webkit-color-swatch{border-color:var(--sa11y-button-outline);border-radius:50%}input[type=color i]::-moz-color-swatch{border-color:var(--sa11y-button-outline);border-radius:50%}input[type=color i].unknown{box-shadow:0 0 0 3px var(--sa11y-yellow-text)}.close-btn{float:var(--sa11y-float-rtl);width:32px;height:32px;font-size:var(--sa11y-normal-text);color:var(--sa11y-panel-primary);cursor:pointer;background:var(--sa11y-panel-bg-secondary);border:2px solid var(--sa11y-button-outline);border-radius:50%;margin:0;font-weight:400;transition:all .2s ease-in-out;position:relative}.close-btn:hover,.close-btn:focus{background-color:var(--sa11y-shortcut-hover)}.close-btn:after{content:"";background:var(--sa11y-setting-switch-bg-off);-webkit-mask:var(--sa11y-close-btn-svg)center no-repeat;mask:var(--sa11y-close-btn-svg)center no-repeat;position:absolute;inset:-7px}@media screen and (forced-colors:active){.close-btn:after{filter:invert()}}#container [tabindex="0"]:focus,#container [tabindex="-1"]:focus,#container input:focus,#container select:focus,#container button:focus,#container a:focus{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}#container .switch:focus,#container #panel-controls button:focus{box-shadow:inset 0 0 0 4px var(--sa11y-focus-color);outline:0}#container [tabindex="0"]:focus:not(:focus-visible),#container [tabindex="-1"]:focus:not(:focus-visible),#container input:focus:not(:focus-visible),#container button:focus:not(:focus-visible),#container select:focus:not(:focus-visible),#container #panel-controls button:focus:not(:focus-visible){box-shadow:none;outline:0}#container a:focus-visible,#container button:not(#panel-controls button,.switch):focus-visible,#container select:focus-visible,#container input:focus-visible,#container [tabindex="0"]:focus-visible,#container [tabindex="-1"]:focus-visible{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}#container .switch:focus-visible,#container #panel-controls button:focus-visible{box-shadow:inset 0 0 0 4px var(--sa11y-focus-color);outline:0}@media screen and (forced-colors:active){#panel-controls button:focus{border:inset 3px solid transparent}.close-btn:focus{outline:3px solid #0000!important}#container a:focus,#container [tabindex="-1"]:focus,#container [tabindex="0"]:focus,#container select:focus,#container button:focus{outline:3px solid #0000!important}}';
class Nn extends HTMLElement {
  constructor(e) {
    super(), this.error = e;
  }
  connectedCallback() {
    const e = this.attachShadow({ mode: "open" }), n = document.createElement("style");
    n.innerHTML = Js + mt, e.appendChild(n);
    const s = document.createElement("div");
    s.setAttribute("id", "dialog"), s.setAttribute("tabindex", "-1");
    const r = window.location, a = "https://forms.gle/sjzK9XykETaoqZv99", i = `## Error Description
\`\`\`javascript
${this.error.stack}
\`\`\`

## Details
- **URL:** ${r}
- **Version:** 4.4.1

## Comments
`, c = `https://github.com/ryersondmp/sa11y/issues/new?title=Bug%20report&body=${encodeURIComponent(i)}`;
    s.innerHTML = `
      <button class="close-btn" aria-label="${f._("ALERT_CLOSE")}"></button>
      <h2>${f._("ERROR")}</h2>
      <p>${f.sprintf("CONSOLE_ERROR", a, c)}</p>
      <p class="error">${ct(this.error.stack)}<br><br>Version: 4.4.1 <br> URL: ${r}</p>
    `, e.appendChild(s), setTimeout(() => {
      u.Panel.toggle.style.display = "none";
      const p = document.querySelector("sa11y-console-error");
      p.shadowRoot.getElementById("dialog").focus(), p.shadowRoot.querySelector(".close-btn").addEventListener("click", () => {
        p.remove();
      });
    }, 0);
  }
}
function Zs(t, e, n) {
  if (t === !0) {
    let s = window.location.href;
    const r = Qs(async () => {
      s !== window.location.href && (P.getItem("sa11y-panel") === "Closed" || !P.getItem("sa11y-panel") ? e() : (n(!1), await e()), s = window.location.href);
    }, 250);
    window.addEventListener("click", r), window.addEventListener("keydown", r);
  }
}
function ea(t, e) {
  const n = JSON.parse(localStorage.getItem("sa11y-dismissed") || "[]"), s = window.location.pathname, r = (m, h) => h.key.includes(m.dismiss) && h.href === s && (m.type === "warning" || m.type === "good"), a = (m, h) => typeof h.dismissAll == "string" && m.dismissAll === h.dismissAll && h.href === s, i = t.filter(
    (m) => n.some((h) => r(m, h))
  ), l = t.filter(
    (m) => n.some((h) => a(m, h))
  ), c = [...i, ...l], p = [
    ...new Map(c.map((m) => [m.dismiss, m])).values()
  ], o = p.length, d = t.filter(
    (m) => !p.some(
      (h) => h.dismiss === m.dismiss && (m.type === "warning" || m.type === "good")
    )
  );
  return o ? (u.Panel.dismissButton.classList.add("active"), u.Panel.dismissTooltip.innerText = f.sprintf("PANEL_DISMISS_BUTTON", o), e.object.setContent(f.sprintf("PANEL_DISMISS_BUTTON", o))) : u.Panel.dismissButton.classList.remove("active"), { dismissedIssues: n, updatedResults: d, dismissCount: o, dismissedResults: p };
}
let tn, Ot;
const ta = async (t, e, n, s) => {
  let r = JSON.parse(P.getItem("sa11y-dismissed"));
  const a = t.target, i = document.querySelector("sa11y-panel-tooltips");
  if (i.hidden = !1, a.tagName === "BUTTON" && a.hasAttribute("data-sa11y-dismiss")) {
    const l = parseInt(a.getAttribute("data-sa11y-dismiss"), 10), c = e.find((p) => p.id === l);
    if (r === null && (setTimeout(() => je(f._("DISMISS_REMINDER")), 0), r = []), c.dismiss) {
      const p = a.hasAttribute("data-sa11y-dismiss-all") ? c.dismissAll : "", o = {
        key: c.dismiss,
        href: window.location.pathname,
        ...p ? { dismissAll: p } : {}
      }, d = te(`[data-sa11y-annotation='${c.id}']`, "root"), m = d[0] ? d[0].getAttribute("data-sa11y-position") : 0;
      P.setItem("sa11y-latest-dismissed", m), P.setItem("sa11y-dismiss-item", JSON.stringify(o)), r.push(o), P.setItem("sa11y-dismissed", JSON.stringify(r)), P.removeItem("sa11y-dismiss-item");
      const h = a?.closest("[data-tippy-root]");
      h && setTimeout(() => {
        h.remove();
      }, 0), s(!1), await n();
    }
  }
}, na = async (t, e, n) => {
  const s = document.querySelector("sa11y-panel-tooltips");
  s.hidden = !0;
  const r = t.filter((a) => a.href !== window.location.pathname);
  P.setItem("sa11y-dismissed", JSON.stringify(r)), u.Panel.dismissButton.classList.remove("active"), n(!1), await e();
};
function sa(t, e, n, s) {
  u.Global.dismissAnnotations && (Ot = (a) => ta(a, t, n, s), document.querySelector("sa11y-tooltips").shadowRoot.addEventListener("click", Ot), u.Panel.panel.addEventListener("click", Ot)), tn = () => na(e, n, s), u.Panel.dismissButton?.addEventListener("click", tn);
}
function aa() {
  u.Panel.panel?.removeEventListener("click", Ot), u.Panel.dismissButton?.removeEventListener("click", tn);
}
function ia() {
  if (u.Global.colourFilterPlugin && u.Global.headless === !1) {
    const t = document.createElement("div");
    t.id = "sa11y-colour-filters", t.innerHTML = `
        <!-- DaltonLens SVG filters to simulate color vision deficiencies -->
        <svg id="sa11y-svg-filters" aria-hidden="true" xmlns="http://www.w3.org/2000/svg">
          <filter id="sa11y-protanopia" color-interpolation-filters="linearRGB">
            <feColorMatrix type="matrix" in="SourceGraphic" values="
                0.10889,0.89111,-0.00000,0,0
                0.10889,0.89111,0.00000,0,0
                0.00447,-0.00447,1.00000,0,0
                0,0,0,1,0"
            />
          </filter>
          <filter id="sa11y-deuteranopia" color-interpolation-filters="linearRGB">
            <feColorMatrix type="matrix" in="SourceGraphic" values="
                0.29031,0.70969,-0.00000,0,0
                0.29031,0.70969,-0.00000,0,0
                -0.02197,0.02197,1.00000,0,0
                0,0,0,1,0"
            />
          </filter>
          <filter id="sa11y-tritanopia" color-interpolation-filters="linearRGB">
            <feColorMatrix type="matrix" in="SourceGraphic" values="
              0.950, 0.050, 0.000, 0, 0
              0.000, 0.433, 0.567, 0, 0
              0.000, 0.475, 0.525, 0, 0
              0.000, 0.000, 0.000, 1, 0
            "/>
          </filter>
          <filter id="sa11y-monochromacy">
            <feColorMatrix values="0.299,0.587,0.114,0,0,0.299,0.587,0.114,0,0,0.299,0.587,0.114,0,0,0,0,0,1,0"></feColorMatrix>
          </filter>
        </svg>`, document.body.appendChild(t);
  }
}
function ls() {
  u.Global.colourFilterPlugin && (document.body.removeAttribute("data-sa11y-filter"), u.Panel.settingsContent.classList.remove("hide-settings-border"), u.Panel.colourFilterSelect.value = 0, u.Panel.colourPanel.removeAttribute("data-colour"), u.Panel.colourPanel.classList.remove("active"), u.Panel.colourFilterSelect.classList.remove("active"), u.Panel.content.hidden = !1, u.Panel.controls.hidden = !1);
}
const ra = `:root{--font-primary:system-ui,"Segoe UI",roboto,helvetica,arial,sans-serif;--font-secondary:consolas,monaco,"Ubuntu Mono","Liberation Mono","Courier New",courier,monospace;--body-text:#333;--bg-primary:#fff;--bg-secondary:#f6f8fa;--bg-tertiary:#d7d7d7;--link-primary:#004c9b;--red-text:#d30017;--warning-text:#966f0d;--hr:#d7d7d74d;--sa11y-link-icon-svg:url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 640 512'%3E%3Cpath d='M579.8 267.7c56.5-56.5 56.5-148 0-204.5c-50-50-128.8-56.5-186.3-15.4l-1.6 1.1c-14.4 10.3-17.7 30.3-7.4 44.6s30.3 17.7 44.6 7.4l1.6-1.1c32.1-22.9 76-19.3 103.8 8.6c31.5 31.5 31.5 82.5 0 114L422.3 334.8c-31.5 31.5-82.5 31.5-114 0c-27.9-27.9-31.5-71.8-8.6-103.8l1.1-1.6c10.3-14.4 6.9-34.4-7.4-44.6s-34.4-6.9-44.6 7.4l-1.1 1.6C206.5 251.2 213 330 263 380c56.5 56.5 148 56.5 204.5 0L579.8 267.7zM60.2 244.3c-56.5 56.5-56.5 148 0 204.5c50 50 128.8 56.5 186.3 15.4l1.6-1.1c14.4-10.3 17.7-30.3 7.4-44.6s-30.3-17.7-44.6-7.4l-1.6 1.1c-32.1 22.9-76 19.3-103.8-8.6C74 372 74 321 105.5 289.5L217.7 177.2c31.5-31.5 82.5-31.5 114 0c27.9 27.9 31.5 71.8 8.6 103.9l-1.1 1.6c-10.3 14.4-6.9 34.4 7.4 44.6s34.4 6.9 44.6-7.4l1.1-1.6C433.5 260.8 427 182 377 132c-56.5-56.5-148-56.5-204.5 0L60.2 244.3z'/%3E%3C/svg%3E")}@media(prefers-color-scheme:dark){:root{--body-text:#dde8ff;--bg-primary:#0a2051;--bg-secondary:#072c7c;--bg-tertiary:#0041c9;--link-primary:#64b2ff;--red-text:#ffa2a2;--warning-text:#ffdb59;--hr:#0041c94d}}*{margin:0;padding:0}article,aside,nav,ol,p,pre,section,ul{margin-bottom:1rem}body{max-width:70ch;font-family:var(--font-primary);color:var(--body-text);word-break:break-word;overflow-wrap:break-word;background:var(--bg-primary);margin:0 auto;padding:2rem;font-size:1rem;line-height:1.5;overflow-x:hidden}h1,h2,h3{color:var(--body-text);margin-bottom:8px;padding-top:.875rem;padding-bottom:2px;line-height:1}h1{font-size:2.25rem}h2{font-size:1.85rem}h3{font-size:1.55rem}a{color:var(--link-primary)}a:hover,a:focus{text-decoration:none}header,footer{background:var(--bg-secondary);padding:2rem calc(50vw - 50%)}header{border-bottom:1px solid var(--bg-tertiary);margin:-2rem calc(-50vw + 50%) 2rem}footer{text-align:center;border-top:1px solid var(--bg-tertiary);margin:3rem calc(-50vw + 50%) -2rem}header>:first-child{margin-top:0;padding-top:0}header>:last-child{margin-bottom:0}hr{background:var(--hr);opacity:1;border:none;height:1px;margin:10px 0;padding:0}code,samp,kbd,pre{font-family:var(--font-secondary);background:var(--bg-secondary);border:1px solid var(--bg-tertiary);border-radius:4px;padding:3px 6px;font-size:.9rem}pre{max-width:100%;padding:1rem 1.4rem;display:block;overflow:auto}pre code{font-size:inherit;color:inherit;background:inherit;border:0;margin:0;padding:0}code pre{font-size:inherit;color:inherit;background:inherit;border:0;margin:0;padding:0;display:inline}details{background:var(--bg-primary);border:2px solid var(--link-primary);border-radius:4px;padding:.6rem 1rem}summary{cursor:pointer;font-weight:700}details[open]{padding-bottom:.75rem}details[open] summary{margin-bottom:6px}details[open]>:last-child{margin-bottom:0}.two-columns{display:flex}.column{flex:1;margin-inline-end:20px}.count{max-width:220px}dl{padding-top:10px}.column dl{width:100%}dt{font-weight:700}dd{padding-bottom:10px}ul ul,ol ul,ul ol,ol ol{margin-bottom:0}ul li{margin-bottom:.5rem}ol,ul{padding-left:2rem}ol li:not(li li){margin-bottom:4rem}iframe,img{background:var(--bg-tertiary);border-radius:5px;max-width:50%;padding:5px;display:block}video,audio{border:0;display:block}.red-text{color:var(--red-text)}.visually-hidden{clip:rect(1px,1px,1px,1px);white-space:nowrap;clip-path:inset(50%);border:0;width:1px;height:1px;padding:0;display:block;position:absolute;overflow:hidden}.badge{color:#fff;text-align:center;white-space:nowrap;vertical-align:baseline;border-radius:10px;outline:1px solid #0000;min-width:10px;padding:1px 5px 1.75px;font-size:14px;line-height:1;display:inline;font-weight:700!important}.error .colour{color:var(--red-text)}.error .badge{color:#fff;background:#d30017}.warning .colour{color:var(--warning-text)}.warning .badge{color:#fff;background:#966f0d}.link-icon{width:16px;height:16px;-webkit-mask:var(--sa11y-link-icon-svg)center no-repeat;mask:var(--sa11y-link-icon-svg)center no-repeat;background:#fff;margin-bottom:-3.5px;display:inline-block}li pre,li li pre,li li img,li li iframe,li li video,li li audio{margin-top:1rem}li li{margin-top:1rem;list-style:none}`;
function un() {
  const t = /* @__PURE__ */ new Date(), e = String(t.getDate()).padStart(2, "0"), n = String(t.getMonth() + 1).padStart(2, "0"), s = t.getFullYear(), r = (/* @__PURE__ */ new Date()).toLocaleString(), a = `${n}-${e}-${s}`, i = document.querySelector("head title"), l = !i || i.textContent.trim().length === 0, c = l ? "" : i.textContent, p = window.location.href;
  return { date: r, numericDate: a, titleCheck: l, metaTitle: c, pageURL: p };
}
async function oa(t, e) {
  const n = t.filter((y) => y.type === "error"), s = t.filter((y) => y.type === "warning"), r = { error: n.length, warning: s.length, dismiss: e.length };
  async function a(y, b) {
    const L = {
      error: f._("ERRORS"),
      warning: f._("WARNINGS"),
      dismissed: f._("DISMISSED")
    }[b];
    if (!(y.length > 0))
      return "";
    let _ = `<h2>${L}</h2>`, I = `<ol class="${b}">`, S = "</ol>";
    b === "dismissed" && (I = `<details><summary>${f.sprintf("PANEL_DISMISS_BUTTON", r.dismiss)}</summary><ol>`, S = "</details>"), _ += I;
    const x = y.map(async (k) => {
      let D = "";
      if (k.element) {
        const U = ["IMG", "IFRAME", "AUDIO", "VIDEO"], W = await as(k, !0);
        U.includes(k.element.tagName) ? D = `<li><strong>${f._("PREVIEW")}:</strong> ${W}</li><li><strong>${f._("ELEMENT")}:</strong> <pre><code>${ct(k.htmlPath)}</code></pre></li>` : D = `<li><strong>${f._("ELEMENT")}:</strong> <pre><code>${ct(k.htmlPath)}</code></pre></li>`;
      }
      const H = k.cssPath ? `<li><strong>${f._("PATH")}:</strong> <pre><code>${k.cssPath}</code></pre></li>` : "";
      return `<li>${k.content} <ul>${D}${H}</ul></li>`;
    }), C = await Promise.all(x);
    return _ += C.join(""), _ += S, _;
  }
  const i = await a(n, "error"), l = await a(s, "warning"), c = await a(e, "dismissed"), p = un(), o = p.titleCheck ? "" : `<dt>${f._("PAGE_TITLE")}</dt><dd>${p.metaTitle}</dd>`, d = r.error !== 0 ? `<dt>${f._("ERRORS")}</dt><dd>${r.error}</dd>` : "", m = r.warning !== 0 ? `<dt>${f._("WARNINGS")}</dt><dd>${r.warning}</dd>` : "", h = r.dismiss !== 0 ? `<dt>${f._("DISMISSED")}</dt><dd>${r.dismiss}</dd>` : "";
  return `
      <!DOCTYPE html>
      <html lang="${f._("LANG_CODE")}">
      <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>${f._("RESULTS")}: ${p.metaTitle}</title>
        <style>${ra}</style>
      </head>
      <body>
        <header>
          <h1>${f._("RESULTS")}</h1>
          <dl class="two-columns">
            <div class="column">
              ${o}
              <dt>URL</dt>
              <dd><a href="${p.pageURL}">${p.pageURL}</a></dd>
              <dt>${f._("DATE")}</dt>
              <dd>${p.date}</dd>
            </div>
            <div class="column count">
              ${d}
              ${m}
              ${h}
            </div>
        </dl>
        </header>
        <main>
          ${i}
          ${l}
          ${c}
        </main>
        <footer>
          <p>${f.sprintf("GENERATED", '<a href="https://sa11y.netlify.app">Sa11y</a>')}</p>
        </footer>
      </body>
      </html>
    `;
}
async function la(t, e) {
  const n = await oa(t, e), s = un(), r = new Blob([n], { type: "text/html" }), a = document.createElement("a"), i = s.titleCheck ? "" : `_${s.metaTitle.trim().replace(/ /g, "")}`;
  a.href = window.URL.createObjectURL(r), a.download = `Sa11y_${s.numericDate + i}.html`, document.body.appendChild(a), a.click(), setTimeout(() => {
    document.body.removeChild(a), window.URL.revokeObjectURL(a.href);
  }, 100);
}
function ca(t) {
  const e = un(), n = t.filter((o) => o.type === "warning" || o.type === "error").map((o) => {
    const { type: d, content: m, htmlPath: h, cssPath: A } = o, E = m.replaceAll(/<span\s+class="visually-hidden"[^>]*>.*?<\/span>/gi, "").replaceAll('<hr aria-hidden="true">', " | ").replaceAll(/"/g, '""'), y = Vs(String(E)), b = zs(y), v = {
      Title: `"${e.metaTitle}"`,
      URL: `"${e.pageURL}"`,
      Type: `"${String(d)}"`,
      Issue: `"${b}"`,
      Element: `"${h}"`
    };
    return A && (v.Path = `"${A}"`), v;
  }), s = Object.keys(n[0]), r = `${s.join(",")}
${n.map((o) => s.map((d) => o[d]).join(",")).join(`
`)}`, a = new Uint8Array([239, 187, 191]), i = new Blob([a, r], { type: "text/csv;charset=utf-8;" }), l = window.URL.createObjectURL(i), c = document.createElement("a");
  c.href = l, c.href = window.URL.createObjectURL(i);
  const p = e.titleCheck ? "" : `_${e.metaTitle.trim().replace(/ /g, "")}`;
  c.setAttribute("download", `Sa11y_${e.numericDate + p}.csv`), document.body.appendChild(c), c.click(), setTimeout(() => {
    document.body.removeChild(c), window.URL.revokeObjectURL(c.href);
  }, 100);
}
let nn, sn;
function da(t, e) {
  u.Global.exportResultsPlugin && (nn = async () => {
    await la(t, e);
  }, sn = () => {
    ca(t);
  }, u.Panel.exportHTML.addEventListener("click", nn), u.Panel.exportCSV.addEventListener("click", sn));
}
function pa() {
  u.Global.exportResultsPlugin && (u.Panel.exportHTML.removeEventListener("click", nn), u.Panel.exportCSV.removeEventListener("click", sn));
}
function ua(t, e) {
  u.Panel.toggle.addEventListener("click", (n) => {
    P.getItem("sa11y-panel") === "Opened" ? (n.preventDefault(), P.setItem("sa11y-panel", "Closed"), u.Panel.toggle.classList.remove("on"), u.Panel.toggle.setAttribute("aria-expanded", "false"), e(), u.Panel.notifCount.innerHTML.trim().length === 0 ? u.Panel.notifBadge.style.display = "none" : u.Panel.notifBadge.style.display = "flex") : (n.preventDefault(), P.setItem("sa11y-panel", "Opened"), u.Panel.toggle.classList.add("on"), u.Panel.toggle.setAttribute("aria-expanded", "true"), t(), gt(u.Panel.outlineList, u.Panel.outlineContent));
  }), P.getItem("sa11y-panel") === "Opened" && (u.Panel.toggle.classList.add("on"), u.Panel.toggle.setAttribute("aria-expanded", "true"), u.Panel.panel.style.transform = ""), document.onkeydown = (n) => {
    const s = n || window.event;
    s.altKey && s.code === "KeyA" && (u.Panel.toggle.click(), u.Panel.toggle.focus());
  };
}
const fa = 'h1,h2,h3,div,p,span,ol,ul,li,a,label,button,svg,strong,kbd,pre,code{all:unset;box-sizing:border-box!important}:before,:after{all:unset}div{display:block}*{font-family:var(--sa11y-font-face)!important;-webkit-font-smoothing:auto!important}p,ol,ul,li,label{font-size:var(--sa11y-normal-text);text-align:start;letter-spacing:normal;word-break:break-word;font-weight:400;line-height:22px!important}.sa11y-overflow{overflow:auto}img,video,iframe{border:0;max-width:100%;height:auto;display:block}audio{max-width:100%}#toggle{bottom:var(--sa11y-toggle-y-offset);z-index:2147483644;color:#fff;cursor:pointer;background:linear-gradient(#00bcd4,#e040fb);background-color:var(--sa11y-setting-switch-bg-off);width:55px;height:55px;background-size:150% 150%;border-radius:50%;justify-content:center;align-items:center;margin:0;transition:all .2s ease-in-out;display:flex;position:fixed;inset-inline-end:var(--sa11y-toggle-x-offset);overflow:visible}#toggle.left,#toggle.top-left{inset-inline-start:var(--sa11y-toggle-x-offset)}#toggle.top-left,#toggle.top-right{top:var(--sa11y-toggle-y-offset);bottom:unset}@media screen and (forced-colors:active){#toggle{border:2px solid #0000;background:buttonface!important}}#toggle svg{width:35px;height:35px}#toggle svg path{fill:var(--sa11y-panel-bg)}#toggle:hover,#toggle:focus{animation:3s sa11y-toggle-gradient}#toggle:disabled:hover,#toggle:disabled:focus{animation:none}#toggle.on{background:linear-gradient(#e040fb,#00bcd4)}#toggle:disabled{cursor:not-allowed;background:unset;background-color:var(--sa11y-setting-switch-bg-off)}#notification-badge{color:#fff;text-wrap:nowrap;background-color:#eb0000;border:1px solid #0000;border-radius:12px;justify-content:center;align-items:center;min-width:20px;padding:2.5px;font-size:13.5px;font-weight:400;line-height:1;display:none;position:absolute;top:-5.5px;right:-3px}#notification-badge.notification-badge-warning{color:var(--sa11y-warning-text);background-color:var(--sa11y-warning-hover);border:1px solid var(--sa11y-warning)}#panel{bottom:calc(var(--sa11y-toggle-y-offset) + var(--sa11y-panel-y-gap));z-index:2147483643;visibility:hidden;background:var(--sa11y-panel-bg);opacity:0;transition:transform .2s,opacity .2s background .2s;transform-origin:100% 100%;border-radius:4px;position:fixed;inset-inline-end:calc(var(--sa11y-toggle-x-offset) + var(--sa11y-panel-x-gap));overflow:visible;transform:scale(0);box-shadow:0 0 20px 4px #9aa1b126,0 4px 80px -8px #24282f40,0 4px 4px -2px #5b5e6926}#panel.left,#panel.top-left{inset-inline-start:calc(var(--sa11y-toggle-x-offset) + var(--sa11y-panel-x-gap));inset-inline-end:unset}#panel.top-right,#panel.top-left{top:calc(var(--sa11y-toggle-y-offset) + var(--sa11y-panel-y-gap) + 10px);bottom:unset}#panel.active{visibility:visible;opacity:1;transform-origin:100% 100%;height:auto;transition:transform .2s,opacity .2s;transform:scale(1)}@media screen and (forced-colors:active){#panel{border:2px solid #0000}}#panel.active.left,[dir=rtl] #panel.active{transform-origin:0 100%}#panel.active.top-left{transform-origin:0 0}#panel.active.top-right{transform-origin:100% 0}#panel-alert{opacity:0;display:none}#panel-alert.active{opacity:1;display:block}#panel-alert-content{max-height:400px;color:var(--sa11y-panel-primary);border-bottom:1px solid var(--sa11y-panel-bg-splitter);align-items:center;padding:15px 20px 15px 15px;line-height:22px;position:relative;overflow-y:auto}:is(.top-left,.top-right) #panel-alert-content{border:0}#panel-alert-preview .close-tooltip{display:none}#panel-alert-preview,#panel-alert-text{font-family:var(--sa11y-font-face);font-size:var(--sa11y-normal-text);font-weight:400;line-height:22px}.panel-alert-preview{background:var(--sa11y-panel-bg-secondary);border:1px dashed var(--sa11y-panel-bg-splitter);border-radius:5px;margin-top:15px;padding:10px}.panel-alert-preview ul{margin:0;margin-block:0;padding:0;position:relative}.panel-alert-preview li{margin:5px 10px 0 20px;padding-bottom:5px;display:list-item}.element-preview{overflow-wrap:break-word;background-color:var(--sa11y-element-preview);border-radius:3.2px;margin-bottom:10px;padding:5px}button[data-sa11y-dismiss]{color:var(--sa11y-panel-primary);cursor:pointer;background:var(--sa11y-panel-bg-secondary);border:2px solid var(--sa11y-button-outline);margin:10px 5px 5px 0;border-radius:5px;margin-inline-end:15px;padding:4px 8px;display:block}button[data-sa11y-dismiss]:hover,button[data-sa11y-dismiss]:focus{background:var(--sa11y-shortcut-hover)}h2{font-size:var(--sa11y-large-text);margin-bottom:3px;font-weight:700;display:block}h3{font-size:calc(var(--sa11y-large-text) - 1px);margin-bottom:3px;font-weight:600;display:block}strong{font-weight:600}a:not(#outline-list a,#images-list a){color:var(--sa11y-hyperlink);cursor:pointer;border-bottom:0;font-weight:500;text-decoration:underline}a:hover,a:focus{text-decoration:none!important}hr{background:var(--sa11y-panel-bg-splitter);opacity:1;border:none;height:1px;margin:10px 0;padding:0}#dismiss-button,#skip-button{text-align:center;cursor:pointer;background:var(--sa11y-panel-bg-secondary);border:1px solid var(--sa11y-button-outline);border-radius:50px;width:36px;height:36px;margin-inline:2px 8px;transition:all .1s ease-in-out;display:none;position:relative;overflow:visible}:is(#dismiss-button,#skip-button).active{display:block}:is(#dismiss-button,#skip-button):disabled{cursor:default;box-shadow:none;background:0 0;border:0}:is(#dismiss-button,#skip-button):before{content:"";position:absolute;inset:-5px}:is(#dismiss-button,#skip-button):hover:not(:disabled),:is(#dismiss-button,#skip-button):focus:not(:disabled){background-color:var(--sa11y-shortcut-hover)}:is(#panel.top-left,#panel.left) #dismiss-button,:is(#panel.top-left,#panel.left) #skip-button{margin-inline:8px 2px}.dismiss-icon{background:var(--sa11y-setting-switch-bg-off);width:24px;height:24px;-webkit-mask:var(--sa11y-dismiss-icon)center no-repeat;mask:var(--sa11y-dismiss-icon)center no-repeat;margin-bottom:-4px;display:inline-block}.dismiss-group{display:flex}@media screen and (forced-colors:active){.dismiss-icon{filter:invert()}}#panel-content{color:var(--sa11y-panel-primary);align-items:center;padding:6px;display:flex}#panel-content.errors .panel-icon,#panel-content.good .panel-icon,#panel-content.warnings .panel-icon{width:26px;height:26px;margin:0 auto}#panel-content.errors .panel-icon{background:var(--sa11y-panel-error);-webkit-mask:var(--sa11y-error-svg)center no-repeat;mask:var(--sa11y-error-svg)center no-repeat;margin-top:-2px}#panel-content.good .panel-icon{background:var(--sa11y-good);-webkit-mask:var(--sa11y-good-svg)center no-repeat;mask:var(--sa11y-good-svg)center no-repeat}#panel-content.warnings .panel-icon{background:var(--sa11y-yellow-text);transform:scaleX(var(--sa11y-icon-direction));-webkit-mask:var(--sa11y-warning-svg)center no-repeat;mask:var(--sa11y-warning-svg)center no-repeat}@media screen and (forced-colors:active){#panel-content.errors .panel-icon,#panel-content.good .panel-icon,#panel-content.warnings .panel-icon{filter:invert()}}#panel.top-left #panel-content,#panel.left #panel-content{flex-direction:row-reverse}#status{font-size:var(--sa11y-large-text);color:var(--sa11y-panel-primary)}.panel-count{color:var(--sa11y-panel-primary);background-color:var(--sa11y-panel-badge);border-radius:4px;margin-left:3px;margin-right:3px;padding:2px 4px;font-size:15px;font-weight:400}#page-issues,#images-panel,#settings-panel,#outline-panel{color:var(--sa11y-panel-primary);opacity:0;display:none}#page-issues.active,#images-panel.active,#settings-panel.active,#outline-panel.active{opacity:1;display:block}.panel-header{text-align:start;justify-content:space-between;padding:10px 15px 0;display:flex}#about-content{padding-top:5px}#about-content p{margin-block-end:1em;display:block}#images-content,#page-issues-content,#settings-content,#outline-content{border-bottom:1px solid var(--sa11y-panel-bg-splitter);padding:0 15px 10px}.top-right :is(#images-content,#page-issues-content,#settings-content,#outline-content),.top-left :is(#images-content,#page-issues-content,#settings-content,#outline-content){border:0}#images-content{padding-inline:5px}#page-issues-content{max-height:160px;overflow-y:auto}#settings-content{max-height:400px;overflow-y:auto}#images-content,#outline-content{max-height:250px;overflow-y:auto}#settings-panel .sa11y-red-text,#outline-panel .outline-list-item.sa11y-red-text{color:var(--sa11y-red-text)}#outline-list{margin:0;padding:0;display:block}#outline-list button{cursor:pointer;text-decoration:none;display:block}#outline-list button:hover,#outline-list button:focus{background:var(--sa11y-panel-outline-hover);box-shadow:0 0 0 2px var(--sa11y-panel-outline-hover);border-radius:5px;display:block}#outline-list li{margin-top:0;margin-bottom:4.5px;padding:0;list-style-type:none;display:block}#outline-list li:first-child{margin-top:5px}#outline-list .outline-2{margin-inline-start:15px}#outline-list .outline-3{margin-inline-start:30px}#outline-list .outline-4{margin-inline-start:45px}#outline-list .outline-5{margin-inline-start:60px}#outline-list .outline-6{margin-inline-start:75px}#images-list{margin:0;padding:0;display:block}#images-list button{cursor:pointer;min-height:44px;margin:10px 5px;text-decoration:none;display:block}#images-list button:hover,#images-list button:focus{background:var(--sa11y-panel-outline-hover);box-shadow:0 0 0 2px var(--sa11y-panel-outline-hover);border-radius:5px;display:block}#images-list li{border-bottom:1px solid var(--sa11y-panel-bg-splitter);flex-direction:column;width:100%;list-style-type:none;display:flex;overflow:hidden}#images-list li.no-images{padding-inline:10px}#images-list li:last-child{border:none;margin-bottom:0}#images-list li .alt{padding:2px 5px 10px}#images-list li .edit-block{justify-content:flex-end;margin-bottom:15px;display:flex}#images-list li .edit{color:var(--sa11y-panel-primary);cursor:pointer;background:var(--sa11y-panel-bg-secondary);border:2px solid var(--sa11y-button-outline);border-radius:5px;margin-inline-end:5px;padding:4px 7px;text-decoration:none;position:relative}#images-list li .edit:hover,#images-list li .edit:focus{background-color:var(--sa11y-shortcut-hover)}#images-list li .edit:before{content:"";position:absolute;inset:-10px}#images-list li img{float:inline-start;border-radius:5px;max-width:110px;margin:5px}#images-list li.warning .alt{color:var(--sa11y-yellow-text)}#images-list li.warning img{background-color:var(--sa11y-yellow-text);border:5px solid var(--sa11y-yellow-text)}#images-list li.error .alt{color:var(--sa11y-error)}#images-list li.error img{background-color:var(--sa11y-error);border:5px solid var(--sa11y-error)}#images-list li.good img{background-color:var(--sa11y-panel-badge);border:5px solid var(--sa11y-panel-badge)}@media screen and (forced-colors:active){#images-list li img{background-color:buttonborder!important}}.move-panel-icon{vertical-align:middle;background:var(--sa11y-setting-switch-bg-off);width:18px;height:18px;-webkit-mask:var(--sa11y-move-panel-icon);mask:var(--sa11y-move-panel-icon)}.info-icon{vertical-align:middle;background:var(--sa11y-setting-switch-bg-off);width:20px;height:20px;-webkit-mask:var(--sa11y-info-icon);mask:var(--sa11y-info-icon);margin-top:-2px}.sun-icon{vertical-align:middle;background:var(--sa11y-setting-switch-bg-off);width:18px;height:18px;-webkit-mask:var(--sa11y-sun-icon);mask:var(--sa11y-sun-icon)}.moon-icon{vertical-align:middle;background:var(--sa11y-setting-switch-bg-off);width:18px;height:18px;-webkit-mask:var(--sa11y-moon-icon);mask:var(--sa11y-moon-icon)}.error-icon{background:var(--sa11y-error-text);width:16px;height:16px;-webkit-mask:var(--sa11y-error-svg);mask:var(--sa11y-error-svg);margin-bottom:-4px}.hidden-icon{background:var(--sa11y-panel-primary);width:16px;height:16px;-webkit-mask:var(--sa11y-hidden-icon-svg);mask:var(--sa11y-hidden-icon-svg);margin-bottom:-3px}.link-icon{background:var(--sa11y-panel-primary);width:16px;height:16px;-webkit-mask:var(--sa11y-link-icon-svg);mask:var(--sa11y-link-icon-svg);margin-bottom:-3.5px}.move-panel-icon,.info-icon,.sun-icon,.moon-icon,.error-icon,.hidden-icon,.link-icon{display:inline-block;-webkit-mask-position:50%;mask-position:50%;-webkit-mask-repeat:no-repeat;mask-repeat:no-repeat}.error-badge .link-icon,.error-badge .hidden-icon{background:var(--sa11y-error-text)!important}.warning-badge .link-icon,.warning-badge .hidden-icon{background:var(--sa11y-panel-bg)}.error .hidden-icon,.error .link-icon{background:var(--sa11y-error-text)}.warning .hidden-icon,.warning .link-icon{background:var(--sa11y-panel-bg)}@media screen and (forced-colors:active){.move-panel-icon,.sun-icon,.moon-icon,.info-icon,.error-icon,.link-icon,.hidden-icon{filter:invert()}}#panel-controls{border-bottom:1px solid var(--sa11y-panel-bg-splitter);border-radius:0 0 4px 4px;display:flex;overflow:hidden}#panel-controls button{width:100%;height:30px;font-size:var(--sa11y-normal-text);color:var(--sa11y-panel-secondary);text-align:center;cursor:pointer;background:var(--sa11y-panel-bg-secondary);background-color:var(--sa11y-panel-bg-secondary);border-top:1px solid var(--sa11y-panel-bg-splitter);border-inline-end:1px solid var(--sa11y-panel-bg-splitter);opacity:1;outline:0;margin:0;padding:0;font-weight:400;line-height:0;transition:background .2s;display:block;position:relative}#panel-controls button:hover,#panel-controls button.active{background-color:var(--sa11y-shortcut-hover)}#panel-controls button.active{font-weight:600}#export-results-mode,label{width:100%;color:var(--sa11y-panel-primary);margin:0;font-weight:400;display:inline-block}label:not(#colour-filter-mode,#export-results-mode){cursor:pointer}#panel.right #panel-controls[data-image-panel]:after{content:"";width:80px}#panel.left #panel-controls[data-image-panel]:before{content:"";width:50px}#settings-panel .export-results-group,#settings-panel .appearance-group{margin:5px 0;display:flex}:is(#settings-panel .export-results-group,#settings-panel .appearance-group) button{text-align:center;white-space:nowrap;cursor:pointer;border:2px solid var(--sa11y-setting-switch-bg-off);margin:2px 0;border-radius:5px;justify-content:center;align-items:center;min-width:44px;min-height:34px;margin-inline:8px 4px;display:flex;position:relative}:is(#settings-panel .export-results-group,#settings-panel .appearance-group) button:hover,:is(#settings-panel .export-results-group,#settings-panel .appearance-group) button:focus,:is(#settings-panel .export-results-group,#settings-panel .appearance-group) button:focus-within{background:var(--sa11y-shortcut-hover)}:is(#settings-panel .export-results-group,#settings-panel .appearance-group) button:before{content:"";position:absolute;inset:-7px}:is(#settings-panel .export-results-group,#settings-panel .appearance-group) button .text{color:var(--sa11y-setting-switch-bg-off);padding:0 6px;font-weight:600}#settings-panel .switch{width:105px;height:44px;font-size:var(--sa11y-normal-text);color:var(--sa11y-setting-switch-bg-off);text-align:end;cursor:pointer;background:0 0;border:0;border-radius:5px;margin:0;padding:7px 10px;font-weight:600;position:relative}#settings-panel .switch[aria-pressed=true]:after,#settings-panel .switch[aria-pressed=false]:after{vertical-align:middle;content:"";width:27px;height:27px;margin:0 4px 4px;display:inline-block}#settings-panel .switch[aria-pressed=true]:after{background:var(--sa11y-setting-switch-bg-on);-webkit-mask:var(--sa11y-setting-switch-on-svg)center no-repeat;mask:var(--sa11y-setting-switch-on-svg)center no-repeat}#settings-panel .switch[aria-pressed=false]:after{background:var(--sa11y-setting-switch-bg-off);-webkit-mask:var(--sa11y-setting-switch-off-svg)center no-repeat;mask:var(--sa11y-setting-switch-off-svg)center no-repeat}@media screen and (forced-colors:active){#settings-panel .switch[aria-pressed=false]:after,#settings-panel .switch[aria-pressed=true]:after{filter:invert()}}#settings-panel #settings-options li{border-bottom:1px solid var(--sa11y-panel-bg-splitter);justify-content:space-between;align-items:center;padding:1px 0;list-style-type:none;display:flex}#settings-panel #settings-options li:last-child{border:none}#page-issues{color:var(--sa11y-panel-primary);align-items:center}#page-issues-list{margin-top:4px;display:block}#page-issues-list li{margin:0 0 10px;display:block}:is(.top-left,.top-right).has-page-issues #page-issues{border-top:1px solid var(--sa11y-panel-bg-splitter);margin-top:-1px}#panel-colour-filters{font-family:var(--sa11y-font-face);font-size:var(--sa11y-normal-text);color:var(--sa11y-panel-primary);align-items:center;font-weight:400;line-height:22px;display:none}#panel-colour-filters.active{display:flex}#panel-colour-filters p{width:100%;padding:6px 20px 6px 6px}#panel-colour-filters[data-colour=protanopia],#panel-colour-filters[data-colour=deuteranopia],#panel-colour-filters[data-colour=tritanopia],#panel-colour-filters[data-colour=monochromacy]{border-bottom:6px solid #0000;border-image-slice:1}#panel-colour-filters[data-colour=protanopia]{border-image:linear-gradient(94deg,#786719 11%,#e0c600 36% 47%,#0059e3 75%,#0042aa 91%)}#panel-colour-filters[data-colour=deuteranopia]{border-image:linear-gradient(270deg,#567fdb,#a4a28d 48%,#c3ad14 69%,#a79505)}#panel-colour-filters[data-colour=tritanopia]{border-image:linear-gradient(270deg,#b1506f,#0696c1,#f3a9ba 70%,#d91c5d 87%,#fe015c)}#panel-colour-filters[data-colour=monochromacy]{border-image:linear-gradient(270deg,#000,#a7a7a7,#000)}#panel-colour-filters[data-colour=protanopia] .panel-icon{background:var(--sa11y-panel-error)}#panel-colour-filters[data-colour=deuteranopia] .panel-icon{background:var(--sa11y-good-hover)}#panel-colour-filters[data-colour=tritanopia] .panel-icon{background:var(--sa11y-blue)}#panel-colour-filters[data-colour=monochromacy] .panel-icon{background:linear-gradient(90deg,#38a459 20%,red,#0077c8 80%)}#panel-colour-filters .panel-icon{width:30px;height:30px;-webkit-mask:var(--sa11y-low-vision-icon)center no-repeat;mask:var(--sa11y-low-vision-icon)center no-repeat;margin-inline:10px 5px}@media screen and (forced-colors:active){#panel-colour-filters .panel-icon{forced-color-adjust:none}}.select-dropdown{align-items:center;display:flex;position:relative}.select-dropdown:after{content:" ";border-top:5px solid var(--sa11y-setting-switch-bg-off);border-left:5px solid #0000;border-right:5px solid #0000;position:absolute;inset-inline-end:14px}#colour-filter-select{appearance:none;height:30px;font-size:var(--sa11y-normal-text);color:var(--sa11y-setting-switch-bg-off);text-align:end;vertical-align:middle;cursor:pointer;background:var(--sa11y-panel-bg);border:2px solid var(--sa11y-setting-switch-bg-off);border-radius:5px;margin-inline-end:4px;padding-inline:5px 25px;font-weight:400;position:relative}#colour-filter-select:hover,#colour-filter-select:focus{background:var(--sa11y-shortcut-hover)}#colour-filter-select.active{box-shadow:0 0 0 2px var(--sa11y-setting-switch-bg-on)}#colour-filter-item label,#colour-filter-item select{margin-top:10px;margin-bottom:9px}#readability-panel{opacity:0;display:none}#readability-panel.active{opacity:1;display:block}:is(.top-left,.top-right) #readability-content{border-top:1px solid var(--sa11y-panel-bg-splitter)}:is(.left,.right) #readability-content{border-bottom:1px solid var(--sa11y-panel-bg-splitter)}#readability-content{width:100%;color:var(--sa11y-panel-primary);padding:10px 15px}#readability-details{white-space:normal;margin:0;padding:0;list-style-type:none;display:block}#readability-details li{margin:0;padding-inline-end:10px;list-style-type:none;display:inline-block}.readability-score{color:var(--sa11y-panel-primary);background-color:var(--sa11y-panel-badge);border-radius:4px;margin-inline-start:5px;padding:2px 5px}#readability-info{margin-inline-start:10px}#skip-to-page-issues{display:none}#panel.has-page-issues #skip-to-page-issues{clip:rect(0,0,0,0);white-space:nowrap;background:var(--sa11y-panel-bg);border:0;border-radius:5px;width:1px;height:1px;margin:-1px;padding:0;font-weight:600;display:block;position:absolute;overflow:hidden}#panel.has-page-issues #skip-to-page-issues:focus{z-index:1;clip:auto;white-space:normal;width:auto;height:auto;margin:0;padding:7px 10px;overflow:visible}.hide-settings-border{border-bottom:0!important;padding:0 15px!important}.hide-settings-border li:not(#colour-filter-item){display:none!important}.hide-settings-border #about-content{display:none}.hide-settings-border.scrollable:before{all:unset}#contrast-tools{display:none}::-webkit-scrollbar{width:7px;height:6px}::-webkit-scrollbar-thumb{background-color:var(--sa11y-button-outline);border-radius:6px}*{scrollbar-color:var(--sa11y-button-outline);scrollbar-width:thin}.scrollable:before{z-index:-1;content:"";background:linear-gradient(180deg,#0000 70%,var(--sa11y-panel-scrollable)100%);background-position:bottom;width:100%;height:250px;transition:opacity 1s ease-in-out;animation:1s ease-in-out fade;position:absolute;inset:auto 0}#settings-content.scrollable:before{height:400px}.top-right .scrollable:before,.top-left .scrollable:before{border-radius:5px}#page-issues-content.scrollable:before{height:160px}#panel-alert.scrollable:before{height:200px}@keyframes sa11y-toggle-gradient{0%{background-position:50% 0}50%{background-position:50% 100%}to{background-position:50% 0}}@keyframes fade{0%{opacity:0}to{opacity:1}}@media(prefers-reduced-motion:reduce){*{transition:none!important;animation:none!important;transform:none!important}}#panel{width:440px}#container:lang(en) #panel{width:315px}:is(#container:lang(nb),#container:lang(da),#container:lang(pl),#container:lang(de),#container:lang(sv),#container:lang(zh)) #panel{width:365px}:is(#container:lang(bg),#container:lang(es)) .switch:not(#export-results-item *){width:230px!important}#container:not(:lang(en),:lang(de)) .switch{width:205px}';
class Sn extends HTMLElement {
  connectedCallback() {
    this.attachShadow({ mode: "open" });
    const e = document.createElement("style");
    e.textContent = fa + mt, this.shadowRoot.appendChild(e);
    const n = '<svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 48c114.953 0 208 93.029 208 208 0 114.953-93.029 208-208 208-114.953 0-208-93.029-208-208 0-114.953 93.029-208 208-208m0-40C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 56C149.961 64 64 149.961 64 256s85.961 192 192 192 192-85.961 192-192S362.039 64 256 64zm0 44c19.882 0 36 16.118 36 36s-16.118 36-36 36-36-16.118-36-36 16.118-36 36-36zm117.741 98.023c-28.712 6.779-55.511 12.748-82.14 15.807.851 101.023 12.306 123.052 25.037 155.621 3.617 9.26-.957 19.698-10.217 23.315-9.261 3.617-19.699-.957-23.316-10.217-8.705-22.308-17.086-40.636-22.261-78.549h-9.686c-5.167 37.851-13.534 56.208-22.262 78.549-3.615 9.255-14.05 13.836-23.315 10.217-9.26-3.617-13.834-14.056-10.217-23.315 12.713-32.541 24.185-54.541 25.037-155.621-26.629-3.058-53.428-9.027-82.141-15.807-8.6-2.031-13.926-10.648-11.895-19.249s10.647-13.926 19.249-11.895c96.686 22.829 124.283 22.783 220.775 0 8.599-2.03 17.218 3.294 19.249 11.895 2.029 8.601-3.297 17.219-11.897 19.249z"/></svg>', s = P.getItem("sa11y-developer") === "On", r = P.getItem("sa11y-readability") === "On", a = P.getItem("sa11y-theme"), i = P.getItem("sa11y-position"), l = u.Global.checkAllHideToggles, c = u.Global.developerPlugin ? `
      <li id="developer-item" ${l ? "hidden" : ""}>
        <label id="check-developer" for="developer-toggle">
          ${f._("DEVELOPER_CHECKS")} <span class="info-icon"></span>
        </label>
        <button type="button" id="developer-toggle" class="switch"
          aria-labelledby="check-developer" aria-describedby="check-developer-desc"
          aria-pressed="${s ? "true" : "false"}"
        >${s ? f._("ON") : f._("OFF")}</button>
        <div id="check-developer-desc" hidden>${f._("DEVELOPER_DESC")}</div>
      </li>` : "", p = u.Readability.Plugin ? `
      <li id="readability-item">
        <label id="check-readability" for="readability-toggle">${f._("READABILITY")} <span class="info-icon"></span></label>
        <button type="button" id="readability-toggle" aria-labelledby="check-readability" class="switch"
          aria-pressed="${r ? "true" : "false"}"
        >${r ? f._("ON") : f._("OFF")}</button>
        <div id="check-readability-desc" hidden>${f._("READABILITY_DESC")}</div>
      </li>` : "", o = u.Global.colourFilterPlugin ? `
      <li id="colour-filter-item">
        <label id="colour-filter-mode" for="colour-filter">${f._("COLOUR_FILTER")}</label>
        <div class="select-dropdown">
          <select id="colour-filter-select">
            <option value="0">${f._("OFF")}</option>
            <option value="1">${f._("PROTANOPIA")}</option>
            <option value="2">${f._("DEUTERANOPIA")}</option>
            <option value="3">${f._("TRITANOPIA")}</option>
            <option value="4">${f._("MONOCHROMACY")}</option>
          </select>
        </div>
      </li>` : "", d = u.Global.colourFilterPlugin ? `
      <div id="panel-colour-filters" role="region" aria-labelledby="colour-filter-mode">
        <div id="filter-icon" class="panel-icon" role="img"></div>
        <p>${f._("COLOUR_FILTER_MESSAGE")}</p>
      </div>` : "", m = u.Global.exportResultsPlugin ? `
      <li id="export-results-item">
        <span id="export-results-mode">${f._("EXPORT_RESULTS")}</span>
        <div class="export-results-group">
          <button type="button" id="export-csv" aria-describedby="export-results-mode">
            <span class="text">CSV</span>
          </button>
          <button type="button" id="export-html" aria-describedby="export-results-mode">
            <span class="text">HTML</span>
          </button>
        </div>
      </li>` : "", h = u.Global.aboutContent ? `
      <div id="about-content">${u.Global.aboutContent}</div>` : "", A = `
      <button type="button" aria-expanded="false" id="toggle" part="toggle" aria-describedby="notification-badge" aria-label="${f._("MAIN_TOGGLE_LABEL")}" class="${i}" disabled>
        ${n}
        <div id="notification-badge">
          <span id="notification-count"></span>
          <span id="notification-text" class="visually-hidden"></span>
        </div>
      </button>`, E = `
      <div id="page-issues">
        <div class="panel-header">
          <h2 id="page-issues-header" tabindex="-1">${f._("PAGE_ISSUES")}</h2>
        </div>
        <div id="page-issues-content">
          <ul id="page-issues-list" role="list" aria-labelledby="page-issues-header"></ul>
        </div>
      </div>`, y = `
      <div id="outline-panel" role="tabpanel" aria-labelledby="outline-header">
        <div class="panel-header">
          <h2 id="outline-header" tabindex="-1">${f._("OUTLINE")}</h2>
        </div>
        <div id="outline-content">
          <ul id="outline-list" tabindex="0" role="list" aria-labelledby="outline-header"></ul>
        </div>
        <div id="readability-panel">
          <div id="readability-content">
            <h2 class="header-text-inline">${f._("READABILITY")}</h2>
            <p id="readability-info"></p>
            <ul id="readability-details"></ul>
          </div>
        </div>
      </div>`, b = u.Global.showImageOutline ? `
      <div id="images-panel" role="tabpanel" aria-labelledby="images-header">
        <div class="panel-header">
          <h2 id="images-header" tabindex="-1">${f._("IMAGES")}</h2>
        </div>
        <div id="images-content">
          <ul id="images-list" tabindex="0" role="list" aria-labelledby="images-header"></ul>
        </div>
      </div>` : "", L = i === "left" || i === "top-left" ? "true" : "false", g = u.Global.showMovePanelToggle ? `<button type="button" id="move-panel"
          aria-label="${f._("MOVE_PANEL")}"
          aria-pressed="${L}"
          ><span class="move-panel-icon"></span>
        </button>` : "", _ = `
      <div id="settings-panel" role="tabpanel" aria-labelledby="settings-header">
        <div class="panel-header">
          <h2 id="settings-header" tabindex="-1">${f._("SETTINGS")}</h2>
        </div>
        <div id="settings-content">
          <ul id="settings-options">
            ${c}
            ${p}
            <li id="appearance-item">
              <span id="appearance-mode">${f._("APPEARANCE")}</span>
              <div class="appearance-group">
                <button type="button" id="theme-toggle"
                  aria-label="${f._("DARK_MODE")}"
                  aria-pressed=${a === "dark" ? "true" : "false"}
                ><span class="moon-icon"></span></button>
                ${g}
              </div>
            </li>
            ${m}
            ${o}
          </ul>
          ${h}
        </div>
      </div>`, I = `
      <div id="panel-alert" role="alertdialog" aria-labelledby="alert-heading" aria-describedby="panel-alert-text">
        <div id="panel-alert-content">
          <div class="header-text">
            <button type="button" id="close-alert" class="close-btn" aria-label="${f._("ALERT_CLOSE")}"></button>
            <h2 id="alert-heading">${f._("ALERT_TEXT")}</h2>
          </div>
          <p id="panel-alert-text"></p>
          <div id="panel-alert-preview"></div>
        </div>
      </div>`, S = `
      <div id="panel-content">
        <button type="button" id="skip-to-page-issues">
          ${f._("SKIP_TO_PAGE_ISSUES")}
        </button>
        <button type="button" id="skip-button">
          <div class="panel-icon"></div>
          <span class="visually-hidden">${f._("SHORTCUT_SR")}</span>
        </button>
        <button type="button" id="dismiss-button">
          <div class="dismiss-icon"></div>
          <span id="dismiss-tooltip" class="visually-hidden"></span>
        </button>
        <div id="panel-text">
          <h1 class="visually-hidden">${f._("PANEL_HEADING")}</h1>
          <p id="status" aria-live="polite"></p>
        </div>
      </div>`, x = `<button type="button" role="tab" aria-expanded="false" id="images-toggle" aria-controls="images-panel">${f._("IMAGES")}</button>`, k = `
      <div id="panel-controls" role="tablist" aria-orientation="horizontal" ${u.Global.showImageOutline ? "data-image-panel" : ""}>
        <button type="button" role="tab" aria-expanded="false" id="outline-toggle" aria-controls="outline-panel">${f._("OUTLINE")}</button>
        ${u.Global.showImageOutline ? x : ""}
        <button type="button" role="tab" aria-expanded="false" id="settings-toggle" aria-controls="settings-panel">${f._("SETTINGS")}</button>
      </div>`, D = document.createElement("div");
    D.setAttribute("id", "container"), D.setAttribute("role", "region"), D.setAttribute("data-sa11y-version", "4.4.1"), D.setAttribute("lang", f._("LANG_CODE")), D.setAttribute("aria-label", f._("CONTAINER_LABEL")), D.setAttribute("dir", u.Global.langDirection), i === "top-left" || i === "top-right" ? D.innerHTML = `
        ${A}
        <div id="panel" class="${i}" part="panel">
          ${S}
          ${d}
          ${k}
          ${y}
          ${b}
          ${_}
          ${I}
          ${E}
        </div>` : D.innerHTML = `
        ${A}
        <div id="panel" class="${i}" part="panel">
          ${E}
          ${y}
          ${b}
          ${_}
          ${I}
          ${d}
          ${S}
          ${k}
        </div>`, this.shadowRoot.appendChild(D), u.initializePanelSelectors();
  }
}
function ha(t, e) {
  u.Global.showMovePanelToggle && (u.Panel.movePanelToggle.onclick = async () => {
    const l = P.getItem("sa11y-position"), [c, p] = l.includes("top") ? ["top-right", "top-left"] : ["right", "left"], o = l === c ? p : c;
    P.setItem("sa11y-position", o), [c, p].forEach((d) => {
      u.Panel.toggle.classList.replace(d, o), u.Panel.panel.classList.replace(d, o);
    }), u.Panel.movePanelToggle.setAttribute(
      "aria-pressed",
      l === c ? "true" : "false"
    );
  }), u.Global.developerPlugin ? u.Panel.developerToggle.onclick = async () => {
    P.getItem("sa11y-developer") === "On" ? (P.setItem("sa11y-developer", "Off"), u.Panel.developerToggle.textContent = `${f._("OFF")}`, u.Panel.developerToggle.setAttribute("aria-pressed", "false"), e(!1), await t()) : (P.setItem("sa11y-developer", "On"), u.Panel.developerToggle.textContent = `${f._("ON")}`, u.Panel.developerToggle.setAttribute("aria-pressed", "true"), e(!1), await t());
  } : P.setItem("sa11y-developer", "Off"), u.Readability.Plugin && (u.Panel.readabilityToggle.onclick = async () => {
    P.getItem("sa11y-readability") === "On" ? (P.setItem("sa11y-readability", "Off"), u.Panel.readabilityToggle.textContent = `${f._("OFF")}`, u.Panel.readabilityToggle.setAttribute("aria-pressed", "false"), u.Panel.readability.classList.remove("active"), e(!1), await t()) : (P.setItem("sa11y-readability", "On"), u.Panel.readabilityToggle.textContent = `${f._("ON")}`, u.Panel.readabilityToggle.setAttribute("aria-pressed", "true"), u.Panel.readability.classList.add("active"), e(!1), await t());
  }, P.getItem("sa11y-readability") === "On" && u.Panel.readability.classList.add("active"));
  const n = window.matchMedia("(prefers-color-scheme: dark)"), { themeToggle: s } = u.Panel, { html: r } = u.Global, a = (l) => {
    r.setAttribute("data-sa11y-theme", l), P.setItem("sa11y-theme", l);
    const c = s.querySelector("span").classList;
    c.toggle("moon-icon", l === "light"), c.toggle("sun-icon", l === "dark"), s.setAttribute("aria-pressed", l === "dark" ? "true" : "false");
  }, i = P.getItem("sa11y-theme") || (n.matches ? "dark" : "light");
  a(i), n.addEventListener("change", () => {
    a(n.matches ? "dark" : "light");
  }), s.onclick = () => {
    const c = (P.getItem("sa11y-theme") || (n.matches ? "dark" : "light")) === "dark" ? "light" : "dark";
    a(c);
  }, u.Global.colourFilterPlugin && u.Panel.colourFilterSelect.addEventListener("change", async () => {
    const l = parseInt(u.Panel.colourFilterSelect.value, 10), c = ["protanopia", "deuteranopia", "tritanopia", "monochromacy"], p = [
      f._("RED_EYE"),
      f._("GREEN_EYE"),
      f._("BLUE_EYE"),
      f._("MONO_EYE")
    ];
    l >= 1 && l <= 4 ? window.matchMedia("(forced-colors: active)").matches ? je(f._("COLOUR_FILTER_HIGH_CONTRAST")) : (document.body.setAttribute("data-sa11y-filter", c[l - 1]), u.Panel.colourFilterIcon.setAttribute("aria-label", p[l - 1]), ts(
      ["data-sa11y-error", "data-sa11y-warning", "data-sa11y-good", "data-sa11y-overflow"],
      "document"
    ), ns(["sa11y-annotation", "sa11y-tooltips", "sa11y-heading-label"], "document"), u.Panel.skipButton.disabled = !0, u.Panel.pageIssues.classList.remove("active"), u.Panel.settingsContent.classList.add("hide-settings-border"), u.Panel.controls.hidden = !0, u.Panel.colourFilterSelect.classList.add("active"), u.Panel.colourPanel.classList.add("active"), u.Panel.colourPanel.setAttribute("data-colour", c[l - 1]), u.Panel.content.hidden = !0) : (ls(), e(!1), await t());
  });
}
const kn = () => {
  u.Panel.outlineToggle.classList.add("active"), u.Panel.outline.classList.add("active"), u.Panel.outlineToggle.setAttribute("aria-expanded", "true"), P.setItem("sa11y-outline", "Opened"), gt(u.Panel.outlineList, u.Panel.outlineContent), te("sa11y-heading-label", "document").forEach((n) => {
    n.hidden = !1;
  });
  const e = new CustomEvent("sa11y-build-heading-outline");
  document.dispatchEvent(e);
}, Qt = () => {
  u.Panel.outline.classList.remove("active"), u.Panel.outlineToggle.classList.remove("active"), u.Panel.outlineToggle.setAttribute("aria-expanded", "false"), P.setItem("sa11y-outline", "Closed"), te("sa11y-heading-label", "document").forEach((e) => {
    e.hidden = !0;
  });
}, wn = () => {
  u.Panel.imagesToggle.classList.add("active"), u.Panel.images.classList.add("active"), u.Panel.imagesToggle.setAttribute("aria-expanded", "true"), P.setItem("sa11y-images", "Opened"), gt(u.Panel.imagesList, u.Panel.imagesContent);
  const t = new CustomEvent("sa11y-build-image-outline");
  document.dispatchEvent(t);
}, Yt = () => {
  u.Global.showImageOutline && (u.Panel.imagesToggle.classList.remove("active"), u.Panel.images.classList.remove("active"), u.Panel.imagesToggle.setAttribute("aria-expanded", "false"), P.setItem("sa11y-images", "Closed"));
}, Cn = () => {
  u.Panel.settingsToggle.classList.add("active"), u.Panel.settings.classList.add("active"), u.Panel.settingsToggle.setAttribute("aria-expanded", "true"), P.setItem("sa11y-settings", "Opened"), gt(
    u.Panel.settingsContent,
    u.Panel.settingsContent,
    f._("SETTINGS")
  );
}, jt = () => {
  u.Panel.settings.classList.remove("active"), u.Panel.settingsToggle.classList.remove("active"), u.Panel.settingsToggle.setAttribute("aria-expanded", "false"), P.setItem("sa11y-settings", "Closed");
};
function ga() {
  u.Panel.outlineToggle.addEventListener("click", () => {
    u.Panel.outlineToggle.getAttribute("aria-expanded") === "true" ? Qt() : (kn(), jt(), Yt()), u.Panel.outlineHeader.focus();
  }), P.getItem("sa11y-outline") === "Opened" && kn(), u.Global.showImageOutline && (u.Panel.imagesToggle.addEventListener("click", () => {
    u.Panel.imagesToggle.getAttribute("aria-expanded") === "true" ? Yt() : (wn(), Qt(), jt()), u.Panel.imagesHeader.focus();
  }), P.getItem("sa11y-images") === "Opened" && wn()), u.Panel.settingsToggle.addEventListener("click", () => {
    u.Panel.settingsToggle.getAttribute("aria-expanded") === "true" ? jt() : (Cn(), Qt(), Yt()), u.Panel.settingsHeader.focus();
  }), P.getItem("sa11y-settings") === "Opened" && Cn(), u.Panel.skipToPageIssues.addEventListener("click", () => {
    u.Panel.pageIssuesHeader.focus();
  });
  const t = u.Panel.panel.querySelectorAll("[role=tab]");
  t.length !== 0 && t.forEach((e) => {
    e.addEventListener("keydown", (n) => {
      if (n.key !== "ArrowRight" && n.key !== "ArrowLeft")
        return;
      n.preventDefault();
      const s = Array.from(t).indexOf(n.currentTarget);
      let r;
      n.key === "ArrowRight" ? r = (s + 1) % t.length : r = (s - 1 + t.length) % t.length, t[r].focus();
    });
  });
}
function ma(t, e, n) {
  const s = () => {
    const r = [];
    t.map((l) => e.find((c) => l.dismiss === c.dismiss)).filter(Boolean).forEach((l) => {
      l.dismissedHeading = !0;
    });
    let i;
    if (n.showTitleInPageOutline) {
      const l = document.querySelector("head title");
      if (!l || l.textContent.trim().length === 0)
        i = `<li><div class="badge error-badge"><span aria-hidden="true"><span class="error-icon"></span></span> ${f._("TITLE")}</div> <div class="badge error-badge">${f._("MISSING")}</div></li>`;
      else {
        const c = j(l);
        i = `<li><span class="badge">${f._("TITLE")}</span> ${q(c)}</li>`;
      }
      r.push(i);
    }
    e.forEach((l, c) => {
      const { element: p, headingLevel: o, text: d, type: m, dismissedHeading: h, isWithinRoot: A } = l, E = pn(p), y = E === !0 ? `<span class="hidden-icon"></span><span class="visually-hidden">${f._("HIDDEN")}</span>` : "", b = n.showHinPageOutline === !0 || n.showHinPageOutline === 1 ? "H" : "";
      let v;
      m === "error" && A === !0 ? (v = `
            <li class="outline-${o}">
              <button type="button" tabindex="-1">
                <span class="badge error-badge">
                <span aria-hidden="true">${y}
                  <span class="error-icon"></span>
                </span>
                <span class="visually-hidden">${f._("ERROR")}</span> ${b + o}</span>
                <strong class="outline-list-item red-text">${d}</strong>
              </button>
            </li>`, r.push(v)) : m === "warning" && !h && A === !0 ? (v = `
            <li class="outline-${o}">
              <button type="button" tabindex="-1">
                <span class="badge warning-badge">
                <span aria-hidden="true">${y} &#x3f;</span>
                <span class="visually-hidden">${f._("WARNING")}</span> ${b + o}</span>
                <strong class="outline-list-item yellow-text">${d}</strong>
              </button>
            </li>`, r.push(v)) : (v = `
            <li class="outline-${o}">
              <button type="button" tabindex="-1">
                <span class="badge">${y} ${b + o}</span>
                <span class="outline-list-item">${d}</span>
              </button>
            </li>`, r.push(v));
      const L = document.createElement("sa11y-heading-label");
      L.hidden = !0, p?.insertAdjacentElement("beforeend", L);
      const g = document.createElement("sa11y-heading-anchor");
      if (g.id = `sa11y-h${c}`, E) {
        const I = ht(p, "display", "none"), S = I?.previousElementSibling || I?.parentNode;
        S?.insertAdjacentElement("beforebegin", g), S?.setAttribute("data-sa11y-parent", `h${c}`);
      } else
        L?.insertAdjacentElement("beforebegin", g);
      const _ = document.createElement("span");
      _.classList.add("heading-label"), _.innerHTML = `H${o}`, L.shadowRoot.appendChild(_), P.getItem("sa11y-outline") === "Opened" && (L.hidden = !1);
    }), u.Panel.outlineList.innerHTML = e.length === 0 ? `${i || ""} <li>${f._("PANEL_NO_HEADINGS")}</li>` : r.join(" "), setTimeout(() => {
      const l = u.Panel.outlineList.querySelectorAll("button");
      l.forEach((c, p) => {
        c.addEventListener("click", () => {
          const o = te(
            `#sa11y-h${p}, [data-sa11y-parent="h${p}"]`,
            "document",
            u.Exclusions.Container
          )[0];
          o && (o.scrollIntoView({
            behavior: `${u.Global.scrollBehaviour}`,
            block: "center"
          }), Dt(o.parentNode || o)), We(), (!o || o.hasAttribute("data-sa11y-parent")) && je(f._("NOT_VISIBLE"));
        });
      }), rs(u.Panel.outlineList, l);
    }, 0), document.removeEventListener("sa11y-build-heading-outline", s);
  };
  P.getItem("sa11y-outline") === "Opened" && s(), document.addEventListener("sa11y-build-heading-outline", s);
}
const nt = (t, e) => {
  const n = (a) => {
    if (a === "none")
      return "";
    const i = a.includes("url(") || a.includes("image-set(") ? a.match(/\/\s*"([^"]+)"/) : a.match(/"([^"]+)"/);
    return i ? i[1] : "";
  }, s = n(
    window.getComputedStyle(t, ":before").getPropertyValue("content")
  ), r = n(window.getComputedStyle(t, ":after").getPropertyValue("content"));
  return `${s}${e}${r}`;
}, On = (t) => {
  for (let e = 0; e < 1e3; e++) {
    if (t.nextSibling())
      return t.previousNode();
    if (!t.parentNode())
      return !1;
  }
  return !1;
}, ke = (t, e = !1) => {
  if (u.Global.ignoreAriaOnElements && t.matches(u.Global.ignoreAriaOnElements))
    return "noAria";
  if (u.Global.ignoreTextInElements && t.matches(u.Global.ignoreTextInElements))
    return "";
  const n = t.getAttribute("aria-labelledby");
  if (!e && n)
    return n.split(/\s+/).filter((r) => r.trim()).map((r) => {
      const a = document.querySelector(`#${CSS.escape(r)}`);
      return a ? Te(a, "", 1) : "";
    }).join(" ");
  const { ariaLabel: s } = t;
  return s && s.trim().length > 0 ? s : "noAria";
}, Te = (t, e = [], n = 0) => {
  const s = ke(t, n);
  if (s !== "noAria")
    return s;
  let r = "";
  if (!t.children.length)
    return r = nt(t, t.textContent), !r.trim() && t.hasAttribute("title") ? t.getAttribute("title") : r;
  function a(A, E, y) {
    const b = (v) => v.nodeType === Node.ELEMENT_NODE || v.nodeType === Node.TEXT_NODE ? NodeFilter.FILTER_ACCEPT : NodeFilter.FILTER_REJECT;
    return document.createTreeWalker(A, NodeFilter.SHOW_ALL, { acceptNode: b });
  }
  const i = a(t), l = ["noscript", "style", "script", "video", "audio"], c = [...e, ...l].join(", "), p = c ? t.querySelectorAll(c) : [];
  let o = !1, d = !1, m = 0, h = !0;
  for (; i.nextNode() && h; ) {
    m += 1;
    const A = i.currentNode;
    if (Array.from(p).some((b) => b.contains(A)))
      continue;
    if (A.shadowRoot) {
      const b = A.shadowRoot.querySelectorAll("*");
      for (let v = 0; v < b.length; v++) {
        const L = b[v];
        (!c || !L.closest(c)) && (r += Te(L, e, n + 1));
      }
    }
    if (A.nodeType === Node.TEXT_NODE) {
      A.parentNode.tagName !== "SLOT" && (r += ` ${A.nodeValue}`);
      continue;
    }
    if (o && !A.closest("a") && (d === r && (r += o), o = !1, d = !1), A.ariaHidden === "true" && !(n && m < 3)) {
      On(i) || (h = !1);
      continue;
    }
    const y = ke(A, n);
    if (y !== "noAria") {
      r += ` ${y}`, On(i) || (h = !1);
      continue;
    }
    switch (A.tagName) {
      case "IMG":
        A.hasAttribute("alt") && A.role !== "presentation" && (r += A.getAttribute("alt"));
        break;
      case "SVG":
        if (A.role === "img" || A.role === "graphics-document")
          r += ke(A);
        else {
          const b = A.querySelector("title");
          b && (r += b.textContent);
        }
        break;
      case "A":
        A.hasAttribute("title") ? (o = A.getAttribute("title"), d = r) : (o = !1, d = !1), r += nt(A, "");
        break;
      case "INPUT":
        r += nt(i.currentNode, ""), i.currentNode.hasAttribute("title") && (o = i.currentNode.getAttribute("title"));
        break;
      case "SLOT": {
        const b = A.assignedNodes?.() || [];
        let v = "";
        b.forEach((L) => {
          L.nodeType === Node.ELEMENT_NODE ? v += Te(L) : L.nodeType === Node.TEXT_NODE && (v += L.nodeValue);
        }), r += v, r += nt(A, "");
        break;
      }
      default:
        r += nt(A, "");
        break;
    }
  }
  return o && !d && (r += ` ${o}`), r = r.replace(/[\uE000-\uF8FF]/gu, ""), !r.trim() && t.hasAttribute("title") ? t.getAttribute("title") : r;
}, Aa = (t) => {
  const { src: e } = t.element, n = u.Global.ignoreEditImageURL.some((o) => e.includes(o)), s = u.Global.ignoreEditImageClass.some(
    (o) => t.element.classList.contains(o)
  );
  if (n || s)
    return "";
  const r = u.Global.relativePathImageSRC || window.location.host, a = e.split(r)[1] || "", i = u.Global.relativePathImageID;
  let l;
  i.length && t.element.classList.length && t.element.classList.forEach((o) => {
    if (o.startsWith(i)) {
      const [d] = o.match(/\d+/) || [];
      l = d;
    }
  });
  const c = r && i.length ? u.Global.editImageURLofCMS + l : u.Global.editImageURLofCMS + a, p = (o) => o.includes(window.location.host) || o.startsWith(r);
  return (i.length && l !== void 0 || !i) && p(e) ? `<div class="edit-block"><a href="${encodeURI(c)}" tabindex="-1" target="_blank" rel="noopener noreferrer" class="edit">${f._("EDIT")}</a></div>` : "";
};
function ba(t, e, n) {
  const s = () => {
    const r = [];
    e.forEach((a, i) => {
      t.some((C) => C.dismiss === a.dismiss) && Object.assign(a, { dismissedImage: !0 });
      const { element: c, type: p, developer: o, dismissedImage: d } = a, m = ke(c) === "noAria" ? ct(c.getAttribute("alt")) : ke(c), h = pn(c);
      if (h) {
        const C = ht(c, "display", "none"), k = document.createElement("sa11y-image-anchor");
        k.setAttribute("data-sa11y-parent", `image${i}`), (C?.previousElementSibling || C?.parentNode)?.insertAdjacentElement("beforebegin", k);
      } else
        c.setAttribute("data-sa11y-image", i);
      const A = P.getItem("sa11y-developer"), y = (A === "Off" || A === null) && (p === "error" || p === "warning") && o === !0, b = ss(a.element), v = u.Global.editImageURLofCMS ? Aa(a) : "", L = c.hasAttribute("alt") && m === "" ? `<div class="badge">${f._("DECORATIVE")}</div>` : "", g = n.altPlaceholder?.some(
        (C) => m.toLowerCase().startsWith(C.toLowerCase())
      ), _ = n.imageWithinLightbox ? `a[href]:not(${n.imageWithinLightbox})` : "a[href]", I = c.closest(_) ? `<div class="badge"><span class="link-icon"></span><span class="visually-hidden">${f._("LINKED")}</span></div>` : "", S = h === !0 ? `<div class="badge"><span class="hidden-icon"></span><span class="visually-hidden">${f._("HIDDEN")}</span></div>` : "";
      let x;
      if (p === "error" && !y) {
        const C = m.length === 0 ? `<div class="badge">${f._("MISSING")}</div>` : "";
        x = `
        <li class="error">
          <button type="button" tabindex="-1">
            <img src="${b}" alt/>
            <div class="alt"> ${S} ${I} ${C}
              <div class="badge"><span class="error-icon"></span><span class="visually-hidden">${f._("ERROR")}</span> ${f._("ALT")}</div> <strong class="red-text">${g ? "" : m}</strong>
            </div>
          </button>
          ${v}
        </li>`, r.push(x);
      } else p === "warning" && !d && !y ? (x = `
        <li class="warning">
          <button type="button" tabindex="-1">
            <img src="${b}" alt/>
            <div class="alt"> ${S} ${I} ${L}
              <div class="badge"><span aria-hidden="true">&#63;</span> <span class="visually-hidden">${f._("WARNING")}</span> ${f._("ALT")}</div> <strong class="yellow-text">${g ? "" : m}</strong>
            </div>
          </button>
          ${v}
        </li>`, r.push(x)) : (x = `
        <li class="good">
          <button type="button" tabindex="-1">
            <img src="${b}" alt/>
            <div class="alt"> ${S} ${I} ${L}
              <div class="badge">${f._("ALT")}</div> ${m}
            </div>
          </button>
          ${v}
        </li>`, r.push(x));
    }), u.Panel.imagesList.innerHTML = r.length === 0 ? `<li class="no-images">${f._("NO_IMAGES")}</li>` : r.join(" "), setTimeout(() => {
      u.Panel.imagesList.querySelectorAll("button").forEach((l, c) => {
        l.addEventListener("click", () => {
          const p = te(
            `[data-sa11y-image='${c}'], [data-sa11y-parent='image${c}']`,
            "document",
            u.Exclusions.Container
          )[0];
          p && (p.scrollIntoView({
            behavior: `${u.Global.scrollBehaviour}`,
            block: "center"
          }), Dt(p)), We(), (!p || p.hasAttribute("data-sa11y-parent")) && je(f._("NOT_VISIBLE"));
        });
      });
      const i = u.Panel.imagesList.querySelectorAll("a, button");
      rs(u.Panel.imagesList, i);
    }, 0), document.removeEventListener("sa11y-build-image-outline", s);
  };
  P.getItem("sa11y-images") === "Opened" && s(), document.addEventListener("sa11y-build-image-outline", s);
}
function ya(t, e, n) {
  u.Panel.skipButton.disabled = !1, u.Panel.panel.classList.add("active"), u.Global.html.setAttribute("data-sa11y-active", "true"), u.Panel.skipButton.classList.add("active"), e > 0 && n > 0 ? (u.Panel.content.setAttribute("class", "errors"), u.Panel.status.innerHTML = `${f._("ERRORS")} <span class="panel-count">${e}</span> ${f._("WARNINGS")} <span class="panel-count" id="warning-count">${n}</span>`) : e > 0 ? (u.Panel.content.setAttribute("class", "errors"), u.Panel.status.innerHTML = `${f._("ERRORS")} <span class="panel-count">${e}</span>`) : n > 0 ? (u.Panel.content.setAttribute("class", "warnings"), u.Panel.status.innerHTML = `${f._("WARNINGS")} <span class="panel-count" id="warning-count">${n}</span>`) : t > 0 ? (u.Panel.status.innerHTML = `${f._("DISMISSED")} <span class="panel-count">${t}</span>`, u.Panel.skipButton.classList.remove("active")) : (u.Panel.content.setAttribute("class", "good"), u.Panel.status.innerHTML = `${f._("NO_ERRORS_FOUND")}`), document.querySelectorAll("sa11y-annotation").length === 0 && (u.Panel.skipButton.disabled = !0);
}
function Ea(t, e) {
  const n = t + e;
  n === 0 ? (u.Panel.notifCount.innerText = "", u.Panel.notifText.innerText = "", u.Panel.notifBadge.style.display = "none") : e > 0 && t === 0 ? (u.Panel.notifBadge.classList.add("notification-badge-warning"), u.Panel.notifCount.innerText = `${e}`, u.Panel.notifText.innerText = `${f._("WARNINGS_FOUND")}`) : (u.Panel.notifBadge.classList.remove("notification-badge-warning"), u.Panel.notifCount.innerText = `${n}`, u.Panel.notifText.innerText = f._("TOTAL_FOUND")), P.getItem("sa11y-panel") === "Opened" || n === 0 ? u.Panel.notifBadge.style.display = "none" : u.Panel.notifBadge.style.display = "flex";
}
function va(t, e, n) {
  let s = e, r = n;
  return t.forEach((a, i) => {
    const l = t[i].type;
    l === "error" ? s += 1 : l === "warning" && (r += 1);
  }), { error: s, warning: r };
}
var ne = "top", ce = "bottom", de = "right", se = "left", fn = "auto", At = [ne, ce, de, se], ze = "start", dt = "end", La = "clippingParents", cs = "viewport", st = "popper", Ta = "reference", Pn = /* @__PURE__ */ At.reduce(function(t, e) {
  return t.concat([e + "-" + ze, e + "-" + dt]);
}, []), ds = /* @__PURE__ */ [].concat(At, [fn]).reduce(function(t, e) {
  return t.concat([e, e + "-" + ze, e + "-" + dt]);
}, []), Ia = "beforeRead", _a = "read", xa = "afterRead", Na = "beforeMain", Sa = "main", ka = "afterMain", wa = "beforeWrite", Ca = "write", Oa = "afterWrite", Pa = [Ia, _a, xa, Na, Sa, ka, wa, Ca, Oa];
function Ee(t) {
  return t ? (t.nodeName || "").toLowerCase() : null;
}
function ie(t) {
  if (t == null)
    return window;
  if (t.toString() !== "[object Window]") {
    var e = t.ownerDocument;
    return e && e.defaultView || window;
  }
  return t;
}
function Be(t) {
  var e = ie(t).Element;
  return t instanceof e || t instanceof Element;
}
function le(t) {
  var e = ie(t).HTMLElement;
  return t instanceof e || t instanceof HTMLElement;
}
function hn(t) {
  if (typeof ShadowRoot > "u")
    return !1;
  var e = ie(t).ShadowRoot;
  return t instanceof e || t instanceof ShadowRoot;
}
function Ra(t) {
  var e = t.state;
  Object.keys(e.elements).forEach(function(n) {
    var s = e.styles[n] || {}, r = e.attributes[n] || {}, a = e.elements[n];
    !le(a) || !Ee(a) || (Object.assign(a.style, s), Object.keys(r).forEach(function(i) {
      var l = r[i];
      l === !1 ? a.removeAttribute(i) : a.setAttribute(i, l === !0 ? "" : l);
    }));
  });
}
function Da(t) {
  var e = t.state, n = {
    popper: {
      position: e.options.strategy,
      left: "0",
      top: "0",
      margin: "0"
    },
    arrow: {
      position: "absolute"
    },
    reference: {}
  };
  return Object.assign(e.elements.popper.style, n.popper), e.styles = n, e.elements.arrow && Object.assign(e.elements.arrow.style, n.arrow), function() {
    Object.keys(e.elements).forEach(function(s) {
      var r = e.elements[s], a = e.attributes[s] || {}, i = Object.keys(e.styles.hasOwnProperty(s) ? e.styles[s] : n[s]), l = i.reduce(function(c, p) {
        return c[p] = "", c;
      }, {});
      !le(r) || !Ee(r) || (Object.assign(r.style, l), Object.keys(a).forEach(function(c) {
        r.removeAttribute(c);
      }));
    });
  };
}
const ps = {
  name: "applyStyles",
  enabled: !0,
  phase: "write",
  fn: Ra,
  effect: Da,
  requires: ["computeStyles"]
};
function ye(t) {
  return t.split("-")[0];
}
var De = Math.max, Mt = Math.min, Ve = Math.round;
function an() {
  var t = navigator.userAgentData;
  return t != null && t.brands && Array.isArray(t.brands) ? t.brands.map(function(e) {
    return e.brand + "/" + e.version;
  }).join(" ") : navigator.userAgent;
}
function us() {
  return !/^((?!chrome|android).)*safari/i.test(an());
}
function Qe(t, e, n) {
  e === void 0 && (e = !1), n === void 0 && (n = !1);
  var s = t.getBoundingClientRect(), r = 1, a = 1;
  e && le(t) && (r = t.offsetWidth > 0 && Ve(s.width) / t.offsetWidth || 1, a = t.offsetHeight > 0 && Ve(s.height) / t.offsetHeight || 1);
  var i = Be(t) ? ie(t) : window, l = i.visualViewport, c = !us() && n, p = (s.left + (c && l ? l.offsetLeft : 0)) / r, o = (s.top + (c && l ? l.offsetTop : 0)) / a, d = s.width / r, m = s.height / a;
  return {
    width: d,
    height: m,
    top: o,
    right: p + d,
    bottom: o + m,
    left: p,
    x: p,
    y: o
  };
}
function gn(t) {
  var e = Qe(t), n = t.offsetWidth, s = t.offsetHeight;
  return Math.abs(e.width - n) <= 1 && (n = e.width), Math.abs(e.height - s) <= 1 && (s = e.height), {
    x: t.offsetLeft,
    y: t.offsetTop,
    width: n,
    height: s
  };
}
function fs(t, e) {
  var n = e.getRootNode && e.getRootNode();
  if (t.contains(e))
    return !0;
  if (n && hn(n)) {
    var s = e;
    do {
      if (s && t.isSameNode(s))
        return !0;
      s = s.parentNode || s.host;
    } while (s);
  }
  return !1;
}
function Ie(t) {
  return ie(t).getComputedStyle(t);
}
function Ma(t) {
  return ["table", "td", "th"].indexOf(Ee(t)) >= 0;
}
function we(t) {
  return ((Be(t) ? t.ownerDocument : (
    // $FlowFixMe[prop-missing]
    t.document
  )) || window.document).documentElement;
}
function Ht(t) {
  return Ee(t) === "html" ? t : (
    // this is a quicker (but less type safe) way to save quite some bytes from the bundle
    // $FlowFixMe[incompatible-return]
    // $FlowFixMe[prop-missing]
    t.assignedSlot || // step into the shadow DOM of the parent of a slotted node
    t.parentNode || // DOM Element detected
    (hn(t) ? t.host : null) || // ShadowRoot detected
    // $FlowFixMe[incompatible-call]: HTMLElement is a Node
    we(t)
  );
}
function Rn(t) {
  return !le(t) || // https://github.com/popperjs/popper-core/issues/837
  Ie(t).position === "fixed" ? null : t.offsetParent;
}
function Ba(t) {
  var e = /firefox/i.test(an()), n = /Trident/i.test(an());
  if (n && le(t)) {
    var s = Ie(t);
    if (s.position === "fixed")
      return null;
  }
  var r = Ht(t);
  for (hn(r) && (r = r.host); le(r) && ["html", "body"].indexOf(Ee(r)) < 0; ) {
    var a = Ie(r);
    if (a.transform !== "none" || a.perspective !== "none" || a.contain === "paint" || ["transform", "perspective"].indexOf(a.willChange) !== -1 || e && a.willChange === "filter" || e && a.filter && a.filter !== "none")
      return r;
    r = r.parentNode;
  }
  return null;
}
function bt(t) {
  for (var e = ie(t), n = Rn(t); n && Ma(n) && Ie(n).position === "static"; )
    n = Rn(n);
  return n && (Ee(n) === "html" || Ee(n) === "body" && Ie(n).position === "static") ? e : n || Ba(t) || e;
}
function mn(t) {
  return ["top", "bottom"].indexOf(t) >= 0 ? "x" : "y";
}
function it(t, e, n) {
  return De(t, Mt(e, n));
}
function Ga(t, e, n) {
  var s = it(t, e, n);
  return s > n ? n : s;
}
function hs() {
  return {
    top: 0,
    right: 0,
    bottom: 0,
    left: 0
  };
}
function gs(t) {
  return Object.assign({}, hs(), t);
}
function ms(t, e) {
  return e.reduce(function(n, s) {
    return n[s] = t, n;
  }, {});
}
var Ha = function(e, n) {
  return e = typeof e == "function" ? e(Object.assign({}, n.rects, {
    placement: n.placement
  })) : e, gs(typeof e != "number" ? e : ms(e, At));
};
function Ua(t) {
  var e, n = t.state, s = t.name, r = t.options, a = n.elements.arrow, i = n.modifiersData.popperOffsets, l = ye(n.placement), c = mn(l), p = [se, de].indexOf(l) >= 0, o = p ? "height" : "width";
  if (!(!a || !i)) {
    var d = Ha(r.padding, n), m = gn(a), h = c === "y" ? ne : se, A = c === "y" ? ce : de, E = n.rects.reference[o] + n.rects.reference[c] - i[c] - n.rects.popper[o], y = i[c] - n.rects.reference[c], b = bt(a), v = b ? c === "y" ? b.clientHeight || 0 : b.clientWidth || 0 : 0, L = E / 2 - y / 2, g = d[h], _ = v - m[o] - d[A], I = v / 2 - m[o] / 2 + L, S = it(g, I, _), x = c;
    n.modifiersData[s] = (e = {}, e[x] = S, e.centerOffset = S - I, e);
  }
}
function $a(t) {
  var e = t.state, n = t.options, s = n.element, r = s === void 0 ? "[data-popper-arrow]" : s;
  r != null && (typeof r == "string" && (r = e.elements.popper.querySelector(r), !r) || fs(e.elements.popper, r) && (e.elements.arrow = r));
}
const Fa = {
  name: "arrow",
  enabled: !0,
  phase: "main",
  fn: Ua,
  effect: $a,
  requires: ["popperOffsets"],
  requiresIfExists: ["preventOverflow"]
};
function Ye(t) {
  return t.split("-")[1];
}
var Ka = {
  top: "auto",
  right: "auto",
  bottom: "auto",
  left: "auto"
};
function Wa(t, e) {
  var n = t.x, s = t.y, r = e.devicePixelRatio || 1;
  return {
    x: Ve(n * r) / r || 0,
    y: Ve(s * r) / r || 0
  };
}
function Dn(t) {
  var e, n = t.popper, s = t.popperRect, r = t.placement, a = t.variation, i = t.offsets, l = t.position, c = t.gpuAcceleration, p = t.adaptive, o = t.roundOffsets, d = t.isFixed, m = i.x, h = m === void 0 ? 0 : m, A = i.y, E = A === void 0 ? 0 : A, y = typeof o == "function" ? o({
    x: h,
    y: E
  }) : {
    x: h,
    y: E
  };
  h = y.x, E = y.y;
  var b = i.hasOwnProperty("x"), v = i.hasOwnProperty("y"), L = se, g = ne, _ = window;
  if (p) {
    var I = bt(n), S = "clientHeight", x = "clientWidth";
    if (I === ie(n) && (I = we(n), Ie(I).position !== "static" && l === "absolute" && (S = "scrollHeight", x = "scrollWidth")), I = I, r === ne || (r === se || r === de) && a === dt) {
      g = ce;
      var C = d && I === _ && _.visualViewport ? _.visualViewport.height : (
        // $FlowFixMe[prop-missing]
        I[S]
      );
      E -= C - s.height, E *= c ? 1 : -1;
    }
    if (r === se || (r === ne || r === ce) && a === dt) {
      L = de;
      var k = d && I === _ && _.visualViewport ? _.visualViewport.width : (
        // $FlowFixMe[prop-missing]
        I[x]
      );
      h -= k - s.width, h *= c ? 1 : -1;
    }
  }
  var D = Object.assign({
    position: l
  }, p && Ka), H = o === !0 ? Wa({
    x: h,
    y: E
  }, ie(n)) : {
    x: h,
    y: E
  };
  if (h = H.x, E = H.y, c) {
    var U;
    return Object.assign({}, D, (U = {}, U[g] = v ? "0" : "", U[L] = b ? "0" : "", U.transform = (_.devicePixelRatio || 1) <= 1 ? "translate(" + h + "px, " + E + "px)" : "translate3d(" + h + "px, " + E + "px, 0)", U));
  }
  return Object.assign({}, D, (e = {}, e[g] = v ? E + "px" : "", e[L] = b ? h + "px" : "", e.transform = "", e));
}
function za(t) {
  var e = t.state, n = t.options, s = n.gpuAcceleration, r = s === void 0 ? !0 : s, a = n.adaptive, i = a === void 0 ? !0 : a, l = n.roundOffsets, c = l === void 0 ? !0 : l, p = {
    placement: ye(e.placement),
    variation: Ye(e.placement),
    popper: e.elements.popper,
    popperRect: e.rects.popper,
    gpuAcceleration: r,
    isFixed: e.options.strategy === "fixed"
  };
  e.modifiersData.popperOffsets != null && (e.styles.popper = Object.assign({}, e.styles.popper, Dn(Object.assign({}, p, {
    offsets: e.modifiersData.popperOffsets,
    position: e.options.strategy,
    adaptive: i,
    roundOffsets: c
  })))), e.modifiersData.arrow != null && (e.styles.arrow = Object.assign({}, e.styles.arrow, Dn(Object.assign({}, p, {
    offsets: e.modifiersData.arrow,
    position: "absolute",
    adaptive: !1,
    roundOffsets: c
  })))), e.attributes.popper = Object.assign({}, e.attributes.popper, {
    "data-popper-placement": e.placement
  });
}
const Va = {
  name: "computeStyles",
  enabled: !0,
  phase: "beforeWrite",
  fn: za,
  data: {}
};
var wt = {
  passive: !0
};
function Qa(t) {
  var e = t.state, n = t.instance, s = t.options, r = s.scroll, a = r === void 0 ? !0 : r, i = s.resize, l = i === void 0 ? !0 : i, c = ie(e.elements.popper), p = [].concat(e.scrollParents.reference, e.scrollParents.popper);
  return a && p.forEach(function(o) {
    o.addEventListener("scroll", n.update, wt);
  }), l && c.addEventListener("resize", n.update, wt), function() {
    a && p.forEach(function(o) {
      o.removeEventListener("scroll", n.update, wt);
    }), l && c.removeEventListener("resize", n.update, wt);
  };
}
const Ya = {
  name: "eventListeners",
  enabled: !0,
  phase: "write",
  fn: function() {
  },
  effect: Qa,
  data: {}
};
var ja = {
  left: "right",
  right: "left",
  bottom: "top",
  top: "bottom"
};
function Pt(t) {
  return t.replace(/left|right|bottom|top/g, function(e) {
    return ja[e];
  });
}
var qa = {
  start: "end",
  end: "start"
};
function Mn(t) {
  return t.replace(/start|end/g, function(e) {
    return qa[e];
  });
}
function An(t) {
  var e = ie(t), n = e.pageXOffset, s = e.pageYOffset;
  return {
    scrollLeft: n,
    scrollTop: s
  };
}
function bn(t) {
  return Qe(we(t)).left + An(t).scrollLeft;
}
function Xa(t, e) {
  var n = ie(t), s = we(t), r = n.visualViewport, a = s.clientWidth, i = s.clientHeight, l = 0, c = 0;
  if (r) {
    a = r.width, i = r.height;
    var p = us();
    (p || !p && e === "fixed") && (l = r.offsetLeft, c = r.offsetTop);
  }
  return {
    width: a,
    height: i,
    x: l + bn(t),
    y: c
  };
}
function Ja(t) {
  var e, n = we(t), s = An(t), r = (e = t.ownerDocument) == null ? void 0 : e.body, a = De(n.scrollWidth, n.clientWidth, r ? r.scrollWidth : 0, r ? r.clientWidth : 0), i = De(n.scrollHeight, n.clientHeight, r ? r.scrollHeight : 0, r ? r.clientHeight : 0), l = -s.scrollLeft + bn(t), c = -s.scrollTop;
  return Ie(r || n).direction === "rtl" && (l += De(n.clientWidth, r ? r.clientWidth : 0) - a), {
    width: a,
    height: i,
    x: l,
    y: c
  };
}
function yn(t) {
  var e = Ie(t), n = e.overflow, s = e.overflowX, r = e.overflowY;
  return /auto|scroll|overlay|hidden/.test(n + r + s);
}
function As(t) {
  return ["html", "body", "#document"].indexOf(Ee(t)) >= 0 ? t.ownerDocument.body : le(t) && yn(t) ? t : As(Ht(t));
}
function rt(t, e) {
  var n;
  e === void 0 && (e = []);
  var s = As(t), r = s === ((n = t.ownerDocument) == null ? void 0 : n.body), a = ie(s), i = r ? [a].concat(a.visualViewport || [], yn(s) ? s : []) : s, l = e.concat(i);
  return r ? l : (
    // $FlowFixMe[incompatible-call]: isBody tells us target will be an HTMLElement here
    l.concat(rt(Ht(i)))
  );
}
function rn(t) {
  return Object.assign({}, t, {
    left: t.x,
    top: t.y,
    right: t.x + t.width,
    bottom: t.y + t.height
  });
}
function Za(t, e) {
  var n = Qe(t, !1, e === "fixed");
  return n.top = n.top + t.clientTop, n.left = n.left + t.clientLeft, n.bottom = n.top + t.clientHeight, n.right = n.left + t.clientWidth, n.width = t.clientWidth, n.height = t.clientHeight, n.x = n.left, n.y = n.top, n;
}
function Bn(t, e, n) {
  return e === cs ? rn(Xa(t, n)) : Be(e) ? Za(e, n) : rn(Ja(we(t)));
}
function ei(t) {
  var e = rt(Ht(t)), n = ["absolute", "fixed"].indexOf(Ie(t).position) >= 0, s = n && le(t) ? bt(t) : t;
  return Be(s) ? e.filter(function(r) {
    return Be(r) && fs(r, s) && Ee(r) !== "body";
  }) : [];
}
function ti(t, e, n, s) {
  var r = e === "clippingParents" ? ei(t) : [].concat(e), a = [].concat(r, [n]), i = a[0], l = a.reduce(function(c, p) {
    var o = Bn(t, p, s);
    return c.top = De(o.top, c.top), c.right = Mt(o.right, c.right), c.bottom = Mt(o.bottom, c.bottom), c.left = De(o.left, c.left), c;
  }, Bn(t, i, s));
  return l.width = l.right - l.left, l.height = l.bottom - l.top, l.x = l.left, l.y = l.top, l;
}
function bs(t) {
  var e = t.reference, n = t.element, s = t.placement, r = s ? ye(s) : null, a = s ? Ye(s) : null, i = e.x + e.width / 2 - n.width / 2, l = e.y + e.height / 2 - n.height / 2, c;
  switch (r) {
    case ne:
      c = {
        x: i,
        y: e.y - n.height
      };
      break;
    case ce:
      c = {
        x: i,
        y: e.y + e.height
      };
      break;
    case de:
      c = {
        x: e.x + e.width,
        y: l
      };
      break;
    case se:
      c = {
        x: e.x - n.width,
        y: l
      };
      break;
    default:
      c = {
        x: e.x,
        y: e.y
      };
  }
  var p = r ? mn(r) : null;
  if (p != null) {
    var o = p === "y" ? "height" : "width";
    switch (a) {
      case ze:
        c[p] = c[p] - (e[o] / 2 - n[o] / 2);
        break;
      case dt:
        c[p] = c[p] + (e[o] / 2 - n[o] / 2);
        break;
    }
  }
  return c;
}
function pt(t, e) {
  e === void 0 && (e = {});
  var n = e, s = n.placement, r = s === void 0 ? t.placement : s, a = n.strategy, i = a === void 0 ? t.strategy : a, l = n.boundary, c = l === void 0 ? La : l, p = n.rootBoundary, o = p === void 0 ? cs : p, d = n.elementContext, m = d === void 0 ? st : d, h = n.altBoundary, A = h === void 0 ? !1 : h, E = n.padding, y = E === void 0 ? 0 : E, b = gs(typeof y != "number" ? y : ms(y, At)), v = m === st ? Ta : st, L = t.rects.popper, g = t.elements[A ? v : m], _ = ti(Be(g) ? g : g.contextElement || we(t.elements.popper), c, o, i), I = Qe(t.elements.reference), S = bs({
    reference: I,
    element: L,
    placement: r
  }), x = rn(Object.assign({}, L, S)), C = m === st ? x : I, k = {
    top: _.top - C.top + b.top,
    bottom: C.bottom - _.bottom + b.bottom,
    left: _.left - C.left + b.left,
    right: C.right - _.right + b.right
  }, D = t.modifiersData.offset;
  if (m === st && D) {
    var H = D[r];
    Object.keys(k).forEach(function(U) {
      var W = [de, ce].indexOf(U) >= 0 ? 1 : -1, z = [ne, ce].indexOf(U) >= 0 ? "y" : "x";
      k[U] += H[z] * W;
    });
  }
  return k;
}
function ni(t, e) {
  e === void 0 && (e = {});
  var n = e, s = n.placement, r = n.boundary, a = n.rootBoundary, i = n.padding, l = n.flipVariations, c = n.allowedAutoPlacements, p = c === void 0 ? ds : c, o = Ye(s), d = o ? l ? Pn : Pn.filter(function(A) {
    return Ye(A) === o;
  }) : At, m = d.filter(function(A) {
    return p.indexOf(A) >= 0;
  });
  m.length === 0 && (m = d);
  var h = m.reduce(function(A, E) {
    return A[E] = pt(t, {
      placement: E,
      boundary: r,
      rootBoundary: a,
      padding: i
    })[ye(E)], A;
  }, {});
  return Object.keys(h).sort(function(A, E) {
    return h[A] - h[E];
  });
}
function si(t) {
  if (ye(t) === fn)
    return [];
  var e = Pt(t);
  return [Mn(t), e, Mn(e)];
}
function ai(t) {
  var e = t.state, n = t.options, s = t.name;
  if (!e.modifiersData[s]._skip) {
    for (var r = n.mainAxis, a = r === void 0 ? !0 : r, i = n.altAxis, l = i === void 0 ? !0 : i, c = n.fallbackPlacements, p = n.padding, o = n.boundary, d = n.rootBoundary, m = n.altBoundary, h = n.flipVariations, A = h === void 0 ? !0 : h, E = n.allowedAutoPlacements, y = e.options.placement, b = ye(y), v = b === y, L = c || (v || !A ? [Pt(y)] : si(y)), g = [y].concat(L).reduce(function(X, J) {
      return X.concat(ye(J) === fn ? ni(e, {
        placement: J,
        boundary: o,
        rootBoundary: d,
        padding: p,
        flipVariations: A,
        allowedAutoPlacements: E
      }) : J);
    }, []), _ = e.rects.reference, I = e.rects.popper, S = /* @__PURE__ */ new Map(), x = !0, C = g[0], k = 0; k < g.length; k++) {
      var D = g[k], H = ye(D), U = Ye(D) === ze, W = [ne, ce].indexOf(H) >= 0, z = W ? "width" : "height", w = pt(e, {
        placement: D,
        boundary: o,
        rootBoundary: d,
        altBoundary: m,
        padding: p
      }), R = W ? U ? de : se : U ? ce : ne;
      _[z] > I[z] && (R = Pt(R));
      var G = Pt(R), F = [];
      if (a && F.push(w[H] <= 0), l && F.push(w[R] <= 0, w[G] <= 0), F.every(function(X) {
        return X;
      })) {
        C = D, x = !1;
        break;
      }
      S.set(D, F);
    }
    if (x)
      for (var V = A ? 3 : 1, pe = function(J) {
        var ue = g.find(function(me) {
          var fe = S.get(me);
          if (fe)
            return fe.slice(0, J).every(function(Ge) {
              return Ge;
            });
        });
        if (ue)
          return C = ue, "break";
      }, ae = V; ae > 0; ae--) {
        var Y = pe(ae);
        if (Y === "break") break;
      }
    e.placement !== C && (e.modifiersData[s]._skip = !0, e.placement = C, e.reset = !0);
  }
}
const ii = {
  name: "flip",
  enabled: !0,
  phase: "main",
  fn: ai,
  requiresIfExists: ["offset"],
  data: {
    _skip: !1
  }
};
function Gn(t, e, n) {
  return n === void 0 && (n = {
    x: 0,
    y: 0
  }), {
    top: t.top - e.height - n.y,
    right: t.right - e.width + n.x,
    bottom: t.bottom - e.height + n.y,
    left: t.left - e.width - n.x
  };
}
function Hn(t) {
  return [ne, de, ce, se].some(function(e) {
    return t[e] >= 0;
  });
}
function ri(t) {
  var e = t.state, n = t.name, s = e.rects.reference, r = e.rects.popper, a = e.modifiersData.preventOverflow, i = pt(e, {
    elementContext: "reference"
  }), l = pt(e, {
    altBoundary: !0
  }), c = Gn(i, s), p = Gn(l, r, a), o = Hn(c), d = Hn(p);
  e.modifiersData[n] = {
    referenceClippingOffsets: c,
    popperEscapeOffsets: p,
    isReferenceHidden: o,
    hasPopperEscaped: d
  }, e.attributes.popper = Object.assign({}, e.attributes.popper, {
    "data-popper-reference-hidden": o,
    "data-popper-escaped": d
  });
}
const oi = {
  name: "hide",
  enabled: !0,
  phase: "main",
  requiresIfExists: ["preventOverflow"],
  fn: ri
};
function li(t, e, n) {
  var s = ye(t), r = [se, ne].indexOf(s) >= 0 ? -1 : 1, a = typeof n == "function" ? n(Object.assign({}, e, {
    placement: t
  })) : n, i = a[0], l = a[1];
  return i = i || 0, l = (l || 0) * r, [se, de].indexOf(s) >= 0 ? {
    x: l,
    y: i
  } : {
    x: i,
    y: l
  };
}
function ci(t) {
  var e = t.state, n = t.options, s = t.name, r = n.offset, a = r === void 0 ? [0, 0] : r, i = ds.reduce(function(o, d) {
    return o[d] = li(d, e.rects, a), o;
  }, {}), l = i[e.placement], c = l.x, p = l.y;
  e.modifiersData.popperOffsets != null && (e.modifiersData.popperOffsets.x += c, e.modifiersData.popperOffsets.y += p), e.modifiersData[s] = i;
}
const di = {
  name: "offset",
  enabled: !0,
  phase: "main",
  requires: ["popperOffsets"],
  fn: ci
};
function pi(t) {
  var e = t.state, n = t.name;
  e.modifiersData[n] = bs({
    reference: e.rects.reference,
    element: e.rects.popper,
    placement: e.placement
  });
}
const ui = {
  name: "popperOffsets",
  enabled: !0,
  phase: "read",
  fn: pi,
  data: {}
};
function fi(t) {
  return t === "x" ? "y" : "x";
}
function hi(t) {
  var e = t.state, n = t.options, s = t.name, r = n.mainAxis, a = r === void 0 ? !0 : r, i = n.altAxis, l = i === void 0 ? !1 : i, c = n.boundary, p = n.rootBoundary, o = n.altBoundary, d = n.padding, m = n.tether, h = m === void 0 ? !0 : m, A = n.tetherOffset, E = A === void 0 ? 0 : A, y = pt(e, {
    boundary: c,
    rootBoundary: p,
    padding: d,
    altBoundary: o
  }), b = ye(e.placement), v = Ye(e.placement), L = !v, g = mn(b), _ = fi(g), I = e.modifiersData.popperOffsets, S = e.rects.reference, x = e.rects.popper, C = typeof E == "function" ? E(Object.assign({}, e.rects, {
    placement: e.placement
  })) : E, k = typeof C == "number" ? {
    mainAxis: C,
    altAxis: C
  } : Object.assign({
    mainAxis: 0,
    altAxis: 0
  }, C), D = e.modifiersData.offset ? e.modifiersData.offset[e.placement] : null, H = {
    x: 0,
    y: 0
  };
  if (I) {
    if (a) {
      var U, W = g === "y" ? ne : se, z = g === "y" ? ce : de, w = g === "y" ? "height" : "width", R = I[g], G = R + y[W], F = R - y[z], V = h ? -x[w] / 2 : 0, pe = v === ze ? S[w] : x[w], ae = v === ze ? -x[w] : -S[w], Y = e.elements.arrow, X = h && Y ? gn(Y) : {
        width: 0,
        height: 0
      }, J = e.modifiersData["arrow#persistent"] ? e.modifiersData["arrow#persistent"].padding : hs(), ue = J[W], me = J[z], fe = it(0, S[w], X[w]), Ge = L ? S[w] / 2 - V - fe - ue - k.mainAxis : pe - fe - ue - k.mainAxis, _e = L ? -S[w] / 2 + V + fe + me + k.mainAxis : ae + fe + me + k.mainAxis, He = e.elements.arrow && bt(e.elements.arrow), yt = He ? g === "y" ? He.clientTop || 0 : He.clientLeft || 0 : 0, Xe = (U = D?.[g]) != null ? U : 0, Et = R + Ge - Xe - yt, vt = R + _e - Xe, Je = it(h ? Mt(G, Et) : G, R, h ? De(F, vt) : F);
      I[g] = Je, H[g] = Je - R;
    }
    if (l) {
      var Ze, Lt = g === "x" ? ne : se, Tt = g === "x" ? ce : de, ve = I[_], xe = _ === "y" ? "height" : "width", et = ve + y[Lt], Ce = ve - y[Tt], tt = [ne, se].indexOf(b) !== -1, It = (Ze = D?.[_]) != null ? Ze : 0, _t = tt ? et : ve - S[xe] - x[xe] - It + k.altAxis, xt = tt ? ve + S[xe] + x[xe] - It - k.altAxis : Ce, Nt = h && tt ? Ga(_t, ve, xt) : it(h ? _t : et, ve, h ? xt : Ce);
      I[_] = Nt, H[_] = Nt - ve;
    }
    e.modifiersData[s] = H;
  }
}
const gi = {
  name: "preventOverflow",
  enabled: !0,
  phase: "main",
  fn: hi,
  requiresIfExists: ["offset"]
};
function mi(t) {
  return {
    scrollLeft: t.scrollLeft,
    scrollTop: t.scrollTop
  };
}
function Ai(t) {
  return t === ie(t) || !le(t) ? An(t) : mi(t);
}
function bi(t) {
  var e = t.getBoundingClientRect(), n = Ve(e.width) / t.offsetWidth || 1, s = Ve(e.height) / t.offsetHeight || 1;
  return n !== 1 || s !== 1;
}
function yi(t, e, n) {
  n === void 0 && (n = !1);
  var s = le(e), r = le(e) && bi(e), a = we(e), i = Qe(t, r, n), l = {
    scrollLeft: 0,
    scrollTop: 0
  }, c = {
    x: 0,
    y: 0
  };
  return (s || !s && !n) && ((Ee(e) !== "body" || // https://github.com/popperjs/popper-core/issues/1078
  yn(a)) && (l = Ai(e)), le(e) ? (c = Qe(e, !0), c.x += e.clientLeft, c.y += e.clientTop) : a && (c.x = bn(a))), {
    x: i.left + l.scrollLeft - c.x,
    y: i.top + l.scrollTop - c.y,
    width: i.width,
    height: i.height
  };
}
function Ei(t) {
  var e = /* @__PURE__ */ new Map(), n = /* @__PURE__ */ new Set(), s = [];
  t.forEach(function(a) {
    e.set(a.name, a);
  });
  function r(a) {
    n.add(a.name);
    var i = [].concat(a.requires || [], a.requiresIfExists || []);
    i.forEach(function(l) {
      if (!n.has(l)) {
        var c = e.get(l);
        c && r(c);
      }
    }), s.push(a);
  }
  return t.forEach(function(a) {
    n.has(a.name) || r(a);
  }), s;
}
function vi(t) {
  var e = Ei(t);
  return Pa.reduce(function(n, s) {
    return n.concat(e.filter(function(r) {
      return r.phase === s;
    }));
  }, []);
}
function Li(t) {
  var e;
  return function() {
    return e || (e = new Promise(function(n) {
      Promise.resolve().then(function() {
        e = void 0, n(t());
      });
    })), e;
  };
}
function Ti(t) {
  var e = t.reduce(function(n, s) {
    var r = n[s.name];
    return n[s.name] = r ? Object.assign({}, r, s, {
      options: Object.assign({}, r.options, s.options),
      data: Object.assign({}, r.data, s.data)
    }) : s, n;
  }, {});
  return Object.keys(e).map(function(n) {
    return e[n];
  });
}
var Un = {
  placement: "bottom",
  modifiers: [],
  strategy: "absolute"
};
function $n() {
  for (var t = arguments.length, e = new Array(t), n = 0; n < t; n++)
    e[n] = arguments[n];
  return !e.some(function(s) {
    return !(s && typeof s.getBoundingClientRect == "function");
  });
}
function Ii(t) {
  t === void 0 && (t = {});
  var e = t, n = e.defaultModifiers, s = n === void 0 ? [] : n, r = e.defaultOptions, a = r === void 0 ? Un : r;
  return function(l, c, p) {
    p === void 0 && (p = a);
    var o = {
      placement: "bottom",
      orderedModifiers: [],
      options: Object.assign({}, Un, a),
      modifiersData: {},
      elements: {
        reference: l,
        popper: c
      },
      attributes: {},
      styles: {}
    }, d = [], m = !1, h = {
      state: o,
      setOptions: function(b) {
        var v = typeof b == "function" ? b(o.options) : b;
        E(), o.options = Object.assign({}, a, o.options, v), o.scrollParents = {
          reference: Be(l) ? rt(l) : l.contextElement ? rt(l.contextElement) : [],
          popper: rt(c)
        };
        var L = vi(Ti([].concat(s, o.options.modifiers)));
        return o.orderedModifiers = L.filter(function(g) {
          return g.enabled;
        }), A(), h.update();
      },
      // Sync update – it will always be executed, even if not necessary. This
      // is useful for low frequency updates where sync behavior simplifies the
      // logic.
      // For high frequency updates (e.g. `resize` and `scroll` events), always
      // prefer the async Popper#update method
      forceUpdate: function() {
        if (!m) {
          var b = o.elements, v = b.reference, L = b.popper;
          if ($n(v, L)) {
            o.rects = {
              reference: yi(v, bt(L), o.options.strategy === "fixed"),
              popper: gn(L)
            }, o.reset = !1, o.placement = o.options.placement, o.orderedModifiers.forEach(function(k) {
              return o.modifiersData[k.name] = Object.assign({}, k.data);
            });
            for (var g = 0; g < o.orderedModifiers.length; g++) {
              if (o.reset === !0) {
                o.reset = !1, g = -1;
                continue;
              }
              var _ = o.orderedModifiers[g], I = _.fn, S = _.options, x = S === void 0 ? {} : S, C = _.name;
              typeof I == "function" && (o = I({
                state: o,
                options: x,
                name: C,
                instance: h
              }) || o);
            }
          }
        }
      },
      // Async and optimistically optimized update – it will not be executed if
      // not necessary (debounced to run at most once-per-tick)
      update: Li(function() {
        return new Promise(function(y) {
          h.forceUpdate(), y(o);
        });
      }),
      destroy: function() {
        E(), m = !0;
      }
    };
    if (!$n(l, c))
      return h;
    h.setOptions(p).then(function(y) {
      !m && p.onFirstUpdate && p.onFirstUpdate(y);
    });
    function A() {
      o.orderedModifiers.forEach(function(y) {
        var b = y.name, v = y.options, L = v === void 0 ? {} : v, g = y.effect;
        if (typeof g == "function") {
          var _ = g({
            state: o,
            name: b,
            instance: h,
            options: L
          }), I = function() {
          };
          d.push(_ || I);
        }
      });
    }
    function E() {
      d.forEach(function(y) {
        return y();
      }), d = [];
    }
    return h;
  };
}
var _i = [Ya, ui, Va, ps, di, ii, gi, Fa, oi], xi = /* @__PURE__ */ Ii({
  defaultModifiers: _i
}), Ni = "tippy-box", ys = "tippy-content", Si = "tippy-backdrop", Es = "tippy-arrow", vs = "tippy-svg-arrow", Pe = {
  passive: !0,
  capture: !0
}, Ls = function() {
  return document.body;
};
function qt(t, e, n) {
  if (Array.isArray(t)) {
    var s = t[e];
    return s ?? (Array.isArray(n) ? n[e] : n);
  }
  return t;
}
function En(t, e) {
  var n = {}.toString.call(t);
  return n.indexOf("[object") === 0 && n.indexOf(e + "]") > -1;
}
function Ts(t, e) {
  return typeof t == "function" ? t.apply(void 0, e) : t;
}
function Fn(t, e) {
  if (e === 0)
    return t;
  var n;
  return function(s) {
    clearTimeout(n), n = setTimeout(function() {
      t(s);
    }, e);
  };
}
function ki(t) {
  return t.split(/\s+/).filter(Boolean);
}
function Ke(t) {
  return [].concat(t);
}
function Kn(t, e) {
  t.indexOf(e) === -1 && t.push(e);
}
function wi(t) {
  return t.filter(function(e, n) {
    return t.indexOf(e) === n;
  });
}
function Ci(t) {
  return t.split("-")[0];
}
function Bt(t) {
  return [].slice.call(t);
}
function Wn(t) {
  return Object.keys(t).reduce(function(e, n) {
    return t[n] !== void 0 && (e[n] = t[n]), e;
  }, {});
}
function ot() {
  return document.createElement("div");
}
function Ut(t) {
  return ["Element", "Fragment"].some(function(e) {
    return En(t, e);
  });
}
function Oi(t) {
  return En(t, "NodeList");
}
function Pi(t) {
  return En(t, "MouseEvent");
}
function Ri(t) {
  return !!(t && t._tippy && t._tippy.reference === t);
}
function Di(t) {
  return Ut(t) ? [t] : Oi(t) ? Bt(t) : Array.isArray(t) ? t : Bt(document.querySelectorAll(t));
}
function Xt(t, e) {
  t.forEach(function(n) {
    n && (n.style.transitionDuration = e + "ms");
  });
}
function zn(t, e) {
  t.forEach(function(n) {
    n && n.setAttribute("data-state", e);
  });
}
function Mi(t) {
  var e, n = Ke(t), s = n[0];
  return s != null && (e = s.ownerDocument) != null && e.body ? s.ownerDocument : document;
}
function Bi(t, e) {
  var n = e.clientX, s = e.clientY;
  return t.every(function(r) {
    var a = r.popperRect, i = r.popperState, l = r.props, c = l.interactiveBorder, p = Ci(i.placement), o = i.modifiersData.offset;
    if (!o)
      return !0;
    var d = p === "bottom" ? o.top.y : 0, m = p === "top" ? o.bottom.y : 0, h = p === "right" ? o.left.x : 0, A = p === "left" ? o.right.x : 0, E = a.top - s + d > c, y = s - a.bottom - m > c, b = a.left - n + h > c, v = n - a.right - A > c;
    return E || y || b || v;
  });
}
function Jt(t, e, n) {
  var s = e + "EventListener";
  ["transitionend", "webkitTransitionEnd"].forEach(function(r) {
    t[s](r, n);
  });
}
function Vn(t, e) {
  for (var n = e; n; ) {
    var s;
    if (t.contains(n))
      return !0;
    n = n.getRootNode == null || (s = n.getRootNode()) == null ? void 0 : s.host;
  }
  return !1;
}
var Ae = {
  isTouch: !1
}, Qn = 0;
function Gi() {
  Ae.isTouch || (Ae.isTouch = !0, window.performance && document.addEventListener("mousemove", Is));
}
function Is() {
  var t = performance.now();
  t - Qn < 20 && (Ae.isTouch = !1, document.removeEventListener("mousemove", Is)), Qn = t;
}
function Hi() {
  var t = document.activeElement;
  if (Ri(t)) {
    var e = t._tippy;
    t.blur && !e.state.isVisible && t.blur();
  }
}
function Ui() {
  document.addEventListener("touchstart", Gi, Pe), window.addEventListener("blur", Hi);
}
var $i = typeof window < "u" && typeof document < "u", Fi = $i ? (
  // @ts-ignore
  !!window.msCrypto
) : !1, Ki = {
  animateFill: !1,
  followCursor: !1,
  inlinePositioning: !1,
  sticky: !1
}, Wi = {
  allowHTML: !1,
  animation: "fade",
  arrow: !0,
  content: "",
  inertia: !1,
  maxWidth: 350,
  role: "tooltip",
  theme: "",
  zIndex: 9999
}, ge = Object.assign({
  appendTo: Ls,
  aria: {
    content: "auto",
    expanded: "auto"
  },
  delay: 0,
  duration: [300, 250],
  getReferenceClientRect: null,
  hideOnClick: !0,
  ignoreAttributes: !1,
  interactive: !1,
  interactiveBorder: 2,
  interactiveDebounce: 0,
  moveTransition: "",
  offset: [0, 10],
  onAfterUpdate: function() {
  },
  onBeforeUpdate: function() {
  },
  onCreate: function() {
  },
  onDestroy: function() {
  },
  onHidden: function() {
  },
  onHide: function() {
  },
  onMount: function() {
  },
  onShow: function() {
  },
  onShown: function() {
  },
  onTrigger: function() {
  },
  onUntrigger: function() {
  },
  onClickOutside: function() {
  },
  placement: "top",
  plugins: [],
  popperOptions: {},
  render: null,
  showOnCreate: !1,
  touch: !0,
  trigger: "mouseenter focus",
  triggerTarget: null
}, Ki, Wi), zi = Object.keys(ge), Vi = function(e) {
  var n = Object.keys(e);
  n.forEach(function(s) {
    ge[s] = e[s];
  });
};
function _s(t) {
  var e = t.plugins || [], n = e.reduce(function(s, r) {
    var a = r.name, i = r.defaultValue;
    if (a) {
      var l;
      s[a] = t[a] !== void 0 ? t[a] : (l = ge[a]) != null ? l : i;
    }
    return s;
  }, {});
  return Object.assign({}, t, n);
}
function Qi(t, e) {
  var n = e ? Object.keys(_s(Object.assign({}, ge, {
    plugins: e
  }))) : zi, s = n.reduce(function(r, a) {
    var i = (t.getAttribute("data-tippy-" + a) || "").trim();
    if (!i)
      return r;
    if (a === "content")
      r[a] = i;
    else
      try {
        r[a] = JSON.parse(i);
      } catch {
        r[a] = i;
      }
    return r;
  }, {});
  return s;
}
function Yn(t, e) {
  var n = Object.assign({}, e, {
    content: Ts(e.content, [t])
  }, e.ignoreAttributes ? {} : Qi(t, e.plugins));
  return n.aria = Object.assign({}, ge.aria, n.aria), n.aria = {
    expanded: n.aria.expanded === "auto" ? e.interactive : n.aria.expanded,
    content: n.aria.content === "auto" ? e.interactive ? null : "describedby" : n.aria.content
  }, n;
}
var Yi = function() {
  return "innerHTML";
};
function on(t, e) {
  t[Yi()] = e;
}
function jn(t) {
  var e = ot();
  return t === !0 ? e.className = Es : (e.className = vs, Ut(t) ? e.appendChild(t) : on(e, t)), e;
}
function qn(t, e) {
  Ut(e.content) ? (on(t, ""), t.appendChild(e.content)) : typeof e.content != "function" && (e.allowHTML ? on(t, e.content) : t.textContent = e.content);
}
function ln(t) {
  var e = t.firstElementChild, n = Bt(e.children);
  return {
    box: e,
    content: n.find(function(s) {
      return s.classList.contains(ys);
    }),
    arrow: n.find(function(s) {
      return s.classList.contains(Es) || s.classList.contains(vs);
    }),
    backdrop: n.find(function(s) {
      return s.classList.contains(Si);
    })
  };
}
function xs(t) {
  var e = ot(), n = ot();
  n.className = Ni, n.setAttribute("data-state", "hidden"), n.setAttribute("tabindex", "-1");
  var s = ot();
  s.className = ys, s.setAttribute("data-state", "hidden"), qn(s, t.props), e.appendChild(n), n.appendChild(s), r(t.props, t.props);
  function r(a, i) {
    var l = ln(e), c = l.box, p = l.content, o = l.arrow;
    i.theme ? c.setAttribute("data-theme", i.theme) : c.removeAttribute("data-theme"), typeof i.animation == "string" ? c.setAttribute("data-animation", i.animation) : c.removeAttribute("data-animation"), i.inertia ? c.setAttribute("data-inertia", "") : c.removeAttribute("data-inertia"), c.style.maxWidth = typeof i.maxWidth == "number" ? i.maxWidth + "px" : i.maxWidth, i.role ? c.setAttribute("role", i.role) : c.removeAttribute("role"), (a.content !== i.content || a.allowHTML !== i.allowHTML) && qn(p, t.props), i.arrow ? o ? a.arrow !== i.arrow && (c.removeChild(o), c.appendChild(jn(i.arrow))) : c.appendChild(jn(i.arrow)) : o && c.removeChild(o);
  }
  return {
    popper: e,
    onUpdate: r
  };
}
xs.$$tippy = !0;
var ji = 1, Ct = [], Zt = [];
function qi(t, e) {
  var n = Yn(t, Object.assign({}, ge, _s(Wn(e)))), s, r, a, i = !1, l = !1, c = !1, p = !1, o, d, m, h = [], A = Fn(Et, n.interactiveDebounce), E, y = ji++, b = null, v = wi(n.plugins), L = {
    // Is the instance currently enabled?
    isEnabled: !0,
    // Is the tippy currently showing and not transitioning out?
    isVisible: !1,
    // Has the instance been destroyed?
    isDestroyed: !1,
    // Is the tippy currently mounted to the DOM?
    isMounted: !1,
    // Has the tippy finished transitioning in?
    isShown: !1
  }, g = {
    // properties
    id: y,
    reference: t,
    popper: ot(),
    popperInstance: b,
    props: n,
    state: L,
    plugins: v,
    // methods
    clearDelayTimeouts: _t,
    setProps: xt,
    setContent: Nt,
    show: Ds,
    hide: Ms,
    hideWithInteractivity: Bs,
    enable: tt,
    disable: It,
    unmount: Gs,
    destroy: Hs
  };
  if (!n.render)
    return g;
  var _ = n.render(g), I = _.popper, S = _.onUpdate;
  I.setAttribute("data-tippy-root", ""), I.id = "tippy-" + g.id, g.popper = I, t._tippy = g, I._tippy = g;
  var x = v.map(function(T) {
    return T.fn(g);
  }), C = t.hasAttribute("aria-expanded");
  return He(), V(), R(), G("onCreate", [g]), n.showOnCreate && et(), I.addEventListener("mouseenter", function() {
    g.props.interactive && g.state.isVisible && g.clearDelayTimeouts();
  }), I.addEventListener("mouseleave", function() {
    g.props.interactive && g.props.trigger.indexOf("mouseenter") >= 0 && W().addEventListener("mousemove", A);
  }), g;
  function k() {
    var T = g.props.touch;
    return Array.isArray(T) ? T : [T, 0];
  }
  function D() {
    return k()[0] === "hold";
  }
  function H() {
    var T;
    return !!((T = g.props.render) != null && T.$$tippy);
  }
  function U() {
    return E || t;
  }
  function W() {
    var T = U().parentNode;
    return T ? Mi(T) : document;
  }
  function z() {
    return ln(I);
  }
  function w(T) {
    return g.state.isMounted && !g.state.isVisible || Ae.isTouch || o && o.type === "focus" ? 0 : qt(g.props.delay, T ? 0 : 1, ge.delay);
  }
  function R(T) {
    T === void 0 && (T = !1), I.style.pointerEvents = g.props.interactive && !T ? "" : "none", I.style.zIndex = "" + g.props.zIndex;
  }
  function G(T, O, B) {
    if (B === void 0 && (B = !0), x.forEach(function($) {
      $[T] && $[T].apply($, O);
    }), B) {
      var K;
      (K = g.props)[T].apply(K, O);
    }
  }
  function F() {
    var T = g.props.aria;
    if (T.content) {
      var O = "aria-" + T.content, B = I.id, K = Ke(g.props.triggerTarget || t);
      K.forEach(function($) {
        var Z = $.getAttribute(O);
        if (g.state.isVisible)
          $.setAttribute(O, Z ? Z + " " + B : B);
        else {
          var re = Z && Z.replace(B, "").trim();
          re ? $.setAttribute(O, re) : $.removeAttribute(O);
        }
      });
    }
  }
  function V() {
    if (!(C || !g.props.aria.expanded)) {
      var T = Ke(g.props.triggerTarget || t);
      T.forEach(function(O) {
        g.props.interactive ? O.setAttribute("aria-expanded", g.state.isVisible && O === U() ? "true" : "false") : O.removeAttribute("aria-expanded");
      });
    }
  }
  function pe() {
    W().removeEventListener("mousemove", A), Ct = Ct.filter(function(T) {
      return T !== A;
    });
  }
  function ae(T) {
    if (!(Ae.isTouch && (c || T.type === "mousedown"))) {
      var O = T.composedPath && T.composedPath()[0] || T.target;
      if (!(g.props.interactive && Vn(I, O))) {
        if (Ke(g.props.triggerTarget || t).some(function(B) {
          return Vn(B, O);
        })) {
          if (Ae.isTouch || g.state.isVisible && g.props.trigger.indexOf("click") >= 0)
            return;
        } else
          G("onClickOutside", [g, T]);
        g.props.hideOnClick === !0 && (g.clearDelayTimeouts(), g.hide(), l = !0, setTimeout(function() {
          l = !1;
        }), g.state.isMounted || ue());
      }
    }
  }
  function Y() {
    c = !0;
  }
  function X() {
    c = !1;
  }
  function J() {
    var T = W();
    T.addEventListener("mousedown", ae, !0), T.addEventListener("touchend", ae, Pe), T.addEventListener("touchstart", X, Pe), T.addEventListener("touchmove", Y, Pe);
  }
  function ue() {
    var T = W();
    T.removeEventListener("mousedown", ae, !0), T.removeEventListener("touchend", ae, Pe), T.removeEventListener("touchstart", X, Pe), T.removeEventListener("touchmove", Y, Pe);
  }
  function me(T, O) {
    Ge(T, function() {
      !g.state.isVisible && I.parentNode && I.parentNode.contains(I) && O();
    });
  }
  function fe(T, O) {
    Ge(T, O);
  }
  function Ge(T, O) {
    var B = z().box;
    function K($) {
      $.target === B && (Jt(B, "remove", K), O());
    }
    if (T === 0)
      return O();
    Jt(B, "remove", d), Jt(B, "add", K), d = K;
  }
  function _e(T, O, B) {
    B === void 0 && (B = !1);
    var K = Ke(g.props.triggerTarget || t);
    K.forEach(function($) {
      $.addEventListener(T, O, B), h.push({
        node: $,
        eventType: T,
        handler: O,
        options: B
      });
    });
  }
  function He() {
    D() && (_e("touchstart", Xe, {
      passive: !0
    }), _e("touchend", vt, {
      passive: !0
    })), ki(g.props.trigger).forEach(function(T) {
      if (T !== "manual")
        switch (_e(T, Xe), T) {
          case "mouseenter":
            _e("mouseleave", vt);
            break;
          case "focus":
            _e(Fi ? "focusout" : "blur", Je);
            break;
          case "focusin":
            _e("focusout", Je);
            break;
        }
    });
  }
  function yt() {
    h.forEach(function(T) {
      var O = T.node, B = T.eventType, K = T.handler, $ = T.options;
      O.removeEventListener(B, K, $);
    }), h = [];
  }
  function Xe(T) {
    var O, B = !1;
    if (!(!g.state.isEnabled || Ze(T) || l)) {
      var K = ((O = o) == null ? void 0 : O.type) === "focus";
      o = T, E = T.currentTarget, V(), !g.state.isVisible && Pi(T) && Ct.forEach(function($) {
        return $(T);
      }), T.type === "click" && (g.props.trigger.indexOf("mouseenter") < 0 || i) && g.props.hideOnClick !== !1 && g.state.isVisible ? B = !0 : et(T), T.type === "click" && (i = !B), B && !K && Ce(T);
    }
  }
  function Et(T) {
    var O = T.target, B = U().contains(O) || I.contains(O);
    if (!(T.type === "mousemove" && B)) {
      var K = xe().concat(I).map(function($) {
        var Z, re = $._tippy, Ue = (Z = re.popperInstance) == null ? void 0 : Z.state;
        return Ue ? {
          popperRect: $.getBoundingClientRect(),
          popperState: Ue,
          props: n
        } : null;
      }).filter(Boolean);
      Bi(K, T) && (pe(), Ce(T));
    }
  }
  function vt(T) {
    var O = Ze(T) || g.props.trigger.indexOf("click") >= 0 && i;
    if (!O) {
      if (g.props.interactive) {
        g.hideWithInteractivity(T);
        return;
      }
      Ce(T);
    }
  }
  function Je(T) {
    g.props.trigger.indexOf("focusin") < 0 && T.target !== U() || g.props.interactive && T.relatedTarget && I.contains(T.relatedTarget) || Ce(T);
  }
  function Ze(T) {
    return Ae.isTouch ? D() !== T.type.indexOf("touch") >= 0 : !1;
  }
  function Lt() {
    Tt();
    var T = g.props, O = T.popperOptions, B = T.placement, K = T.offset, $ = T.getReferenceClientRect, Z = T.moveTransition, re = H() ? ln(I).arrow : null, Ue = $ ? {
      getBoundingClientRect: $,
      contextElement: $.contextElement || U()
    } : t, In = {
      name: "$$tippy",
      enabled: !0,
      phase: "beforeWrite",
      requires: ["computeStyles"],
      fn: function(St) {
        var $e = St.state;
        if (H()) {
          var Us = z(), Kt = Us.box;
          ["placement", "reference-hidden", "escaped"].forEach(function(kt) {
            kt === "placement" ? Kt.setAttribute("data-placement", $e.placement) : $e.attributes.popper["data-popper-" + kt] ? Kt.setAttribute("data-" + kt, "") : Kt.removeAttribute("data-" + kt);
          }), $e.attributes.popper = {};
        }
      }
    }, Oe = [{
      name: "offset",
      options: {
        offset: K
      }
    }, {
      name: "preventOverflow",
      options: {
        padding: {
          top: 2,
          bottom: 2,
          left: 5,
          right: 5
        }
      }
    }, {
      name: "flip",
      options: {
        padding: 5
      }
    }, {
      name: "computeStyles",
      options: {
        adaptive: !Z
      }
    }, In];
    H() && re && Oe.push({
      name: "arrow",
      options: {
        element: re,
        padding: 3
      }
    }), Oe.push.apply(Oe, O?.modifiers || []), g.popperInstance = xi(Ue, I, Object.assign({}, O, {
      placement: B,
      onFirstUpdate: m,
      modifiers: Oe
    }));
  }
  function Tt() {
    g.popperInstance && (g.popperInstance.destroy(), g.popperInstance = null);
  }
  function ve() {
    var T = g.props.appendTo, O, B = U();
    g.props.interactive && T === Ls || T === "parent" ? O = B.parentNode : O = Ts(T, [B]), O.contains(I) || O.appendChild(I), g.state.isMounted = !0, Lt();
  }
  function xe() {
    return Bt(I.querySelectorAll("[data-tippy-root]"));
  }
  function et(T) {
    g.clearDelayTimeouts(), T && G("onTrigger", [g, T]), J();
    var O = w(!0), B = k(), K = B[0], $ = B[1];
    Ae.isTouch && K === "hold" && $ && (O = $), O ? s = setTimeout(function() {
      g.show();
    }, O) : g.show();
  }
  function Ce(T) {
    if (g.clearDelayTimeouts(), G("onUntrigger", [g, T]), !g.state.isVisible) {
      ue();
      return;
    }
    if (!(g.props.trigger.indexOf("mouseenter") >= 0 && g.props.trigger.indexOf("click") >= 0 && ["mouseleave", "mousemove"].indexOf(T.type) >= 0 && i)) {
      var O = w(!1);
      O ? r = setTimeout(function() {
        g.state.isVisible && g.hide();
      }, O) : a = requestAnimationFrame(function() {
        g.hide();
      });
    }
  }
  function tt() {
    g.state.isEnabled = !0;
  }
  function It() {
    g.hide(), g.state.isEnabled = !1;
  }
  function _t() {
    clearTimeout(s), clearTimeout(r), cancelAnimationFrame(a);
  }
  function xt(T) {
    if (!g.state.isDestroyed) {
      G("onBeforeUpdate", [g, T]), yt();
      var O = g.props, B = Yn(t, Object.assign({}, O, Wn(T), {
        ignoreAttributes: !0
      }));
      g.props = B, He(), O.interactiveDebounce !== B.interactiveDebounce && (pe(), A = Fn(Et, B.interactiveDebounce)), O.triggerTarget && !B.triggerTarget ? Ke(O.triggerTarget).forEach(function(K) {
        K.removeAttribute("aria-expanded");
      }) : B.triggerTarget && t.removeAttribute("aria-expanded"), V(), R(), S && S(O, B), g.popperInstance && (Lt(), xe().forEach(function(K) {
        requestAnimationFrame(K._tippy.popperInstance.forceUpdate);
      })), G("onAfterUpdate", [g, T]);
    }
  }
  function Nt(T) {
    g.setProps({
      content: T
    });
  }
  function Ds() {
    var T = g.state.isVisible, O = g.state.isDestroyed, B = !g.state.isEnabled, K = Ae.isTouch && !g.props.touch, $ = qt(g.props.duration, 0, ge.duration);
    if (!(T || O || B || K) && !U().hasAttribute("disabled") && (G("onShow", [g], !1), g.props.onShow(g) !== !1)) {
      if (g.state.isVisible = !0, H() && (I.style.visibility = "visible"), R(), J(), g.state.isMounted || (I.style.transition = "none"), H()) {
        var Z = z(), re = Z.box, Ue = Z.content;
        Xt([re, Ue], 0);
      }
      m = function() {
        var Oe;
        if (!(!g.state.isVisible || p)) {
          if (p = !0, I.offsetHeight, I.style.transition = g.props.moveTransition, H() && g.props.animation) {
            var Ft = z(), St = Ft.box, $e = Ft.content;
            Xt([St, $e], $), zn([St, $e], "visible");
          }
          F(), V(), Kn(Zt, g), (Oe = g.popperInstance) == null || Oe.forceUpdate(), G("onMount", [g]), g.props.animation && H() && fe($, function() {
            g.state.isShown = !0, G("onShown", [g]);
          });
        }
      }, ve();
    }
  }
  function Ms() {
    var T = !g.state.isVisible, O = g.state.isDestroyed, B = !g.state.isEnabled, K = qt(g.props.duration, 1, ge.duration);
    if (!(T || O || B) && (G("onHide", [g], !1), g.props.onHide(g) !== !1)) {
      if (g.state.isVisible = !1, g.state.isShown = !1, p = !1, i = !1, H() && (I.style.visibility = "hidden"), pe(), ue(), R(!0), H()) {
        var $ = z(), Z = $.box, re = $.content;
        g.props.animation && (Xt([Z, re], K), zn([Z, re], "hidden"));
      }
      F(), V(), g.props.animation ? H() && me(K, g.unmount) : g.unmount();
    }
  }
  function Bs(T) {
    W().addEventListener("mousemove", A), Kn(Ct, A), A(T);
  }
  function Gs() {
    g.state.isVisible && g.hide(), g.state.isMounted && (Tt(), xe().forEach(function(T) {
      T._tippy.unmount();
    }), I.parentNode && I.parentNode.removeChild(I), Zt = Zt.filter(function(T) {
      return T !== g;
    }), g.state.isMounted = !1, G("onHidden", [g]));
  }
  function Hs() {
    g.state.isDestroyed || (g.clearDelayTimeouts(), g.unmount(), yt(), delete t._tippy, g.state.isDestroyed = !0, G("onDestroy", [g]));
  }
}
function Le(t, e) {
  e === void 0 && (e = {});
  var n = ge.plugins.concat(e.plugins || []);
  Ui();
  var s = Object.assign({}, e, {
    plugins: n
  }), r = Di(t), a = r.reduce(function(i, l) {
    var c = l && qi(l, s);
    return c && i.push(c), i;
  }, []);
  return Ut(t) ? a[0] : a;
}
Le.defaultProps = ge;
Le.setDefaultProps = Vi;
Le.currentInput = Ae;
Object.assign({}, ps, {
  effect: function(e) {
    var n = e.state, s = {
      popper: {
        position: n.options.strategy,
        left: "0",
        top: "0",
        margin: "0"
      },
      arrow: {
        position: "absolute"
      },
      reference: {}
    };
    Object.assign(n.elements.popper.style, s.popper), n.styles = s, n.elements.arrow && Object.assign(n.elements.arrow.style, s.arrow);
  }
});
Le.setDefaultProps({
  render: xs
});
const Ns = 'h1,h2,div,p,span,ol,ul,li,a,button,svg,strong,kbd,code{all:unset;box-sizing:border-box!important}div{display:block}:before,:after{all:unset}.tippy-box[data-animation=fade][data-state=hidden]{opacity:0}[data-tippy-root]{max-width:calc(100vw - 10px)}@media(forced-colors:active){[data-tippy-root]{border:2px solid #0000;border-radius:5px}}.tippy-arrow{color:#333;width:16px;height:16px}.tippy-arrow:before{content:"";border-style:solid;border-color:#0000;position:absolute}.tippy-box[data-placement^=top] .tippy-arrow{bottom:0}.tippy-box[data-placement^=top] .tippy-arrow:before{border-width:8px 8px 0;border-top-color:initial;transform-origin:top;bottom:-7px;left:0}.tippy-box[data-placement^=bottom] .tippy-arrow{top:0}.tippy-box[data-placement^=bottom] .tippy-arrow:before{border-width:0 8px 8px;border-bottom-color:initial;transform-origin:bottom;top:-7px;left:0}.tippy-box[data-placement^=left] .tippy-arrow{right:0}.tippy-box[data-placement^=left] .tippy-arrow:before{border-width:8px 0 8px 8px;border-left-color:initial;transform-origin:0;right:-7px}.tippy-box[data-placement^=right] .tippy-arrow{left:0}.tippy-box[data-placement^=right] .tippy-arrow:before{border-width:8px 8px 8px 0;border-right-color:initial;transform-origin:100%;left:-7px}.tippy-content{z-index:1;padding:5px 9px;position:relative}.tippy-box[data-theme~=sa11y-theme][role=tooltip]{box-sizing:border-box!important}.tippy-box[data-theme~=sa11y-theme][role=tooltip][data-animation=fade][data-state=hidden]{opacity:0}.tippy-box[data-theme~=sa11y-theme][role=tooltip][data-inertia][data-state=visible]{transition-timing-function:cubic-bezier(.54,1.5,.38,1.11)}[role=dialog]{text-align:start;word-wrap:break-word;min-width:300px}[role=tooltip]{text-align:center;min-width:185px}.tippy-box[data-theme~=sa11y-panel]{border:1px solid var(--sa11y-panel-bg-splitter);box-shadow:var(--sa11y-box-shadow)}.tippy-box[data-theme~=sa11y-theme]:not([data-theme~=sa11y-panel]){box-shadow:0 0 20px 4px #9aa1b126,0 4px 80px -8px #24282f40,0 4px 4px -2px #5b5e6926!important}.tippy-box[data-theme~=sa11y-theme]{font-family:var(--sa11y-font-face);font-size:var(--sa11y-normal-text);color:var(--sa11y-panel-primary);letter-spacing:normal;background-color:var(--sa11y-panel-bg);-webkit-font-smoothing:auto;border-radius:4px;outline:0;padding:8px;font-weight:400;line-height:22px;transition-property:transform,visibility,opacity;display:block;position:relative}.tippy-box[data-theme~=sa11y-theme] pre code{white-space:pre-wrap;display:block;overflow:auto}.tippy-box[data-theme~=sa11y-theme] code{font-family:monospace;font-size:calc(var(--sa11y-normal-text) - 1px);font-weight:500}.tippy-box[data-theme~=sa11y-theme] pre,.tippy-box[data-theme~=sa11y-theme] code,.tippy-box[data-theme~=sa11y-theme] kbd{color:var(--sa11y-panel-primary);letter-spacing:normal;background-color:var(--sa11y-panel-badge);-webkit-font-smoothing:auto;border-radius:3.2px;padding:1.6px 4.8px;line-height:22px}.tippy-box[data-theme~=sa11y-theme] .tippy-content{padding:5px 9px}.tippy-box[data-theme~=sa11y-theme] sub,.tippy-box[data-theme~=sa11y-theme] sup{font-size:var(--sa11y-small-text)}.tippy-box[data-theme~=sa11y-theme] ul{margin:0;margin-block:0;padding:0;position:relative}.tippy-box[data-theme~=sa11y-theme] li{margin:5px 10px 0 20px;padding-bottom:5px;display:list-item}.tippy-box[data-theme~=sa11y-theme] a{color:var(--sa11y-hyperlink);cursor:pointer;font-weight:500;text-decoration:underline}.tippy-box[data-theme~=sa11y-theme] a:hover,.tippy-box[data-theme~=sa11y-theme] a:focus{text-decoration:none}.tippy-box[data-theme~=sa11y-theme] strong{font-weight:600}.tippy-box[data-theme~=sa11y-theme] hr{background:var(--sa11y-panel-bg-splitter);opacity:1;border:none;height:1px;margin:10px 0;padding:0}.tippy-box[data-theme~=sa11y-theme] button.close-btn{margin-inline-start:10px;margin-bottom:10px}.tippy-box[data-theme~=sa11y-theme] button#suggest-size,.tippy-box[data-theme~=sa11y-theme] button#suggest{cursor:pointer;padding:.2rem;transition:background-color .2s,color .2s;position:relative}:is(.tippy-box[data-theme~=sa11y-theme] button#suggest-size,.tippy-box[data-theme~=sa11y-theme] button#suggest):after{content:"";position:absolute;inset:-10px -5px -14px}:is(.tippy-box[data-theme~=sa11y-theme] button#suggest-size,.tippy-box[data-theme~=sa11y-theme] button#suggest):hover,:is(.tippy-box[data-theme~=sa11y-theme] button#suggest-size,.tippy-box[data-theme~=sa11y-theme] button#suggest):focus-visible{color:#000!important;background-color:#fff!important}.tippy-box[data-theme~=sa11y-theme] .dismiss-group{margin-top:5px}.tippy-box[data-theme~=sa11y-theme] .dismiss-group button{margin:10px 5px 5px 0;color:var(--sa11y-panel-primary);cursor:pointer;background:var(--sa11y-panel-bg-secondary);border:2px solid var(--sa11y-button-outline);border-radius:5px;margin-inline-end:15px;padding:4px 8px;display:inline-block}.tippy-box[data-theme~=sa11y-theme] .dismiss-group button:hover,.tippy-box[data-theme~=sa11y-theme] .dismiss-group button:focus{background:var(--sa11y-shortcut-hover)}.tippy-box[data-theme~=sa11y-theme] .good-icon{background:var(--sa11y-good-text);width:14px;height:14px;-webkit-mask:var(--sa11y-good-svg)center no-repeat;mask:var(--sa11y-good-svg)center no-repeat;margin-bottom:-2.5px;display:inline-block}.tippy-box[data-theme~=sa11y-theme] .link-icon{background:var(--sa11y-panel-primary);width:16px;height:16px;-webkit-mask:var(--sa11y-link-icon-svg)center no-repeat;mask:var(--sa11y-link-icon-svg)center no-repeat;margin-bottom:-3.5px;display:inline-block}.tippy-box[data-theme~=sa11y-theme] .error .badge{color:var(--sa11y-error-text);background:var(--sa11y-error)}.tippy-box[data-theme~=sa11y-theme] .error .colour{color:var(--sa11y-red-text)}.tippy-box[data-theme~=sa11y-theme] .error .link-icon{background:var(--sa11y-error-text)}.tippy-box[data-theme~=sa11y-theme] .warning .badge{color:var(--sa11y-panel-bg);background:var(--sa11y-yellow-text)}.tippy-box[data-theme~=sa11y-theme] .warning .colour{color:var(--sa11y-yellow-text)}.tippy-box[data-theme~=sa11y-theme] .warning .link-icon{background:var(--sa11y-panel-bg)}.tippy-box[data-theme~=sa11y-theme][data-placement^=top] .tippy-arrow:before{border-top-color:var(--sa11y-panel-bg)}.tippy-box[data-theme~=sa11y-theme][data-placement^=bottom] .tippy-arrow:before{border-bottom-color:var(--sa11y-panel-bg)}.tippy-box[data-theme~=sa11y-theme][data-placement^=left] .tippy-arrow:before{border-left-color:var(--sa11y-panel-bg)}.tippy-box[data-theme~=sa11y-theme][data-placement^=right] .tippy-arrow:before{border-right-color:var(--sa11y-panel-bg)}@media(forced-colors:active){.tippy-box[data-theme~=sa11y-theme][data-placement^=top] .tippy-arrow:before,.tippy-box[data-theme~=sa11y-theme][data-placement^=bottom] .tippy-arrow:before,.tippy-box[data-theme~=sa11y-theme][data-placement^=left] .tippy-arrow:before,.tippy-box[data-theme~=sa11y-theme][data-placement^=right] .tippy-arrow:before{forced-color-adjust:none}.tippy-box[data-theme~=sa11y-theme] .tippy-arrow{z-index:-1}}.tippy-box[data-theme~=sa11y-theme] a:focus,.tippy-box[data-theme~=sa11y-theme] input:focus,.tippy-box[data-theme~=sa11y-theme] button:focus,.tippy-box[data-theme~=sa11y-theme] button:active,.tippy-box[data-theme~=sa11y-theme] [tabindex="-1"]:focus{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}.tippy-box[data-theme~=sa11y-theme] input:focus:not(:focus-visible),.tippy-box[data-theme~=sa11y-theme] a:focus:not(:focus-visible),.tippy-box[data-theme~=sa11y-theme] button:focus:not(:focus-visible),.tippy-box[data-theme~=sa11y-theme] [tabindex="-1"]:focus:not(:focus-visible){box-shadow:none;outline:0}.tippy-box[data-theme~=sa11y-theme] a:focus-visible,.tippy-box[data-theme~=sa11y-theme] button:focus-visible,.tippy-box[data-theme~=sa11y-theme] input:focus-visible,.tippy-box[data-theme~=sa11y-theme] [tabindex="-1"]:focus-visible{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}@media screen and (forced-colors:active){.tippy-box[data-theme~=sa11y-theme] .error-icon,.tippy-box[data-theme~=sa11y-theme] .link-icon,.tippy-box[data-theme~=sa11y-theme] .hidden-icon{filter:invert()}.tippy-box[data-theme~=sa11y-theme] a:focus,.tippy-box[data-theme~=sa11y-theme] button:focus,.tippy-box[data-theme~=sa11y-theme] [tabindex="-1"]:focus{outline:3px solid #0000!important}}';
const Q = {
  mainTRC: 2.4,
  sRco: 0.2126729,
  sGco: 0.7151522,
  sBco: 0.072175,
  normBG: 0.56,
  normTXT: 0.57,
  revTXT: 0.62,
  revBG: 0.65,
  blkThrs: 0.022,
  blkClmp: 1.414,
  scaleBoW: 1.14,
  scaleWoB: 1.14,
  loBoWoffset: 0.027,
  loWoBoffset: 0.027,
  deltaYmin: 5e-4,
  loClip: 0.1
};
function Ss(t, e, n = -1) {
  const s = [0, 1.1];
  if (isNaN(t) || isNaN(e) || Math.min(t, e) < s[0] || Math.max(t, e) > s[1])
    return 0;
  let r = 0, a = 0, i = "BoW";
  return t = t > Q.blkThrs ? t : t + Math.pow(Q.blkThrs - t, Q.blkClmp), e = e > Q.blkThrs ? e : e + Math.pow(Q.blkThrs - e, Q.blkClmp), Math.abs(e - t) < Q.deltaYmin ? 0 : (e > t ? (r = (Math.pow(e, Q.normBG) - Math.pow(t, Q.normTXT)) * Q.scaleBoW, a = r < Q.loClip ? 0 : r - Q.loBoWoffset) : (i = "WoB", r = (Math.pow(e, Q.revBG) - Math.pow(t, Q.revTXT)) * Q.scaleWoB, a = r > -0.1 ? 0 : r + Q.loWoBoffset), n < 0 ? a * 100 : n == 0 ? Math.round(Math.abs(a) * 100) + "<sub>" + i + "</sub>" : Number.isInteger(n) ? (a * 100).toFixed(n) : 0);
}
function $t(t, e = 2) {
  const n = [
    ["Lc", 100, 200, 300, 400, 500, 600, 700, 800, 900],
    [0, 999, 999, 999, 999, 999, 999, 999, 999, 999],
    [10, 999, 999, 999, 999, 999, 999, 999, 999, 999],
    [15, 777, 777, 777, 777, 777, 777, 777, 777, 777],
    [20, 777, 777, 777, 777, 777, 777, 777, 777, 777],
    [25, 777, 777, 777, 120, 120, 108, 96, 96, 96],
    [30, 777, 777, 120, 108, 108, 96, 72, 72, 72],
    [35, 777, 120, 108, 96, 72, 60, 48, 48, 48],
    [40, 120, 108, 96, 60, 48, 42, 32, 32, 32],
    [45, 108, 96, 72, 42, 32, 28, 24, 24, 24],
    [50, 96, 72, 60, 32, 28, 24, 21, 21, 21],
    [55, 80, 60, 48, 28, 24, 21, 18, 18, 18],
    [60, 72, 48, 42, 24, 21, 18, 16, 16, 18],
    [65, 68, 46, 32, 21.75, 19, 17, 15, 16, 18],
    [70, 64, 44, 28, 19.5, 18, 16, 14.5, 16, 18],
    [75, 60, 42, 24, 18, 16, 15, 14, 16, 18],
    [80, 56, 38.25, 23, 17.25, 15.81, 14.81, 14, 16, 18],
    [85, 52, 34.5, 22, 16.5, 15.625, 14.625, 14, 16, 18],
    [90, 48, 32, 21, 16, 15.5, 14.5, 14, 16, 18],
    [95, 45, 28, 19.5, 15.5, 15, 14, 13.5, 16, 18],
    [100, 42, 26.5, 18.5, 15, 14.5, 13.5, 13, 16, 18],
    [105, 39, 25, 18, 14.5, 14, 13, 12, 16, 18],
    [110, 36, 24, 18, 14, 13, 12, 11, 16, 18],
    [115, 34.5, 22.5, 17.25, 12.5, 11.875, 11.25, 10.625, 14.5, 16.5],
    [120, 33, 21, 16.5, 11, 10.75, 10.5, 10.25, 13, 15],
    [125, 32, 20, 16, 10, 10, 10, 10, 12, 14]
  ], s = [
    ["∆Lc", 100, 200, 300, 400, 500, 600, 700, 800, 900],
    [0, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [10, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [15, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [20, 0, 0, 0, 0, 0, 0, 0, 0, 0],
    [25, 0, 0, 0, 12, 12, 12, 24, 24, 24],
    [30, 0, 0, 12, 12, 36, 36, 24, 24, 24],
    [35, 0, 12, 12, 36, 24, 18, 16, 16, 16],
    [40, 12, 12, 24, 18, 16, 14, 8, 8, 8],
    [45, 12, 24, 12, 10, 4, 4, 3, 3, 3],
    [50, 16, 12, 12, 4, 4, 3, 3, 3, 3],
    [55, 8, 12, 6, 4, 3, 3, 2, 2, 0],
    [60, 4, 2, 10, 2.25, 2, 1, 1, 0, 0],
    [65, 4, 2, 4, 2.25, 1, 1, 0.5, 0, 0],
    [70, 4, 2, 4, 1.5, 2, 1, 0.5, 0, 0],
    [75, 4, 3.75, 1, 0.75, 0.188, 0.188, 0, 0, 0],
    [80, 4, 3.75, 1, 0.75, 0.188, 0.188, 0, 0, 0],
    [85, 4, 2.5, 1, 0.5, 0.125, 0.125, 0, 0, 0],
    [90, 3, 4, 1.5, 0.5, 0.5, 0.5, 0.5, 0, 0],
    [95, 3, 1.5, 1, 0.5, 0.5, 0.5, 0.5, 0, 0],
    [100, 3, 1.5, 0.5, 0.5, 0.5, 0.5, 1, 0, 0],
    [105, 3, 1, 0, 0.5, 1, 1, 1, 0, 0],
    [110, 1.5, 1.5, 0.75, 1.5, 1.125, 0.75, 0.375, 1.5, 1.5],
    [115, 1.5, 1.5, 0.75, 1.5, 1.125, 0.75, 0.375, 1.5, 1.5],
    [120, 1, 1, 0.5, 1, 0.75, 0.5, 0.25, 1, 1],
    [125, 0, 0, 0, 0, 0, 0, 0, 0, 0]
  ], a = [0, 100, 200, 300, 400, 500, 600, 700, 800, 900].length;
  let i = [t.toFixed(e), 0, 0, 0, 0, 0, 0, 0, 0, 0];
  i.length;
  let l = 777;
  t = Math.abs(t);
  const c = 0.2, p = t == 0 ? 1 : t * c | 0;
  let o = 0, d = (t - n[p][o]) * c;
  for (o++; o < a; o++)
    l = n[p][o], l > 400 ? i[o] = l : t < 14.5 ? i[o] = 999 : t < 29.5 ? i[o] = 777 : l > 24 ? i[o] = Math.round(l - s[p][o] * d) : i[o] = l - (2 * s[p][o] * d | 0) * 0.5;
  return i;
}
function ut(t = [0, 0, 0]) {
  function e(n) {
    return Math.pow(n / 255, Q.mainTRC);
  }
  return Q.sRco * e(t[0]) + Q.sGco * e(t[1]) + Q.sBco * e(t[2]);
}
function vn(t = [0, 0, 0, 1], e = [0, 0, 0], n = !0) {
  t[3] = Math.max(Math.min(t[3], 1), 0);
  let s = 1 - t[3], r = [0, 0, 0, 1, !0];
  for (let a = 0; a < 3; a++)
    r[a] = e[a] * s + t[a] * t[3], n && (r[a] = Math.min(Math.round(r[a]), 255));
  return r;
}
function Xn(t) {
  const e = parseInt(t, 10);
  return Number.isNaN(e) ? {
    lighter: 100,
    normal: 400,
    bold: 700,
    bolder: 900
  }[t] || 400 : e;
}
function he(t, e) {
  const n = t;
  let s, r, a, i = 1;
  if (n.startsWith("rgb")) {
    const l = n.match(/[\d.]+/g).map(Number);
    [s, r, a, i] = l.length === 4 ? l : [...l, 1];
  } else {
    if (n.startsWith("color(rec2020") || n.startsWith("color(display-p3") || n.startsWith("url("))
      return "unsupported";
    const c = document.createElement("canvas").getContext("2d");
    c.fillStyle = n, c.fillRect(0, 0, 1, 1), [s, r, a, i] = c.getImageData(0, 0, 1, 1).data, i = (i / 255).toFixed(2);
  }
  return e && e < 1 && (i = (i * e).toFixed(2)), [s, r, a, Number(i)];
}
function Rt(t, e) {
  let n = t;
  for (; n && n.nodeType === 1; ) {
    if (e) {
      const i = n.getRootNode();
      if (i instanceof ShadowRoot) {
        let l = n;
        for (; l && l !== i.host; ) {
          const c = getComputedStyle(l);
          if (c.backgroundImage && c.backgroundImage !== "none")
            return { type: "image", value: c.backgroundImage };
          const p = he(c.backgroundColor);
          if (p[3] !== 0 && p !== "transparent")
            return p;
          l = l.parentElement;
        }
        return Rt(i.host);
      }
    }
    const s = getComputedStyle(n), r = s.backgroundImage;
    if (r !== "none")
      return { type: "image", value: r };
    const a = he(s.backgroundColor);
    if (a[3] !== 0 && a !== "transparent") {
      if (a[3] < 1) {
        let i = n.parentElement, l = "rgba(255, 255, 255, 1)";
        for (; i && i.nodeType === 1 && (l = getComputedStyle(i).backgroundColor, l === "rgba(0, 0, 0, 0)"); )
          l === "rgba(0, 0, 0, 0)" && i.tagName === "HTML" && (l = "rgba(255, 255, 255, 1)"), i = i.parentElement;
        const c = he(l || "rgba(255, 255, 255, 1)");
        return vn(a, c);
      }
      return a;
    }
    if (n.tagName === "HTML")
      return [255, 255, 255];
    n = n.parentNode;
  }
  return [255, 255, 255];
}
function lt(t) {
  const e = t.slice(0, 3).map((n) => {
    const s = n / 255;
    return s <= 0.03928 ? s / 12.92 : ((s + 0.055) / 1.055) ** 2.4;
  });
  return 0.2126 * e[0] + 0.7152 * e[1] + 0.0722 * e[2];
}
function Gt(t, e) {
  const n = vn(t, e).slice(0, 4), s = ut(n), r = ut(e);
  return { ratio: Ss(s, r), blendedColor: n };
}
function at(t, e) {
  const n = Math.max(t, e), s = Math.min(t, e);
  return (n + 0.05) / (s + 0.05);
}
function ks(t, e) {
  return t.map((n, s) => {
    if (s < 3) {
      const r = Math.ceil(n + (255 - n) * e);
      return r >= 255 ? 255 : r;
    }
    return n;
  });
}
function ws(t, e) {
  return t.map((n, s) => {
    if (s < 3) {
      const r = Math.floor(n * (1 - e));
      return r <= 0 ? 0 : r;
    }
    return n;
  });
}
function ee(t) {
  const [e, n, s] = t.map((l) => Math.min(255, Math.max(0, l))), r = e.toString(16).padStart(2, "0"), a = n.toString(16).padStart(2, "0"), i = s.toString(16).padStart(2, "0");
  return `#${r}${a}${i}`;
}
function Ln(t) {
  return Math.abs(Number(t.toFixed(1)));
}
function Tn(t) {
  const e = Math.trunc(t * 10) / 10;
  return `${Number.isInteger(e) ? e.toFixed(0) : e}:1`;
}
function Xi(t, e) {
  return e === "APCA" ? Ln(t) : Tn(t);
}
function ft(t, e, n) {
  let s;
  const r = vn(t, e).slice(0, 4);
  if (n === "APCA") {
    const a = ut(r), i = ut(e);
    s = Ss(a, i);
  } else {
    const a = lt(r), i = lt(e);
    s = at(a, i);
  }
  return { ratio: s, blendedColor: r };
}
function Ji(t, e, n, s) {
  let r;
  s === "AAA" ? r = n ? 4.5 : 7 : r = n ? 3 : 4.5;
  const a = lt(t), i = lt(e), l = a > i ? at(1, i) > r : at(0, i) < r, c = (L, g, _) => _ ? ks(L, g) : ws(L, g);
  let p = t, o = p, d = at(a, i), m = d, h = t, A = 0.16;
  const E = 0.5, y = 0.01;
  let b = 0;
  const v = 100;
  for (; A >= y; ) {
    if (b += 1, b > v)
      return { color: null };
    p = c(p, A, l);
    const L = lt(p);
    d = at(L, i), d >= r && (o = d <= m ? p : o, m = d, p = h, A *= E), h = p;
  }
  return { color: ee(o) };
}
const Zi = (t, e) => {
  const n = Gt(t, [0, 0, 0, 1]), s = Gt(t, [255, 255, 255, 1]), r = Math.abs(n.ratio) > Math.abs(s.ratio), a = r ? [0, 0, 0, 1] : [255, 255, 255, 1], i = r ? n.ratio : s.ratio, l = $t(i).slice(1), c = Math.ceil(l[Math.floor(e / 100) - 1]);
  return { suggestedColor: a, size: c };
};
function er(t, e, n, s) {
  const a = n == null || s == null, i = ut(e), l = (C, k) => i <= 0.179 ? ks(C, k) : ws(C, k);
  let c = t, p = Gt(c, e), { ratio: o } = p, d = null, m = o, h = null, A, E, y;
  const b = () => (A = $t(o).slice(1), E = Math.min(
    Math.max(Math.floor(n / 100) - 1, 0),
    A.length - 1
  ), y = A[E], y <= s && y !== 999 && y !== 777), v = () => Math.abs(o) >= 45;
  if (a) {
    if (v())
      return { color: ee(t), size: null };
  } else {
    if (d = Zi(e, n), d.size > s)
      return {
        color: ee(d.suggestedColor),
        size: d.size
      };
    if (b())
      return { color: ee(t), size: null };
  }
  let L = t, g = 0.16;
  const _ = 0.5, I = 0.01;
  let S = 0;
  const x = 50;
  for (; g >= I && S < x; )
    S += 1, c = l(c, g), p = Gt(c, e), o = p.ratio, (a ? v() : b()) && ((Math.abs(o) <= Math.abs(m) || !h) && (h = c, m = o), c = L, g *= _), L = c;
  return h ? { color: ee(h), size: null } : !a && d ? {
    color: ee(d.suggestedColor),
    size: d.size
  } : { color: ee(t), size: null };
}
function tr(t, e, n, s, r, a, i) {
  const { ratio: l, blendedColor: c } = ft(e, n), p = s >= 24 || s >= 18.67 && r >= 700;
  let o;
  if (i === "AAA")
    o = p ? l < 4.5 : l < 7;
  else {
    const d = l > 1 && l < 4.5;
    o = p ? l < 3 : d;
  }
  return o ? {
    $el: t,
    ratio: Tn(l),
    color: c,
    background: n,
    fontSize: s,
    fontWeight: r,
    isLargeText: p,
    opacity: a,
    textUnderline: getComputedStyle(t).textDecorationLine
  } : null;
}
function nr(t, e, n, s, r, a, i) {
  const { ratio: l, blendedColor: c } = ft(e, n, i), p = $t(l).slice(1), o = Math.floor(r / 100) - 1, d = p[o];
  return s < d ? {
    $el: t,
    ratio: Ln(l),
    color: c,
    background: n,
    fontWeight: r,
    fontSize: s,
    opacity: a,
    textUnderline: getComputedStyle(t).textDecorationLine
  } : null;
}
function Jn(t, e, n, s, r, a, i) {
  return (i === "APCA" ? nr : tr)(t, e, n, s, r, a, i);
}
function sr(t) {
  const { sanitizedText: e, color: n, background: s, fontWeight: r, fontSize: a, ratio: i, textUnderline: l } = t, c = s && s.type !== "image", p = c ? ee(s) : "#000000", o = n ? ee(n) : "#000000", d = r ? `font-weight:${r};` : "", m = a ? `font-size:${a}px;` : "", h = l ? `text-decoration:${l};` : "", A = n ? "" : 'class="unknown"', E = s && s.type !== "image" ? "" : 'class="unknown"', y = n ? "" : `<span id="fg-input-unknown" class="visually-hidden">(${f._("UNKNOWN")})</span>`, b = s ? "" : `<span id="bg-input-unknown" class="visually-hidden">(${f._("UNKNOWN")})</span>`;
  let v;
  u.Global.contrastAlgorithm === "APCA" ? v = Math.abs(i) === 0 ? 0 : Math.abs(i) || f._("UNKNOWN") : v = i || f._("UNKNOWN");
  const L = document.createElement("div");
  return L.id = "contrast-tools", L.innerHTML = `
      <hr aria-hidden="true">
      <div id="contrast" class="badge">${f._("CONTRAST")}</div>
      <div id="value" class="badge">${v}</div>
      <div id="good" class="badge good-contrast" hidden>${f._("GOOD")} <span class="good-icon"></span></div>
      <div id="contrast-preview" style="color:${o};${c ? `background:${p};` : ""}${d + m + h}">${e}</div>
      <div id="color-pickers">
        <label for="fg-text">${f._("FG")} ${y}
          <div id="fg-color-wrapper" ${A}>
            <input type="color" id="fg-input" value="${o}" ${A}/>
          </div>
        </label>
        <label for="bg">${f._("BG")} ${b}
          <div id="bg-color-wrapper" ${E}>
            <input type="color" id="bg-input" value="${p}" ${E}/>
          </div>
        </label>
      </div>`, L;
}
function ar(t, e) {
  if (!t?.querySelector("#contrast-tools")) return;
  const { fontSize: s, fontWeight: r, type: a, isLargeText: i } = e, l = t.querySelector("#contrast"), c = t.querySelector("#contrast-preview"), p = t.querySelector("#fg-input"), o = t.querySelector("#bg-input"), d = t.querySelector("#value"), m = t.querySelector("#good"), h = (y, b) => {
    y.forEach((v) => {
      v.classList.toggle("good-contrast", b), v.classList.toggle("error-badge", !b);
    });
  }, A = () => {
    if (c.style.fontSize) {
      const b = c.style.fontSize.match(/([\d.]+)/);
      if (b) return parseFloat(b[1]);
    }
    const y = getComputedStyle(c).fontSize;
    if (y) {
      const b = y.match(/([\d.]+)/);
      if (b) return parseFloat(b[1]);
    }
    return s;
  }, E = (y) => {
    const b = p.value, v = o.value, L = A();
    if (setTimeout(() => {
      const S = p.classList.contains("unknown"), x = o.classList.contains("unknown");
      c.style.color = S ? "" : b, c.style.backgroundColor = x ? "" : v, c.style.backgroundImage = x ? "" : "none";
    }, 0), y?.target && (y.target.classList.remove("unknown"), y.target.parentElement.classList.remove("unknown"), t.querySelector(`#${y.target.id}-unknown`)?.remove()), p.classList.contains("unknown") || o.classList.contains("unknown")) return;
    const g = u.Global.contrastAlgorithm, _ = ft(
      he(b),
      he(v),
      u.Global.contrastAlgorithm
    ), I = [d, l];
    if (g === "APCA") {
      const S = _.ratio;
      d.textContent = Ln(S);
      const x = $t(S).slice(1), C = S >= 45 && x[0] >= 0 && x[0] <= 777;
      let k;
      switch (a) {
        case "svg-error":
        case "svg-warning": {
          m.hidden = !C, k = C, h(I, k);
          break;
        }
        default: {
          const D = x[Math.floor(r / 100) - 1];
          k = L >= D, h(I, k), m.hidden = !k;
          break;
        }
      }
    } else {
      const S = _.ratio;
      d.textContent = Tn(S);
      const x = g === "AAA", C = 3, k = x ? 7 : 4.5, D = x ? 4.5 : 3, H = S >= C, U = L >= 24 || L >= 18.66 && r >= 700 || i, W = S >= k, z = S >= D;
      switch (a) {
        case "svg-error":
        case "svg-text":
        case "svg-warning": {
          m.hidden = !H, h(I, H);
          break;
        }
        default: {
          U ? (h([d, l], z), m.hidden = !z) : (h([d, l], W), m.hidden = !W);
          break;
        }
      }
    }
  };
  p.addEventListener("input", E), o.addEventListener("input", E), setTimeout(() => {
    const y = (b, v) => {
      const L = t.querySelector(b);
      L && L.addEventListener("click", () => {
        v(L.textContent), E(), navigator.clipboard.writeText(L.textContent).catch(() => {
        });
      });
    };
    y("#suggest", (b) => {
      p.value = b;
    }), y("#suggest-size", (b) => {
      c.style.fontSize = b;
    });
  }, 0);
}
function ir(t) {
  let e;
  const { color: n, background: s, fontWeight: r, fontSize: a, isLargeText: i, type: l } = t;
  if (n && s && s.type !== "image" && (l === "text" || l === "svg-error" || l === "input")) {
    const c = u.Global.contrastAlgorithm === "APCA" ? er(n, s, r, a) : Ji(
      n,
      s,
      i,
      u.Global.contrastAlgorithm
    );
    let p;
    const o = '<hr aria-hidden="true">', d = ee(t.background), h = `<button id="suggest" class="badge" style="${`color:${c.color};background-color:${d};`}">${c.color}</button>`, A = `<button id="suggest-size" class="normal-badge">${c.size}px</button>`;
    u.Global.contrastAlgorithm === "AA" || u.Global.contrastAlgorithm === "AAA" ? c.color === null ? p = `${o} ${f._("NO_SUGGESTION")}` : p = `${o} ${f._("CONTRAST_COLOR")} ${h}` : c.color && c.size ? p = `${o} ${f._("CONTRAST_APCA")} ${h} ${A}` : c.color ? p = `${o} ${f._("CONTRAST_COLOR")} ${h}` : c.size && (p = `${o} ${f._("CONTRAST_SIZE")} ${A}`), e = document.createElement("div"), e.id = "advice";
    const E = t.opacity < 1 ? `<hr aria-hidden="true"> ${f.sprintf("CONTRAST_OPACITY")}` : p;
    e.innerHTML = E;
  }
  return e;
}
const rr = '.annotation{display:block;position:relative}.annotation-inline{text-align:end;display:inline-block;position:relative}button{cursor:pointer;border-radius:50%;width:36px;height:36px;padding:0;transition:all .2s ease-in-out;display:block;position:absolute;box-shadow:0 0 16px #0000004f}button:after{content:"";width:36px;height:36px;padding:7px;position:absolute;top:-7px;left:-7px}.error-btn{z-index:9999;background:50% 50% var(--sa11y-error-svg)no-repeat;background-color:var(--sa11y-error);border:1px solid var(--sa11y-error);background-size:22px}.error-btn:hover,.error-btn:focus{background-color:var(--sa11y-error-hover)}.good-btn{z-index:9977;background:50% 50% var(--sa11y-good)var(--sa11y-good-svg)no-repeat;background-color:var(--sa11y-good);border:1px solid var(--sa11y-good);background-size:20px}.good-btn:hover,.good-btn:focus{background-color:var(--sa11y-good-hover)}.warning-btn{z-index:9988;background:50% 50% var(--sa11y-warning)var(--sa11y-warning-svg)no-repeat;background-color:var(--sa11y-warning);border:1px solid var(--sa11y-warning);transform:scaleX(var(--sa11y-icon-direction));background-size:24px}.warning-btn:hover,.warning-btn:focus{background-color:var(--sa11y-warning-hover)}button:active,button:focus{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}@media screen and (forced-colors:active){button{forced-color-adjust:none;border:1px solid #0000!important;outline:3px solid #0000!important}}';
class or extends HTMLElement {
  connectedCallback() {
    if (this.shadowRoot)
      return;
    const e = this.attachShadow({ mode: "open" }), n = document.createElement("style");
    n.innerHTML = rr + mt, e.appendChild(n);
  }
}
const Cs = [];
function lr(t, e) {
  const {
    element: n,
    type: s,
    content: r,
    inline: a = !1,
    position: i = "beforebegin",
    id: l,
    dismiss: c,
    dismissAll: p,
    contrastDetails: o,
    margin: d
  } = t, m = ["error", "warning", "good"];
  if (!s && !n)
    return;
  if (m.indexOf(s) === -1)
    throw Error(`Invalid type [${s}] for annotation`);
  const h = {
    [m[0]]: f._("ERROR"),
    [m[1]]: f._("WARNING"),
    [m[2]]: f._("GOOD")
  }, A = e.dismissAnnotations && (s === "warning" || s === "good") && c ? `<button data-sa11y-dismiss='${l}' type='button'>${f._("DISMISS")}</button>` : "";
  if (n) {
    if (s === "good" && (!e.showGoodImageButton && n?.tagName === "IMG" || !e.showGoodLinkButton && n?.tagName === "A"))
      return;
    const E = {
      [m[0]]: "data-sa11y-error",
      [m[1]]: "data-sa11y-warning",
      [m[2]]: "data-sa11y-good"
    };
    [s].forEach((x) => {
      E[x] && n.setAttribute(E[x], "");
    });
    const y = document.createElement("sa11y-annotation");
    if (y.setAttribute("data-sa11y-annotation", l), os()) {
      y.style.position = "absolute", y.style.positionAnchor = `--sa11y-anchor-${l}`, y.style.top = "anchor(top)", y.style.left = "anchor(left)";
      const x = n.style.anchorName;
      n.style.anchorName = x ? `${x}, --sa11y-anchor-${l}` : `--sa11y-anchor-${l}`;
    }
    const b = e.dismissAnnotations && e.dismissAll && typeof p == "string" && (s === "warning" || s === "good") ? `<button data-sa11y-dismiss='${l}' data-sa11y-dismiss-all type='button'>${f._("DISMISS_ALL")}</button>` : "", v = document.createElement("div");
    v.classList.add(a ? "annotation-inline" : "annotation");
    const L = document.createElement("button");
    L.type = "button", L.className = `${s}-btn`, L.setAttribute("aria-label", h[s]), L.setAttribute("aria-haspopup", "dialog"), L.style.margin = `${a ? "-10px" : ""} ${d}`, L.dataset.tippyContent = `<div lang='${f._("LANG_CODE")}' class='${s}'><button type='button' class='close-btn close-tooltip' aria-label='${f._("ALERT_CLOSE")}'></button><h2>${h[s]}</h2> ${r} ${o ? "<div data-sa11y-contrast-details></div>" : ""} <div class='dismiss-group'>${A}${b}</div></div>`, v.appendChild(L), Cs.push(L);
    const g = e.insertAnnotationBefore ? `, ${e.insertAnnotationBefore}` : "";
    (n.closest(`a, button, [role="link"], [role="button"] ${g}`) || n).insertAdjacentElement(i, y), y.shadowRoot.appendChild(v);
    const I = e.ignoreHiddenOverflow ? e.ignoreHiddenOverflow.split(",").flatMap((x) => [...document.querySelectorAll(x)]) : [], S = ht(n, "overflow", "hidden");
    S && !I.includes(S) && S.setAttribute("data-sa11y-overflow", "");
  } else {
    const E = document.createElement("li");
    E.innerHTML = `<h3>${h[s]}</h3> ${r}${A}`, u.Panel.pageIssuesList.insertAdjacentElement("afterbegin", E), u.Panel.pageIssues.classList.add("active"), u.Panel.panel.classList.add("has-page-issues");
  }
}
class Zn extends HTMLElement {
  connectedCallback() {
    const e = this.attachShadow({ mode: "open" }), n = document.createElement("style");
    n.innerHTML = Ns + mt, e.appendChild(n);
    const s = Le(Cs, {
      interactive: !0,
      trigger: "mouseenter click",
      hideOnClick: !1,
      arrow: !0,
      offset: [0, 8],
      delay: [0, 400],
      maxWidth: 375,
      theme: "sa11y-theme",
      placement: "auto-start",
      allowHTML: !0,
      role: "dialog",
      aria: {
        content: null,
        expanded: "auto"
      },
      appendTo: e,
      zIndex: 2147483645,
      onShow(r) {
        s.forEach((m) => {
          m !== r.popper && m.hide();
        });
        const a = r.reference.getRootNode().host;
        a.setAttribute("data-sa11y-opened", "");
        const i = r.popper.querySelector(".close-btn"), l = () => {
          r.hide(), r.reference.focus();
        };
        i.addEventListener("click", l);
        const c = (m) => {
          m.key === "Escape" && (r.hide(), r.reference.focus());
        };
        if (r.popper.addEventListener("keydown", c), !r.popper.hasAttribute("contrast-tools-initialized")) {
          const m = parseInt(a.getAttribute("data-sa11y-annotation"), 10), h = window.sa11yCheckComplete.results.find(
            (E) => E.id === m
          ), { contrastDetails: A } = h || {};
          if (A) {
            const E = r.popper.querySelector("[data-sa11y-contrast-details]"), y = sr(A);
            E.appendChild(y), ar(r.popper, A);
            const b = ir(A);
            b && E.appendChild(b), r.popper.setAttribute("contrast-tools-initialized", !0);
          }
        }
        let p = !0;
        function o(m) {
          p && m.target.matches('input[type="color"]') && (r.reference.click(), p = !1, r.popper.removeEventListener("mousedown", o));
        }
        r.popper.addEventListener("mousedown", o);
        const d = () => {
          i.removeEventListener("click", l), r.popper.removeEventListener("keydown", c), r.popper.removeEventListener("hidden", d);
        };
        r.popper.addEventListener("hidden", d);
      },
      onTrigger(r, a) {
        a.type === "click" && setTimeout(() => {
          r.popper.querySelector(".close-btn").focus(), js(r.popper);
        }, 0);
      },
      onHide(r) {
        r.popper.querySelector(".close-btn").removeEventListener("click", () => {
          r.hide();
        }), r.reference.getRootNode().host.removeAttribute("data-sa11y-opened");
      }
    });
  }
}
class es extends HTMLElement {
  connectedCallback() {
    const e = (a) => ({
      allowHTML: !0,
      delay: [500, 0],
      trigger: "mouseenter focusin",
      arrow: !0,
      placement: "top",
      theme: "sa11y-theme sa11y-panel",
      role: "tooltip",
      aria: {
        content: null,
        expanded: null
      },
      appendTo: a,
      zIndex: 2147483645
    }), n = this.attachShadow({ mode: "open" }), s = document.createElement("style");
    s.innerHTML = Ns + mt, n.appendChild(s);
    const r = navigator.userAgent.indexOf("Mac") !== -1 ? '<span class="kbd">Option</span> + <span class="kbd">S</span>' : '<span class="kbd">Alt</span> + <span class="kbd">S</span>';
    if (Le(u.Panel.skipButton, {
      ...e(n),
      offset: [0, 8],
      maxWidth: 200,
      content: `${f._("SKIP_TO_ISSUE")} &raquo; <br> ${r}`
    }), this.object = Le(u.Panel.dismissButton, {
      offset: [0, 8],
      maxWidth: 200,
      ...e(n)
    }), u.Global.developerPlugin) {
      const a = u.Panel.developerItem?.querySelector(".info-icon");
      a && Le(a, {
        ...e(n),
        triggerTarget: [u.Panel.developerItem],
        offset: [0, 10],
        maxWidth: 250,
        content: f._("DEVELOPER_DESC")
      });
    }
    if (u.Global.readabilityPlugin) {
      const a = u.Panel.readabilityItem?.querySelector(".info-icon");
      a && Le(a, {
        ...e(n),
        triggerTarget: [u.Panel.readabilityItem],
        offset: [0, 10],
        maxWidth: 250,
        content: f._("READABILITY_DESC")
      });
    }
  }
}
class cr extends HTMLElement {
  connectedCallback() {
    this.attachShadow({ mode: "open" });
  }
}
class dr extends HTMLElement {
  connectedCallback() {
    const e = this.attachShadow({ mode: "open" }), n = document.createElement("style");
    n.textContent = `
      span.heading-label {
        background-color: #777678;
        background-image: linear-gradient(to bottom right, #b629ce, #16aec2);
        border-radius: 5px;
        border: 1px solid #36a5c3;
        color: white;
        display: inline-block;
        font-family: var(--sa11y-font-face);
        font-weight: 500;
        font-size: 18px;
        line-height: normal;
        letter-spacing: normal;
        margin: -5px 0 0 5px;
        padding: 3px;
        position: absolute;
        text-shadow: 1px 1px black;
        -webkit-text-fill-color: white;
        word-break: keep-all;
        z-index: 200;
      }
      @media screen and (forced-colors: active) {
        span.heading-label {
          border: 2px solid transparent;
        }
      }`, e.appendChild(n);
  }
}
const pr = () => {
  const e = document.querySelector("sa11y-tooltips").shadowRoot.querySelector("button");
  e !== null && e.click();
}, ur = (t) => {
  const e = t.getRootNode().host, n = ht(e, "display", "none");
  if (n !== null) {
    const s = n.previousElementSibling;
    Dt(s || n.parentNode);
  }
}, Os = (t, e) => {
  if (t.offsetTop === 0) {
    const s = t.getRootNode().host, r = ht(s, "display", "none"), a = parseInt(s.getAttribute("data-sa11y-annotation"), 10), i = e.find((p) => p.id === a), l = as(i);
    ur(t);
    const c = t.getAttribute("data-tippy-content");
    if (je(`${f._("NOT_VISIBLE")}`, c, l), pr(), r) {
      const p = r.previousElementSibling, { parentNode: o } = r;
      return p ? Vt(p).top - 150 : Vt(o).top - 150;
    }
  } else
    We(), u.Panel.skipButton.focus();
  return Vt(t).top - 150;
};
let oe = -1;
const Ps = () => {
  const t = P.getItem("sa11y-latest-dismissed");
  t !== null && (oe = parseInt(t, 10) - 1), P.removeItem("sa11y-latest-dismissed");
  const e = te("[data-sa11y-opened]", "root");
  e[0] && (oe = parseInt(e[0].getAttribute("data-sa11y-position"), 10));
}, Rs = (t) => {
  Ps();
  const e = M.Annotations.Array;
  oe >= e.length - 1 && (oe = -1);
  const s = e[oe + 1].shadowRoot.querySelector("button"), r = Os(s, t);
  window.scrollTo({
    top: r,
    behavior: `${u.Global.scrollBehaviour}`
  }), s.offsetTop !== 0 && (s.focus(), s.click()), oe += 1;
}, fr = (t) => {
  Ps();
  const e = M.Annotations.Array;
  oe <= 0 && (oe = e.length);
  const n = M.Annotations.Array[oe - 1].shadowRoot.querySelector("button"), s = Os(n, t);
  window.scrollTo({
    top: s,
    behavior: `${u.Global.scrollBehaviour}`
  }), n.offsetTop !== 0 && (n.focus(), n.click()), oe -= 1, oe === -1 && (oe = M.Annotations.Array.length - 1);
};
function hr(t, e) {
  M.Annotations.Array.length && !u.Panel.skipButton.hasAttribute("disabled") && (t.altKey && (t.code === "KeyS" || t.code === "Period") ? (t.preventDefault(), Rs(e)) : t.altKey && (t.code === "KeyW" || t.code === "Comma") && (t.preventDefault(), fr(e)));
}
let cn, dn;
function gr(t) {
  cn = (e) => {
    hr(e, t);
  }, dn = () => {
    Rs(t);
  }, document.addEventListener("keydown", cn), u.Panel.skipButton.addEventListener("click", dn);
}
function mr() {
  document.removeEventListener("keydown", cn), u.Panel.skipButton.removeEventListener("click", dn);
}
const Ar = [
  ".avif",
  ".png",
  ".jpg",
  ".jpeg",
  ".webp",
  ".gif",
  ".tiff",
  ".svg",
  ".heif",
  ".heic",
  "http"
];
function br(t, e) {
  const n = e.susAltStopWords ? e.susAltStopWords.split(",").map((c) => c.trim().toLowerCase()).filter(Boolean) : f._("SUS_ALT_STOPWORDS"), s = new Set(f._("PLACEHOLDER_ALT_STOPWORDS")), r = Re(e.altPlaceholder, !0), a = Re(e.linkIgnoreStrings), i = e.extraPlaceholderStopWords.split(",").map((c) => c.trim().toLowerCase()).filter(Boolean), l = (c) => {
    const p = c.toLowerCase(), o = p.replace(/\d+/g, "").trim(), d = [null, null, null];
    for (const m of Ar)
      if (p.includes(m)) {
        d[0] = m;
        break;
      }
    if (!d[0]) {
      const m = p.match(/\b\d{2,6}\s*x\s*\d{2,6}\b/);
      m && (d[0] = m[0]);
    }
    for (const m of n) {
      const h = p.indexOf(m);
      if (h > -1 && h < 6) {
        d[1] = m;
        break;
      }
    }
    if ((s.has(p) || s.has(o)) && (d[2] = c), i.length)
      for (const m of i) {
        const h = p.indexOf(m);
        if (h > -1 && h < 6) {
          d[2] = m;
          break;
        }
      }
    return d;
  };
  return M.Found.Images.forEach((c) => {
    const p = ke(c) === "noAria" ? c.getAttribute("alt") : ke(c), o = c?.getAttribute("aria-hidden") === "true", d = c?.getAttribute("role") === "presentation";
    if (c.height < 2 && c.width < 2 && (Me(c) || p === ""))
      return;
    const m = c.closest(
      e.imageWithinLightbox ? `a[href]:not(${e.imageWithinLightbox})` : "a[href]"
    ), h = c.getAttribute("src") ? c.getAttribute("src") : c.getAttribute("srcset"), A = m ? qe(m, u.Exclusions.LinkSpan).textContent.replace(
      a,
      ""
    ) : "", E = be(A).length;
    if (m && m.getAttribute("aria-hidden") === "true") {
      const w = m.getAttribute("tabindex") === "-1";
      e.checks.HIDDEN_FOCUSABLE && !w && t.push({
        test: "HIDDEN_FOCUSABLE",
        element: c,
        type: e.checks.HIDDEN_FOCUSABLE.type || "error",
        content: f.sprintf(e.checks.HIDDEN_FOCUSABLE.content || "HIDDEN_FOCUSABLE"),
        dismiss: N(`IMGHIDDENFOCUSABLE${h}`),
        dismissAll: e.checks.HIDDEN_FOCUSABLE.dismissAll ? "LINK_HIDDEN_FOCUSABLE" : !1,
        developer: e.checks.HIDDEN_FOCUSABLE.developer || !0
      });
      return;
    }
    if (p === null) {
      if (m) {
        if (!(E > 0 && (o || d))) {
          const R = E === 0 ? e.checks.MISSING_ALT_LINK : e.checks.MISSING_ALT_LINK_HAS_TEXT, G = E === 0 ? "MISSING_ALT_LINK" : "MISSING_ALT_LINK_HAS_TEXT";
          R && t.push({
            test: G,
            element: c,
            type: R.type || "error",
            content: f.sprintf(R.content || G),
            dismiss: N(`${G + h + E}`),
            dismissAll: R.dismissAll ? G : !1,
            developer: R.developer || !1
          });
        }
      } else e.checks.MISSING_ALT && t.push({
        test: "MISSING_ALT",
        element: c,
        type: e.checks.MISSING_ALT.type || "error",
        content: f.sprintf(e.checks.MISSING_ALT.content || "MISSING_ALT"),
        dismiss: N(`IMGNOALT${h}`),
        dismissAll: e.checks.MISSING_ALT.dismissAll ? "MISSING_ALT" : !1,
        developer: e.checks.MISSING_ALT.developer || !1
      });
      return;
    }
    const y = q(p), b = be(y), v = c.getAttribute("aria-label") || c.getAttribute("aria-labelledby");
    if (e.checks.MISSING_ALT && v && b === "") {
      t.push({
        test: "MISSING_ALT",
        element: c,
        type: e.checks.MISSING_ALT.type || "error",
        content: f.sprintf(e.checks.MISSING_ALT.content || "MISSING_ALT"),
        dismiss: N(`IMGNOALTARIA${h}`),
        dismissAll: e.checks.MISSING_ALT.dismissAll ? "MISSING_ALT" : !1,
        developer: e.checks.MISSING_ALT.developer || !1
      });
      return;
    }
    const L = p === "", g = c.closest("figure"), _ = g?.querySelector("figcaption"), I = _ ? j(_) : "", S = e.checks.LINK_IMAGE_LONG_ALT.maxLength || 250, x = e.checks.IMAGE_ALT_TOO_LONG.maxLength || 250, C = p.match(r)?.[0];
    if (L || C) {
      const w = e.checks.IMAGE_DECORATIVE_CAROUSEL.sources, R = w ? c.closest(w) : "";
      if (R) {
        const G = R.querySelectorAll("img"), F = G.length === 1 ? e.checks.IMAGE_DECORATIVE : e.checks.IMAGE_DECORATIVE_CAROUSEL, V = G.length === 1 ? "IMAGE_DECORATIVE" : "IMAGE_DECORATIVE_CAROUSEL";
        F && t.push({
          test: V,
          element: c,
          type: F.type || "warning",
          content: f.sprintf(F.content || V),
          dismiss: N(V + h),
          dismissAll: F.dismissAll ? V : !1,
          developer: F.developer || !1
        });
      } else if (m) {
        const G = E === 0 ? e.checks.LINK_IMAGE_NO_ALT_TEXT : e.checks.LINK_IMAGE_TEXT, F = E === 0 ? "LINK_IMAGE_NO_ALT_TEXT" : "LINK_IMAGE_TEXT";
        G && t.push({
          test: F,
          element: c,
          type: G.type || (E === 0 ? "error" : "good"),
          content: f.sprintf(G.content || F),
          dismiss: N(`${F + h + E}`),
          dismissAll: G.dismissAll ? F : !1,
          developer: G.developer || !1
        });
      } else if (g) {
        const G = _ && I.length ? e.checks.IMAGE_FIGURE_DECORATIVE : e.checks.IMAGE_DECORATIVE, F = _ && I.length ? "IMAGE_FIGURE_DECORATIVE" : "IMAGE_DECORATIVE";
        G && t.push({
          test: F,
          element: c,
          type: G.type || "warning",
          content: f.sprintf(G.content || F),
          dismiss: N(`${F + h + I}`),
          dismissAll: G.dismissAll ? F : !1,
          developer: G.developer || !1
        });
      } else e.checks.IMAGE_DECORATIVE && t.push({
        test: "IMAGE_DECORATIVE",
        element: c,
        type: e.checks.IMAGE_DECORATIVE.type || "warning",
        content: f.sprintf(e.checks.IMAGE_DECORATIVE.content || "IMAGE_DECORATIVE"),
        dismiss: N(`DECIMAGE${h}`),
        dismissAll: e.checks.IMAGE_DECORATIVE.dismissAll ? "IMAGE_DECORATIVE" : !1,
        developer: e.checks.IMAGE_DECORATIVE.developer || !1
      });
      return;
    }
    const k = m ? e.checks.LINK_ALT_UNPRONOUNCEABLE : e.checks.ALT_UNPRONOUNCEABLE;
    if (k && p.replace(/"|'|\?|\.|-|\s+/g, "") === "" && E === 0) {
      const w = m ? "LINK_ALT_UNPRONOUNCEABLE" : "ALT_UNPRONOUNCEABLE";
      t.push({
        test: w,
        element: c,
        type: k.type || "error",
        content: f.sprintf(k.content || w, b),
        dismiss: N(`UNPRONOUNCEABLE${h}`),
        dismissAll: k.dismissAll ? "ALT_UNPRONOUNCEABLE" : !1,
        developer: k.developer || !1
      });
      return;
    }
    const D = l(b), H = m ? e.checks.LINK_ALT_MAYBE_BAD : e.checks.ALT_MAYBE_BAD, U = new RegExp(`^\\S{${H.minLength || 15},}$`), W = /[^\p{L}\-,.!?]/u.test(p);
    if (D[0] !== null) {
      const w = m ? e.checks.LINK_ALT_FILE_EXT : e.checks.ALT_FILE_EXT, R = m ? "LINK_ALT_FILE_EXT" : "ALT_FILE_EXT";
      w && t.push({
        test: R,
        element: c,
        type: w.type || "error",
        content: f.sprintf(w.content || R, D[0], b),
        dismiss: N(`${R + h + b}`),
        dismissAll: w.dismissAll ? R : !1,
        developer: w.developer || !1
      });
    } else if (D[2] !== null) {
      const w = m ? e.checks.LINK_PLACEHOLDER_ALT : e.checks.ALT_PLACEHOLDER, R = m ? "LINK_PLACEHOLDER_ALT" : "ALT_PLACEHOLDER";
      w && t.push({
        test: R,
        element: c,
        type: w.type || "error",
        content: f.sprintf(w.content || R, b),
        dismiss: N(`${R + h + b}`),
        dismissAll: w.dismissAll ? R : !1,
        developer: w.developer || !1
      });
    } else if (D[1] !== null) {
      const w = m ? e.checks.LINK_SUS_ALT : e.checks.SUS_ALT, R = m ? "LINK_SUS_ALT" : "SUS_ALT";
      w && t.push({
        test: R,
        element: c,
        type: w.type || "warning",
        content: f.sprintf(w.content || R, D[1], b),
        dismiss: N(`${R + h + b}`),
        dismissAll: w.dismissAll ? R : !1,
        developer: w.developer || !1
      });
    } else if (H && U.test(p) && W) {
      const w = m ? "LINK_ALT_MAYBE_BAD" : "ALT_MAYBE_BAD";
      t.push({
        test: w,
        element: c,
        type: H.type || "error",
        content: f.sprintf(H.content || w, b),
        dismiss: N(`${w + h + b}`),
        dismissAll: H.dismissAll ? w : !1,
        developer: H.developer || !1
      });
    } else if (m ? p.length > S : p.length > x) {
      const w = m ? e.checks.LINK_IMAGE_LONG_ALT : e.checks.IMAGE_ALT_TOO_LONG, R = m ? "LINK_IMAGE_LONG_ALT" : "IMAGE_ALT_TOO_LONG", G = Se(b, 600);
      w && t.push({
        test: R,
        element: c,
        type: w.type || "warning",
        content: f.sprintf(w.content || R, p.length, G),
        dismiss: N(`${R + h + b}`),
        dismissAll: w.dismissAll ? R : !1,
        developer: w.developer || !1
      });
    } else if (m) {
      const w = E === 0 ? e.checks.LINK_IMAGE_ALT : e.checks.LINK_IMAGE_ALT_AND_TEXT, R = E === 0 ? "LINK_IMAGE_ALT" : "LINK_IMAGE_ALT_AND_TEXT";
      if (w) {
        const G = Te(m), F = be(G), V = q(F), pe = E === 0 ? f.sprintf("LINK_IMAGE_ALT", b) : `${f.sprintf("LINK_IMAGE_ALT_AND_TEXT", b, V)} ${f.sprintf("ACC_NAME_TIP")}`;
        t.push({
          test: R,
          element: c,
          type: w.type || "warning",
          content: w.content ? f.sprintf(w.content, b, V) : pe,
          dismiss: N(`${R + h + b}`),
          dismissAll: w.dismissAll ? R : !1,
          developer: w.developer || !1
        });
      }
    } else g ? !!_ && I.toLowerCase() === b.toLowerCase() ? e.checks.IMAGE_FIGURE_DUPLICATE_ALT && t.push({
      test: "IMAGE_FIGURE_DUPLICATE_ALT",
      element: c,
      type: e.checks.IMAGE_FIGURE_DUPLICATE_ALT.type || "warning",
      content: f.sprintf(
        e.checks.IMAGE_FIGURE_DUPLICATE_ALT.content || "IMAGE_FIGURE_DUPLICATE_ALT",
        b
      ),
      dismiss: N(`FIGDUPLICATE${h}`),
      dismissAll: e.checks.IMAGE_FIGURE_DUPLICATE_ALT.dismissAll ? "IMAGE_FIGURE_DUPLICATE_ALT" : !1,
      developer: e.checks.IMAGE_FIGURE_DUPLICATE_ALT.developer || !1
    }) : e.checks.IMAGE_PASS && t.push({
      test: "IMAGE_PASS",
      element: c,
      type: e.checks.IMAGE_PASS.type || "good",
      content: f.sprintf(e.checks.IMAGE_PASS.content || "IMAGE_PASS", b),
      dismiss: N(`FIGIMGPASS${h + b}`),
      dismissAll: e.checks.IMAGE_PASS.dismissAll ? "IMAGE_PASS" : !1,
      developer: e.checks.IMAGE_PASS.developer || !1
    }) : e.checks.IMAGE_PASS && (c.closest('button, [role="button"]') || t.push({
      test: "IMAGE_PASS",
      element: c,
      type: e.checks.IMAGE_PASS.type || "good",
      content: f.sprintf(e.checks.IMAGE_PASS.content || "IMAGE_PASS", b),
      dismiss: N(`IMAGEPASS${h + b}`),
      dismissAll: e.checks.IMAGE_PASS.dismissAll ? "IMAGE_PASS" : !1,
      developer: e.checks.IMAGE_PASS.developer || !1
    }));
    c.getAttribute("title")?.toLowerCase() === p.toLowerCase() && e.checks.DUPLICATE_TITLE && t.push({
      test: "DUPLICATE_TITLE",
      element: c,
      type: e.checks.DUPLICATE_TITLE.type || "warning",
      content: f.sprintf(e.checks.DUPLICATE_TITLE.content || "DUPLICATE_TITLE"),
      inline: !0,
      dismiss: N(`ALTDUPLICATETITLE${b}`),
      dismissAll: e.checks.DUPLICATE_TITLE.dismissAll ? "DUPLICATE_TITLE" : !1,
      developer: e.checks.DUPLICATE_TITLE.developer || !1
    });
  }), t;
}
function yr(t, e, n) {
  let s, r = "";
  const a = Re(e.headerIgnoreStrings);
  return M.Found.Headings.forEach((i, l) => {
    const p = Te(i, u.Exclusions.HeaderSpan).replace(a, ""), o = be(p), d = q(o), m = u.Root.areaToCheck.some((C) => C.contains(i)), h = u.Root.areaToCheck.some(
      (C) => C.contains(i.getRootNode().host)
    ), A = m || h, E = M.Found.HeadingOverrideStart.get(i);
    E && (s = E);
    const y = parseInt(i.getAttribute("aria-level") || i.tagName.slice(1), 10), b = o.length, v = e.checks.HEADING_LONG.maxLength || 160;
    let L = null, g = null, _ = null, I = null, S = null, x = null;
    if (b === 0) {
      const C = i.querySelector("img");
      if (C) {
        const k = C?.getAttribute("alt");
        C && (!k || k.trim() === "") && e.checks.HEADING_EMPTY_WITH_IMAGE && (L = "HEADING_EMPTY_WITH_IMAGE", g = e.checks.HEADING_EMPTY_WITH_IMAGE.type || "error", _ = f.sprintf(
          e.checks.HEADING_EMPTY_WITH_IMAGE.content || "HEADING_EMPTY_WITH_IMAGE",
          y
        ), I = e.checks.HEADING_EMPTY_WITH_IMAGE.developer || !1, S = e.checks.HEADING_EMPTY_WITH_IMAGE.dismissAll ? "HEADING_EMPTY_WITH_IMAGE" : !1, x = "-15px 30px");
      } else e.checks.HEADING_EMPTY && (L = "HEADING_EMPTY", g = e.checks.HEADING_EMPTY.type || "error", _ = f.sprintf(e.checks.HEADING_EMPTY.content || "HEADING_EMPTY", y), I = e.checks.HEADING_EMPTY.developer || !1, S = e.checks.HEADING_EMPTY.dismissAll ? "HEADING_EMPTY" : !1, x = "0");
    } else y - s > 1 && l !== 0 ? e.checks.HEADING_SKIPPED_LEVEL && (L = "HEADING_SKIPPED_LEVEL", g = e.checks.HEADING_SKIPPED_LEVEL.type || "error", _ = f.sprintf(
      e.checks.HEADING_SKIPPED_LEVEL.content || "HEADING_SKIPPED_LEVEL",
      s,
      y,
      Se(d, 60),
      Se(r, 60),
      s + 1
    ), I = e.checks.HEADING_SKIPPED_LEVEL.developer || !1, S = e.checks.HEADING_SKIPPED_LEVEL.dismissAll ? "HEADING_SKIPPED_LEVEL" : !1) : l === 0 && y !== 1 && y !== 2 ? e.checks.HEADING_FIRST && (L = "HEADING_FIRST", g = e.checks.HEADING_FIRST.type || "error", _ = f.sprintf(e.checks.HEADING_FIRST.content || "HEADING_FIRST"), I = e.checks.HEADING_FIRST.developer || !1, S = e.checks.HEADING_FIRST.dismissAll ? "HEADING_FIRST" : !1) : b > v && e.checks.HEADING_LONG && (L = "HEADING_LONG", g = e.checks.HEADING_LONG.type || "warning", _ = f.sprintf(
      e.checks.HEADING_LONG.content || "HEADING_LONG",
      v,
      b
    ), I = e.checks.HEADING_LONG.developer || !1, S = e.checks.HEADING_LONG.dismissAll ? "HEADING_LONG" : !1);
    _ && g && t.push({
      test: L,
      element: i,
      type: g,
      content: _,
      dismiss: N(`H${y + d}`),
      dismissAll: S,
      isWithinRoot: A,
      developer: I,
      margin: x
    }), s = y, r = d, M.Found.OutlineIgnore.includes(i) || n.push({
      element: i,
      headingLevel: y,
      text: d,
      type: g,
      dismiss: N(`H${y + d}`),
      isWithinRoot: A
    });
  }), e.checks.HEADING_MISSING_ONE && M.Found.HeadingOne.length === 0 && t.push({
    test: "HEADING_MISSING_ONE",
    type: e.checks.HEADING_MISSING_ONE.type || "warning",
    content: f.sprintf(e.checks.HEADING_MISSING_ONE.content || "HEADING_MISSING_ONE"),
    dismiss: "MISSINGH1",
    developer: e.checks.HEADING_MISSING_ONE.developer || !1
  }), { results: t, headingOutline: n };
}
const Er = [
  "pdf",
  "doc",
  "docx",
  "word",
  "mp3",
  "ppt",
  "text",
  "pptx",
  "txt",
  "exe",
  "dmg",
  "rtf",
  "windows",
  "macos",
  "csv",
  "xls",
  "xlsx",
  "mp4",
  "mov",
  "avi",
  "zip"
], vr = 'a[href$=".pdf"], a[href$=".doc"], a[href$=".docx"], a[href$=".zip"], a[href$=".mp3"], a[href$=".txt"], a[href$=".exe"], a[href$=".dmg"], a[href$=".rtf"], a[href$=".pptx"], a[href$=".ppt"], a[href$=".xls"], a[href$=".xlsx"], a[href$=".csv"], a[href$=".mp4"], a[href$=".mov"], a[href$=".avi"]', Lr = /(doi\.org\/|dl\.acm\.org\/|link\.springer\.com\/|pubmed\.ncbi\.nlm\.nih\.gov\/|scholar\.google\.com\/|ieeexplore\.ieee\.org\/|researchgate\.net\/publication\/|sciencedirect\.com\/science\/article\/)[a-z0-9/.-]+/i, Tr = /\b(?:\.edu\/|\.gob\/|\.gov\/|\.app\/|\.com\/|\.net\/|\.org\/|\.us\/|\.ca\/|\.de\/|\.icu\/|\.uk\/|\.ru\/|\.info\/|\.top\/|\.xyz\/|\.tk\/|\.cn\/|\.ga\/|\.cf\/|\.nl\/|\.io\/|\.fr\/|\.pe\/|\.nz\/|\.pt\/|\.es\/|\.pl\/|\.ua\/)\b/i, Ir = /[^a-zA-Z0-9]/g, _r = /([<>↣↳←→↓«»↴]+)/, en = (t, e, n) => {
  const s = t.replace(n, "").trim();
  return e.has(s) ? s : null;
};
function xr(t, e) {
  const n = e.linkStopWords ? e.linkStopWords.split(",").map((o) => o.toLowerCase().trim()) : [], s = /* @__PURE__ */ new Set([...f._("LINK_STOPWORDS"), ...n]), r = new Set(e.linkIgnoreStrings.map((o) => o.toLowerCase())), a = Re(f._("CLICK")), i = Re(f._("NEW_WINDOW_PHRASES")), l = Re(Er), c = Re(e.linkIgnoreStrings), p = {};
  return M.Found.Links.forEach((o) => {
    const d = Xs(o), m = o.getAttribute("title"), h = o.getAttribute("aria-hidden") === "true", A = o.getAttribute("tabindex") === "-1", E = o.getAttribute("target")?.toLowerCase() === "_blank", y = o.getAttribute("aria-label"), b = o.getAttribute("aria-labelledby"), v = b ? null : o.querySelector("[aria-labelledby]"), L = b || v, g = L || y || o.querySelector("[aria-label]"), _ = be(
      Te(o, u.Exclusions.LinkSpan)
    ), I = _.replace(c, ""), S = I.toLowerCase(), x = Wt(S), C = j(o).toLowerCase(), k = S.match(i)?.[0] || C.match(i)?.[0], D = S.match(l)?.[0] || C.match(l)?.[0], H = o.matches(vr);
    if (!o.querySelector("img")) {
      if (h) {
        A || e.checks.HIDDEN_FOCUSABLE && t.push({
          test: "HIDDEN_FOCUSABLE",
          element: o,
          type: e.checks.HIDDEN_FOCUSABLE.type || "error",
          content: f.sprintf(e.checks.HIDDEN_FOCUSABLE.content || "HIDDEN_FOCUSABLE"),
          inline: !0,
          position: "afterend",
          dismiss: N(`LINKHIDDENFOCUS${d + x}`),
          dismissAll: e.checks.HIDDEN_FOCUSABLE.dismissAll ? "LINK_HIDDEN_FOCUSABLE" : !1,
          developer: e.checks.HIDDEN_FOCUSABLE.developer || !0
        });
        return;
      }
      if (g && I.length !== 0) {
        const Y = q(I), X = qe(o, u.Exclusions.LinkSpan), J = j(X).replace(c, ""), ue = Wt(J), me = en(ue, s), fe = is(
          o,
          _,
          u.Exclusions.LinkSpan,
          e.linkIgnoreStrings
        );
        e.checks.LINK_STOPWORD_ARIA && me !== null ? t.push({
          test: "LINK_STOPWORD_ARIA",
          element: o,
          type: e.checks.LINK_STOPWORD_ARIA.type || "warning",
          content: e.checks.LINK_STOPWORD_ARIA.content ? f.sprintf(e.checks.LINK_STOPWORD_ARIA.content, me, Y) : f.sprintf("LINK_STOPWORD_ARIA", me, Y) + f.sprintf("LINK_TIP"),
          inline: !0,
          dismiss: N(`LINKSTOPWORDARIA${d + x}`),
          dismissAll: e.checks.LINK_STOPWORD_ARIA.dismissAll ? " LINK_STOPWORD_ARIA" : !1,
          developer: e.checks.LINK_STOPWORD_ARIA.developer || !0
        }) : e.checks.LABEL_IN_NAME && fe && C.length !== 0 ? t.push({
          test: "LABEL_IN_NAME",
          element: o,
          type: e.checks.LABEL_IN_NAME.type || "warning",
          content: f.sprintf(
            e.checks.LABEL_IN_NAME.content || "LABEL_IN_NAME",
            Y
          ),
          inline: !0,
          position: "afterend",
          dismiss: N(`LINKLABELNAME${d + x}`),
          dismissAll: e.checks.LABEL_IN_NAME.dismissAll ? "BTN_LABEL_IN_NAME" : !1,
          developer: e.checks.LABEL_IN_NAME.developer || !0
        }) : e.checks.LINK_LABEL && t.push({
          test: "LINK_LABEL",
          element: o,
          type: e.checks.LINK_LABEL.type || "good",
          content: e.checks.LINK_LABEL.content ? f.sprintf(e.checks.LINK_LABEL.content, Y) : `${f.sprintf("ACC_NAME", Y)} ${f.sprintf("ACC_NAME_TIP")}`,
          inline: !0,
          position: "afterend",
          dismiss: N(`LINKGOOD${d + x}`),
          dismissAll: e.checks.LINK_LABEL.dismissAll ? "LINK_LABEL" : !1,
          developer: e.checks.LINK_LABEL.developer || !0
        });
      }
      let U;
      const W = (Y, X) => {
        e.checks.LINK_STOPWORD && !U && (U = !0, t.push({
          test: "LINK_STOPWORD",
          element: Y,
          type: e.checks.LINK_STOPWORD.type || "error",
          content: e.checks.LINK_STOPWORD.content ? f.sprintf(e.checks.LINK_STOPWORD.content, X) : f.sprintf("LINK_STOPWORD", X) + f.sprintf("LINK_TIP"),
          inline: !0,
          position: "afterend",
          dismiss: N(`LINKSTOPWORD${d + x}`),
          dismissAll: e.checks.LINK_STOPWORD.dismissAll ? "LINK_STOPWORD" : !1,
          developer: e.checks.LINK_STOPWORD.developer || !1
        }));
      }, z = en(C, r);
      if (z === C || z === x)
        W(o, z);
      else if (k === C || k === x) {
        W(o, k);
        return;
      }
      if (I.length === 0) {
        if (L)
          e.checks.LINK_EMPTY_LABELLEDBY && t.push({
            test: "LINK_EMPTY_LABELLEDBY",
            element: o,
            type: e.checks.LINK_EMPTY_LABELLEDBY.type || "error",
            content: f.sprintf(
              e.checks.LINK_EMPTY_LABELLEDBY.content || "LINK_EMPTY_LABELLEDBY"
            ),
            inline: !0,
            position: "afterend",
            dismiss: N(`LINKEMPTYLABELLEDBY${d}`),
            dismissAll: e.checks.LINK_EMPTY_LABELLEDBY.dismissAll ? "LINK_EMPTY_LABELLEDBY" : !1,
            developer: e.checks.LINK_EMPTY_LABELLEDBY.developer || !0
          });
        else if (o.children.length) {
          let Y = !1;
          if (e.linkIgnoreSpan) {
            const X = o.querySelector(e.linkIgnoreSpan);
            if (X) {
              const J = Wt(X.textContent).trim().toLowerCase();
              J === C && (W(o, J), Y = !0);
            }
          }
          !Y && e.checks.LINK_EMPTY_NO_LABEL && t.push({
            test: "LINK_EMPTY_NO_LABEL",
            element: o,
            type: e.checks.LINK_EMPTY_NO_LABEL.type || "error",
            content: f.sprintf(
              e.checks.LINK_EMPTY_NO_LABEL.content || "LINK_EMPTY_NO_LABEL"
            ),
            inline: !0,
            position: "afterend",
            dismiss: N(`LINKEMPTYNOLABEL${d}`),
            dismissAll: e.checks.LINK_EMPTY_NO_LABEL.dismissAll ? "LINK_EMPTY_NO_LABEL" : !1,
            developer: e.checks.LINK_EMPTY_NO_LABEL.developer || !1
          });
        } else !z && e.checks.LINK_EMPTY && t.push({
          test: "LINK_EMPTY",
          element: o,
          type: e.checks.LINK_EMPTY.type || "error",
          content: f.sprintf(e.checks.LINK_EMPTY.content || "LINK_EMPTY"),
          inline: !0,
          position: "afterend",
          dismiss: N(`LINKEMPTY${d}`),
          dismissAll: e.checks.LINK_EMPTY.dismissAll ? "LINK_EMPTY" : !1,
          developer: e.checks.LINK_EMPTY.developer || !1
        });
        return;
      }
      const w = en(x, s, i), R = x.match(a)?.[0] || C.match(a)?.[0], G = S.match(Lr)?.[0], V = S.startsWith("www.") || S.startsWith("http") ? "URL Prefix" : S.match(Tr)?.[0], pe = I.length === 1 && Ir.test(I), ae = S.match(_r)?.[0];
      if (w)
        W(o, w);
      else if (G)
        I.length > 8 && e.checks.LINK_DOI && t.push({
          test: "LINK_DOI",
          element: o,
          type: e.checks.LINK_DOI.type || "warning",
          content: f.sprintf(e.checks.LINK_DOI.content || "LINK_DOI"),
          inline: !0,
          dismiss: N(`LINKDOI${d + x}`),
          dismissAll: e.checks.LINK_DOI.dismissAll ? "LINK_DOI" : !1,
          developer: e.checks.LINK_DOI.developer || !1
        });
      else if (V)
        !g && I.length > (e.checks.LINK_URL.maxLength || 40) && e.checks.LINK_URL && t.push({
          test: "LINK_URL",
          element: o,
          type: e.checks.LINK_URL.type || "warning",
          content: e.checks.LINK_URL.content ? f.sprintf(e.checks.LINK_URL.content) : f.sprintf("LINK_URL") + f.sprintf("LINK_TIP"),
          inline: !0,
          dismiss: N(`LINKURLNAME${d + x}`),
          dismissAll: e.checks.LINK_URL.dismissAll ? "LINK_URL" : !1,
          developer: e.checks.LINK_URL.developer || !1
        });
      else if (ae)
        e.checks.LINK_SYMBOLS && t.push({
          test: "LINK_SYMBOLS",
          element: o,
          type: e.checks.LINK_SYMBOLS.type || "warning",
          content: f.sprintf(
            e.checks.LINK_SYMBOLS.content || "LINK_SYMBOLS",
            ae
          ),
          inline: !0,
          dismiss: N(`LINKSYMBOL${d + x}`),
          dismissAll: e.checks.LINK_SYMBOLS.dismissAll ? "LINK_SYMBOLS" : !1,
          developer: e.checks.LINK_SYMBOLS.developer || !1
        });
      else if (pe && !m) {
        e.checks.LINK_EMPTY && t.push({
          test: "LINK_EMPTY",
          element: o,
          type: e.checks.LINK_EMPTY.type || "error",
          content: f.sprintf(e.checks.LINK_EMPTY.content || "LINK_EMPTY"),
          inline: !0,
          position: "afterend",
          dismiss: N(`LINKCHAR${d}`),
          dismissAll: e.checks.LINK_EMPTY.dismissAll ? "LINK_EMPTY" : !1,
          developer: e.checks.LINK_EMPTY.developer || !1
        });
        return;
      }
      R && e.checks.LINK_CLICK_HERE && t.push({
        test: "LINK_CLICK_HERE",
        element: o,
        type: e.checks.LINK_CLICK_HERE.type || "warning",
        content: e.checks.LINK_CLICK_HERE.content ? f.sprintf(e.checks.LINK_CLICK_HERE.content) : f.sprintf("LINK_CLICK_HERE") + f.sprintf("LINK_TIP"),
        inline: !0,
        dismiss: N(`LINKCLICKHERE${d + x}`),
        dismissAll: e.checks.LINK_CLICK_HERE.dismissAll ? "LINK_CLICK_HERE" : !1,
        developer: e.checks.LINK_CLICK_HERE.developer || !1
      }), C.length !== 0 && m?.toLowerCase() === I.toLowerCase() && e.checks.DUPLICATE_TITLE && t.push({
        test: "DUPLICATE_TITLE",
        element: o,
        type: e.checks.DUPLICATE_TITLE.type || "warning",
        content: f.sprintf(e.checks.DUPLICATE_TITLE.content || "DUPLICATE_TITLE"),
        inline: !0,
        dismiss: N(`LINKDUPLICATETITLE${d + x}`),
        dismissAll: e.checks.DUPLICATE_TITLE.dismissAll ? "DUPLICATE_TITLE" : !1,
        developer: e.checks.DUPLICATE_TITLE.developer || !1
      });
    }
    if (x.length !== 0) {
      if (p[x] && !p[d]) {
        const U = o.ariaHidden === "true" && o.getAttribute("tabindex") === "-1", W = o.hasAttribute("role") || o.hasAttribute("disabled");
        if (e.checks.LINK_IDENTICAL_NAME && !W && !U) {
          const z = q(I);
          t.push({
            test: "LINK_IDENTICAL_NAME",
            element: o,
            type: e.checks.LINK_IDENTICAL_NAME.type || "warning",
            content: e.checks.LINK_IDENTICAL_NAME.content ? f.sprintf(e.checks.LINK_IDENTICAL_NAME.content, z) : `${f.sprintf("LINK_IDENTICAL_NAME", z)} ${f.sprintf("ACC_NAME_TIP")}`,
            inline: !0,
            dismiss: N(`LINKSEEN${d + x}`),
            dismissAll: e.checks.LINK_IDENTICAL_NAME.dismissAll ? "LINK_IDENTICAL_NAME" : !1,
            developer: e.checks.LINK_IDENTICAL_NAME.developer || !1
          });
        }
      } else
        p[x] = !0, p[d] = !0;
      E && !H && !k && e.checks.LINK_NEW_TAB && t.push({
        test: "LINK_NEW_TAB",
        element: o,
        type: e.checks.LINK_NEW_TAB.type || "warning",
        content: f.sprintf(e.checks.LINK_NEW_TAB.content || "LINK_NEW_TAB"),
        inline: !0,
        dismiss: N(`LINKNEWTAB${d + x}`),
        dismissAll: e.checks.LINK_NEW_TAB.dismissAll ? "LINK_NEW_TAB" : !1,
        developer: e.checks.LINK_NEW_TAB.developer || !1
      }), H && !D && e.checks.LINK_FILE_EXT && t.push({
        test: "LINK_FILE_EXT",
        element: o,
        type: e.checks.LINK_FILE_EXT.type || "warning",
        content: f.sprintf(e.checks.LINK_FILE_EXT.content || "LINK_FILE_EXT"),
        inline: !0,
        dismiss: N(`LINKEXT${d + x}`),
        dismissAll: e.checks.LINK_FILE_EXT.dismissAll ? "LINK_FILE_EXT" : !1,
        developer: e.checks.LINK_FILE_EXT.developer || !1
      });
    }
  }), t;
}
function Nr(t, e) {
  const n = [];
  for (let a = 0; a < M.Found.Contrast.length; a++) {
    const i = M.Found.Contrast[a], l = getComputedStyle(i), c = parseFloat(l.opacity), p = he(l.color, c), o = parseFloat(l.fontSize), d = l.fontWeight, m = Xn(d), h = Rt(i, u.Global.shadowDetection), A = Ws(i), y = Me(i) || A || c === 0 || o === 0, v = Array.from(i.childNodes).filter((g) => g.nodeType === 3).map((g) => g.textContent).join("").trim(), L = ["SELECT", "INPUT", "TEXTAREA"].includes(i.tagName);
    if (v.length !== 0 || L) {
      const g = o >= 24 || o >= 18.67 && m >= 700;
      if (p === "unsupported" || h === "unsupported")
        n.push({
          $el: i,
          type: "unsupported",
          fontSize: o,
          fontWeight: m,
          isLargeText: g,
          opacity: c,
          ...h !== "unsupported" && { background: h },
          ...p !== "unsupported" && { color: p }
        });
      else if (h.type === "image")
        y || n.push({
          $el: i,
          type: "background-image",
          color: p,
          isLargeText: g,
          background: h,
          fontSize: o,
          fontWeight: m,
          opacity: c
        });
      else if (!y && ee(p) !== ee(h)) {
        const _ = Jn(
          i,
          p,
          h,
          o,
          m,
          c,
          e.contrastAlgorithm
        );
        _ && (_.type = L ? "input" : "text", n.push(_));
      }
    }
  }
  return M.Found.Svg.forEach((a) => {
    const i = { $el: a, type: "svg-warning" }, l = Rt(a, u.Global.shadowDetection), c = l !== "unsupported" && l.type !== "image", p = a.querySelectorAll("path, rect, circle, ellipse, polygon, text, use"), o = a.querySelectorAll(
      "*:not(path):not(rect):not(circle):not(ellipse):not(polygon):not(text):not(use):not(title)"
    );
    let d = !1;
    if (p.length) {
      const m = getComputedStyle(p[0]);
      d = Array.from(p).every((h) => {
        const A = getComputedStyle(h);
        return A.fill === m.fill && A.fillOpacity === m.fillOpacity && A.stroke === m.stroke && A.strokeOpacity === m.strokeOpacity && A.opacity === m.opacity;
      });
    }
    if ((p.length === 1 || d) && o.length === 0) {
      const m = getComputedStyle(p[0]), { fill: h, stroke: A, strokeWidth: E, opacity: y } = m;
      let b = 0;
      const { width: v, height: L } = a.getBBox();
      A && A !== "none" && (E.endsWith("%") ? b = parseFloat(E) / 100 * Math.min(v, L) : b = ["inherit", "initial", "unset"].includes(E) ? 1 : parseFloat(E));
      const g = Math.min(v, L) < 50 ? 1 : 3, _ = A && b >= g && A !== "none", I = h && h !== "none" && !h.startsWith("url("), S = he(h === "currentColor" ? getComputedStyle(p[0]).color : h, y), x = he(A === "currentColor" ? getComputedStyle(p[0]).color : A, y);
      if (![S, x].includes("unsupported") && c) {
        let k, D = !1, H = !1;
        if (I && (k = ft(
          S,
          l,
          e.contrastAlgorithm
        ), D = e.contrastAlgorithm === "APCA" ? k.ratio >= 45 : k.ratio >= 3), _ && (k = ft(
          x,
          l,
          e.contrastAlgorithm
        ), H = e.contrastAlgorithm === "APCA" ? k.ratio >= 45 : k.ratio >= 3), I && _ && !D && !H || I && !_ && !D || !I && _ && !H) {
          const w = ee(l), R = ee(S), G = ee(x);
          if (R === w && !_ || G === w && !I)
            return;
          n.push({
            $el: a,
            ratio: Xi(k.ratio, e.contrastAlgorithm),
            color: k.blendedColor,
            type: "svg-error",
            isLargeText: !0,
            // To push a suggested colour (3:1).
            background: l
          });
        }
      } else
        I && S !== "unsupported" ? i.color = S : _ && x !== "unsupported" && (i.color = x), c && (i.background = l), n.push(i);
    } else
      c && (i.background = l), n.push(i);
  }), M.Found.Inputs.forEach((a) => {
    if (a.placeholder && a.placeholder.length !== 0) {
      const i = getComputedStyle(a, "::placeholder"), l = he(i.getPropertyValue("color")), c = parseFloat(i.fontSize), p = Xn(i.fontWeight), o = Rt(a, u.Global.shadowDetection), d = parseFloat(i.opacity);
      if (l === "unsupported")
        n.push({ $el: a, type: "placeholder-unsupported" });
      else if (o.type !== "image") {
        const m = Jn(
          a,
          l,
          o,
          c,
          p,
          d,
          e.contrastAlgorithm
        );
        m && (m.type = "placeholder", n.push(m));
      }
    }
  }), ((a) => {
    const i = a.filter((p) => p.type === "background-image"), l = a.filter((p) => p.type !== "background-image");
    let c;
    if (e.contrastAlgorithm === "APCA")
      c = i.map((p) => ({ ...p }));
    else {
      const p = i.reduce((o, d) => {
        const m = o, h = JSON.stringify({
          background: d.background.value,
          color: d.color,
          isLargeText: d.isLargeText
        });
        return m[h] || (m[h] = []), m[h].push(d), m;
      }, {});
      c = Object.values(p).map((o) => ({
        ...o[0]
      }));
    }
    return [...c, ...l];
  })(n).forEach((a) => {
    const { $el: i, ratio: l } = a, c = a, p = i.tagName === "OPTION" ? i.closest("datalist, select, optgroup") : i, o = qe(p, ["option:not(option:first-child)"]), d = j(o), m = Se(d, 80), h = q(m);
    let A;
    a.type === "placeholder" || a.type === "placeholder-unsupported" ? A = q(i.placeholder) : a.type === "svg-error" || a.type === "svg-warning" ? A = "" : A = h, c.sanitizedText = A;
    let E = "";
    if (e.contrastAlgorithm === "AA" || e.contrastAlgorithm === "AAA") {
      const b = e.contrastAlgorithm === "AAA" ? "7:1" : "4.5:1", v = e.contrastAlgorithm === "AAA" ? "4.5:1" : "3:1", L = a.isLargeText ? v : b, g = a.isLargeText ? "CONTRAST_LARGE" : "CONTRAST_NORMAL";
      E = ` ${f.sprintf(g, L)}`;
    }
    const y = e.contrastAlgorithm === "APCA" ? "" : ` ${f.sprintf("CONTRAST_TIP_GRAPHIC")}`;
    switch (a.type) {
      case "text":
        e.checks.CONTRAST_ERROR && t.push({
          test: "CONTRAST_ERROR",
          element: i,
          type: e.checks.CONTRAST_ERROR.type || "error",
          content: e.checks.CONTRAST_ERROR.content ? f.sprintf(e.checks.CONTRAST_ERROR.content) : f.sprintf("CONTRAST_ERROR") + E,
          dismiss: N(`CONTRAST${h}`),
          dismissAll: e.checks.CONTRAST_ERROR.dismissAll ? "CONTRAST_ERROR" : !1,
          developer: e.checks.CONTRAST_ERROR.developer || !1,
          contrastDetails: c
        });
        break;
      case "input":
        if (e.checks.CONTRAST_INPUT) {
          const b = Ne(i.outerHTML);
          t.push({
            test: "CONTRAST_INPUT",
            element: p,
            type: e.checks.CONTRAST_INPUT.type || "error",
            content: e.checks.CONTRAST_INPUT.content ? f.sprintf(e.checks.CONTRAST_INPUT.content) : f.sprintf("CONTRAST_INPUT", l) + E,
            dismiss: N(`CONTRAST${b}`),
            dismissAll: e.checks.CONTRAST_INPUT.dismissAll ? "CONTRAST_INPUT" : !1,
            developer: e.checks.CONTRAST_INPUT.developer || !0,
            contrastDetails: c
          });
        }
        break;
      case "placeholder":
        if (e.checks.CONTRAST_PLACEHOLDER) {
          const b = Ne(i.outerHTML);
          t.push({
            test: "CONTRAST_PLACEHOLDER",
            element: i,
            type: e.checks.CONTRAST_PLACEHOLDER.type || "error",
            content: e.checks.CONTRAST_PLACEHOLDER.content ? f.sprintf(e.checks.CONTRAST_PLACEHOLDER.content) : f.sprintf("CONTRAST_PLACEHOLDER") + E,
            position: "afterend",
            dismiss: N(`CPLACEHOLDER${b}`),
            dismissAll: e.checks.CONTRAST_PLACEHOLDER.dismissAll ? "CONTRAST_PLACEHOLDER" : !1,
            developer: e.checks.CONTRAST_PLACEHOLDER.developer || !0,
            contrastDetails: c
          });
        }
        break;
      case "placeholder-unsupported":
        if (e.checks.CONTRAST_PLACEHOLDER_UNSUPPORTED) {
          const b = Ne(i.outerHTML);
          t.push({
            test: "CONTRAST_PLACEHOLDER_UNSUPPORTED",
            element: i,
            type: e.checks.CONTRAST_PLACEHOLDER_UNSUPPORTED.type || "warning",
            content: e.checks.CONTRAST_PLACEHOLDER_UNSUPPORTED.content ? f.sprintf(e.checks.CONTRAST_PLACEHOLDER_UNSUPPORTED.content) : f.sprintf("CONTRAST_PLACEHOLDER_UNSUPPORTED") + E,
            position: "afterend",
            dismiss: N(`CPLACEHOLDERUN${b}`),
            dismissAll: e.checks.CONTRAST_PLACEHOLDER_UNSUPPORTED.dismissAll ? "CONTRAST_PLACEHOLDER_UNSUPPORTED" : !1,
            developer: e.checks.CONTRAST_PLACEHOLDER_UNSUPPORTED.developer || !0,
            contrastDetails: c
          });
        }
        break;
      case "svg-error":
        if (e.checks.CONTRAST_ERROR_GRAPHIC) {
          const b = Ne(i.outerHTML);
          t.push({
            test: "CONTRAST_ERROR_GRAPHIC",
            element: i,
            type: e.checks.CONTRAST_ERROR_GRAPHIC.type || "error",
            content: e.checks.CONTRAST_ERROR_GRAPHIC.content ? f.sprintf(e.checks.CONTRAST_ERROR_GRAPHIC.content) : f.sprintf("CONTRAST_ERROR_GRAPHIC") + y,
            dismiss: N(`CONTRASTERROR${b}`),
            dismissAll: e.checks.CONTRAST_ERROR_GRAPHIC.dismissAll ? "CONTRAST_ERROR_GRAPHIC" : !1,
            developer: e.checks.CONTRAST_ERROR_GRAPHIC.developer || !0,
            contrastDetails: c,
            margin: "-25px"
          });
        }
        break;
      case "svg-warning":
        if (e.checks.CONTRAST_WARNING_GRAPHIC) {
          const b = Ne(i.outerHTML);
          t.push({
            test: "CONTRAST_WARNING_GRAPHIC",
            element: i,
            type: e.checks.CONTRAST_WARNING_GRAPHIC.type || "warning",
            content: e.checks.CONTRAST_WARNING_GRAPHIC.content ? f.sprintf(e.checks.CONTRAST_WARNING_GRAPHIC.content) : f.sprintf("CONTRAST_WARNING_GRAPHIC") + y,
            dismiss: N(`CONTRASTWARNING${b}`),
            dismissAll: e.checks.CONTRAST_WARNING_GRAPHIC.dismissAll ? "CONTRAST_WARNING_GRAPHIC" : !1,
            developer: e.checks.CONTRAST_WARNING_GRAPHIC.developer || !0,
            contrastDetails: c,
            margin: "-25px"
          });
        }
        break;
      case "background-image":
        e.checks.CONTRAST_WARNING && t.push({
          test: "CONTRAST_WARNING",
          element: p,
          type: e.checks.CONTRAST_WARNING.type || "warning",
          content: e.checks.CONTRAST_WARNING.content ? f.sprintf(e.checks.CONTRAST_WARNING.content) : f.sprintf("CONTRAST_WARNING") + E,
          dismiss: N(`CONTRAST${h}`),
          dismissAll: e.checks.CONTRAST_WARNING.dismissAll ? "CONTRAST_WARNING" : !1,
          developer: e.checks.CONTRAST_WARNING.developer || !1,
          contrastDetails: c
        });
        break;
      case "unsupported":
        e.checks.CONTRAST_UNSUPPORTED && t.push({
          test: "CONTRAST_UNSUPPORTED",
          element: p,
          type: e.checks.CONTRAST_UNSUPPORTED.type || "warning",
          content: e.checks.CONTRAST_UNSUPPORTED.content ? f.sprintf(e.checks.CONTRAST_UNSUPPORTED.content) : f.sprintf("CONTRAST_WARNING") + E,
          dismiss: N(`CONTRAST${h}`),
          dismissAll: e.checks.CONTRAST_UNSUPPORTED.dismissAll ? "CONTRAST_UNSUPPORTED" : !1,
          developer: e.checks.CONTRAST_UNSUPPORTED.developer || !1,
          contrastDetails: c
        });
        break;
    }
  }), t;
}
function Sr(t, e) {
  return e.formLabelsPlugin && M.Found.Inputs.forEach((n) => {
    const s = n.getAttribute("aria-hidden") === "true", r = n.getAttribute("tabindex") === "-1";
    if (Me(n) || s && r)
      return;
    const i = Te(n), l = be(i), c = n.getAttribute("alt"), p = n.getAttribute("type"), o = n.getAttribute("title"), d = n.placeholder && n.placeholder !== 0, m = n.getAttribute("aria-label") || n.getAttribute("aria-labelledby");
    if (p === "submit" || p === "button" || p === "hidden")
      return;
    if (p === "image") {
      e.checks.LABELS_MISSING_IMAGE_INPUT && (!c || c.trim() === "") && !m && !o && t.push({
        test: "LABELS_MISSING_IMAGE_INPUT",
        element: n,
        type: e.checks.LABELS_MISSING_IMAGE_INPUT.type || "error",
        content: f.sprintf(
          e.checks.LABELS_MISSING_IMAGE_INPUT.content || "LABELS_MISSING_IMAGE_INPUT"
        ),
        dismiss: N(`INPUTIMAGE${p + l}`),
        dismissAll: e.checks.LABELS_MISSING_IMAGE_INPUT.dismissAll ? "LABELS_MISSING_IMAGE_INPUT" : !1,
        developer: e.checks.LABELS_MISSING_IMAGE_INPUT.developer || !0
      });
      return;
    }
    if (p === "reset") {
      e.checks.LABELS_INPUT_RESET && t.push({
        test: "LABELS_INPUT_RESET",
        element: n,
        type: e.checks.LABELS_INPUT_RESET.type || "warning",
        content: f.sprintf(e.checks.LABELS_INPUT_RESET.content || "LABELS_INPUT_RESET"),
        dismiss: N(`INPUTRESET${p + l}`),
        dismissAll: e.checks.LABELS_INPUT_RESET.dismissAll ? "LABELS_INPUT_RESET" : !1,
        developer: e.checks.LABELS_INPUT_RESET.developer || !1
      });
      return;
    }
    if (m || o || d) {
      if (d && e.checks.LABELS_PLACEHOLDER)
        t.push({
          test: "LABELS_PLACEHOLDER",
          element: n,
          type: e.checks.LABELS_PLACEHOLDER.type || "warning",
          content: f.sprintf(e.checks.LABELS_PLACEHOLDER.content || "LABELS_PLACEHOLDER"),
          dismiss: N(`INPUTPLACEHOLDER${p + l}`),
          dismissAll: e.checks.LABELS_PLACEHOLDER.dismissAll ? "LABELS_PLACEHOLDER" : !1,
          developer: e.checks.LABELS_PLACEHOLDER.developer || !0
        });
      else if (l.length === 0)
        e.checks.LABELS_MISSING_LABEL && t.push({
          test: "LABELS_MISSING_LABEL",
          element: n,
          type: e.checks.LABELS_MISSING_LABEL.type || "error",
          content: f.sprintf(
            e.checks.LABELS_MISSING_LABEL.content || "LABELS_MISSING_LABEL"
          ),
          dismiss: N(`INPUTMISSING${p + l}`),
          dismissAll: e.checks.LABELS_MISSING_LABEL.dismissAll ? "LABELS_MISSING_LABEL" : !1,
          developer: e.checks.LABELS_MISSING_LABEL.developer || !0
        });
      else if (e.checks.LABELS_ARIA_LABEL_INPUT) {
        const y = q(l);
        t.push({
          test: "LABELS_ARIA_LABEL_INPUT",
          element: n,
          type: e.checks.LABELS_ARIA_LABEL_INPUT.type || "warning",
          content: e.checks.LABELS_ARIA_LABEL_INPUT.content ? f.sprintf(e.checks.LABELS_ARIA_LABEL_INPUT.content, y) : `${f.sprintf("LABELS_ARIA_LABEL_INPUT", y)} ${f.sprintf("ACC_NAME_TIP")}`,
          dismiss: N(`INPUTARIA${p + l}`),
          dismissAll: e.checks.LABELS_ARIA_LABEL_INPUT.dismissAll ? "LABELS_ARIA_LABEL_INPUT" : !1,
          developer: e.checks.LABELS_ARIA_LABEL_INPUT.developer || !0
        });
      }
      return;
    }
    const h = n.closest("label"), A = h ? be(Te(h)) : "";
    if (h && A.length)
      return;
    const E = n.getAttribute("id");
    E ? M.Found.Labels.some((y) => y.getAttribute("for") === E) || e.checks.LABELS_NO_FOR_ATTRIBUTE && t.push({
      test: "LABELS_NO_FOR_ATTRIBUTE",
      element: n,
      type: e.checks.LABELS_NO_FOR_ATTRIBUTE.type || "error",
      content: f.sprintf(
        e.checks.LABELS_NO_FOR_ATTRIBUTE.content || "LABELS_NO_FOR_ATTRIBUTE",
        E
      ),
      dismiss: N(`INPUTNOFOR${p + l}`),
      dismissAll: e.checks.LABELS_NO_FOR_ATTRIBUTE.dismissAll ? "LABELS_NO_FOR_ATTRIBUTE" : !1,
      developer: e.checks.LABELS_NO_FOR_ATTRIBUTE.developer || !0
    }) : e.checks.LABELS_MISSING_LABEL && t.push({
      test: "LABELS_MISSING_LABEL",
      element: n,
      type: e.checks.LABELS_MISSING_LABEL.type || "error",
      content: f.sprintf(
        e.checks.LABELS_MISSING_LABEL.content || "LABELS_MISSING_LABEL"
      ),
      dismiss: N(`INPUTNOID${p + l}`),
      dismissAll: e.checks.LABELS_MISSING_LABEL.dismissAll ? "LABELS_MISSING_LABEL" : !1,
      developer: e.checks.LABELS_MISSING_LABEL.developer || !0
    });
  }), t;
}
function kr(t, e) {
  const n = [], s = [".", "?", "!"];
  t.forEach((a) => {
    const i = a[a.length - 1], l = s.includes(i) ? a : `${a}.`;
    n.push(l);
  });
  const r = n.join(" ");
  if (r.length === 0)
    return null;
  if (["en", "es", "fr", "de", "nl", "it", "pt"].includes(e)) {
    const a = (v) => {
      let L = v;
      if (L = L.toLowerCase().replace(".", "").replace(`
`, ""), L.length <= 3)
        return 1;
      L = L.replace(/(?:[^laeiouy]es|ed|[^laeiouy]e)$/, ""), L = L.replace(/^y/, "");
      const g = L.match(/[aeiouy]{1,2}/g);
      let _ = 0;
      return g && (_ = g.length), _;
    }, i = r.replace(/[.!?-]+/g, " ").split(" ");
    let l = 0;
    for (let v = 0; v < i.length; v++)
      i[v].trim() !== "" && (l += 1);
    const c = r.split(/[.!?]+/);
    let p = 0;
    for (let v = 0; v < c.length; v++)
      c[v] !== "" && (p += 1);
    let o = 0, d = 0, m = 0;
    for (let v = 0; v < i.length; v++) {
      const L = i[v];
      if (L.length > 0) {
        const g = a(L);
        g === 1 ? d += 1 : g === 2 && (m += 1), o += g;
      }
    }
    let h = !1;
    e === "en" ? h = 206.835 - 1.015 * (l / p) - 84.6 * (o / l) : e === "fr" ? h = 207 - 1.015 * (l / p) - 73.6 * (o / l) : e === "es" ? h = 206.84 - 1.02 * (l / p) - 0.6 * (100 * (o / l)) : e === "de" ? h = 180 - l / p - 58.5 * (o / l) : e === "nl" ? h = 206.84 - 0.77 * (100 * (o / l)) - 0.93 * (l / p) : e === "it" ? h = 217 - 1.3 * (l / p) - 0.6 * (100 * (o / l)) : e === "pt" && (h = 248.835 - 1.015 * (l / p) - 84.6 * (o / l)), h > 100 ? h = 100 : h < 0 && (h = 0);
    const A = Number(h.toFixed(1)), E = Number((l / p).toFixed(1)), y = Math.round(100 * ((l - (d + m)) / l));
    let b;
    return A >= 0 && A < 30 ? b = "VERY_DIFFICULT" : A > 31 && A < 49 ? b = "DIFFICULT" : A > 50 && A < 60 ? b = "FAIRLY_DIFFICULT" : b = "GOOD", {
      score: A,
      averageWordsPerSentence: E,
      complexWords: y,
      difficultyToken: b,
      wordCount: l,
      charCount: r.length
    };
  }
  if (["sv", "fi", "da", "no", "nb", "nn"].includes(e)) {
    const a = () => r.replace(/[-'.]/gi, "").split(/[^a-zA-ZöäåÖÄÅÆæØø0-9]/g).filter(Boolean), i = () => {
      const E = /\?|!|\.|\n/g;
      return r.split(E).filter(Boolean);
    }, l = a(), c = l.length, p = l.filter((E) => E.length > 6).length, o = i().length || 1, d = Math.round(c / o + p * 100 / c), m = Number((c / o).toFixed(1)), h = Math.round(100 * (p / c));
    let A;
    return d >= 0 && d < 39 ? A = "GOOD" : d > 40 && d < 50 ? A = "FAIRLY_DIFFICULT" : d > 51 && d < 61 ? A = "DIFFICULT" : A = "VERY_DIFFICULT", {
      score: d,
      averageWordsPerSentence: m,
      complexWords: h,
      difficultyToken: A,
      wordCount: c,
      charCount: r.length
    };
  }
  return null;
}
function wr(t) {
  const e = M.Found.Readability.map(
    (r) => j(qe(r))
  ).filter(Boolean), n = kr(e, u.Readability.Lang);
  let s;
  return n && (s = {
    test: "READABILITY",
    difficultyLevel: f._(n.difficultyToken),
    ...n
  }, t.push(s)), u.Global.headless === !1 && (n && s.wordCount > 30 ? (u.Panel.readabilityInfo.innerHTML = `${Math.ceil(s.score)} <span class="readability-score">${s.difficultyLevel}</span>`, u.Panel.readabilityDetails.innerHTML = `<li><strong>${f._("AVG_SENTENCE")}</strong> ${Math.ceil(s.averageWordsPerSentence)}</li><li><strong>${f._("COMPLEX_WORDS")}</strong> ${s.complexWords}%</li><li><strong>${f._("TOTAL_WORDS")}</strong> ${s.wordCount}</li>`) : u.Panel.readabilityInfo.innerHTML = `<br>${f._("READABILITY_NOT_ENOUGH")}`), t;
}
function Cr(t, e) {
  const n = (s) => s.getAttribute("src") || s.querySelector("source[src]")?.getAttribute("src") || s.querySelector("[src]")?.getAttribute("src") || null;
  return e.checks.EMBED_AUDIO && M.Found.Audio.forEach((s) => {
    t.push({
      test: "EMBED_AUDIO",
      element: s,
      type: e.checks.EMBED_AUDIO.type || "warning",
      content: f.sprintf(e.checks.EMBED_AUDIO.content || "EMBED_AUDIO"),
      dismiss: N(`AUDIO${n(s)}`),
      dismissAll: e.checks.EMBED_AUDIO.dismissAll ? "EMBED_AUDIO" : !1,
      developer: e.checks.EMBED_AUDIO.developer || !1
    });
  }), e.checks.EMBED_VIDEO && M.Found.Videos.forEach((s) => {
    const r = s.querySelector("track"), a = r?.getAttribute("src");
    (r === null || a === null || a.trim().length === 0) && t.push({
      test: "EMBED_VIDEO",
      element: s,
      type: e.checks.EMBED_VIDEO.type || "warning",
      content: f.sprintf(e.checks.EMBED_VIDEO.content || "EMBED_VIDEO"),
      dismiss: N(`VIDEO${n(s)}`),
      dismissAll: e.checks.EMBED_VIDEO.dismissAll ? "EMBED_VIDEO" : !1,
      developer: e.checks.EMBED_VIDEO.developer || !1
    });
  }), e.checks.EMBED_DATA_VIZ && M.Found.Visualizations.forEach((s) => {
    t.push({
      test: "EMBED_DATA_VIZ",
      element: s,
      type: e.checks.EMBED_DATA_VIZ.type || "warning",
      content: f.sprintf(e.checks.EMBED_DATA_VIZ.content || "EMBED_DATA_VIZ"),
      dismiss: N(`DATAVIZ${n(s)}`),
      dismissAll: e.checks.EMBED_DATA_VIZ.dismissAll ? "EMBED_DATA_VIZ" : !1,
      developer: e.checks.EMBED_DATA_VIZ.developer || !1
    });
  }), M.Found.iframes.forEach((s) => {
    const r = ["presentation", "none"].includes(s.getAttribute("role")), a = Me(s), i = s.tagName === "VIDEO" || s.tagName === "AUDIO", l = s.getAttribute("aria-hidden") === "true", c = s.getAttribute("tabindex") === "-1";
    if (!(a || i || l && c || r)) {
      if (c) {
        e.checks.EMBED_UNFOCUSABLE && t.push({
          test: "EMBED_UNFOCUSABLE",
          element: s,
          type: e.checks.EMBED_UNFOCUSABLE.type || "error",
          content: f.sprintf(e.checks.EMBED_UNFOCUSABLE.content || "EMBED_UNFOCUSABLE"),
          dismiss: N(`EMBEDUNFOCUSABLE${n(s)}`),
          dismissAll: e.checks.EMBED_UNFOCUSABLE.dismissAll ? "EMBED_UNFOCUSABLE" : !1,
          developer: e.checks.EMBED_UNFOCUSABLE.developer || !0
        });
        return;
      }
      if (e.checks.EMBED_MISSING_TITLE) {
        const p = ke(s), o = p === "noAria" ? s.getAttribute("title") || "" : p;
        be(o).length === 0 && t.push({
          test: "EMBED_MISSING_TITLE",
          element: s,
          type: e.checks.EMBED_MISSING_TITLE.type || "error",
          content: f.sprintf(e.checks.EMBED_MISSING_TITLE.content || "EMBED_MISSING_TITLE"),
          dismiss: N(`EMBEDMISSTITLE${n(s)}`),
          dismissAll: e.checks.EMBED_MISSING_TITLE.dismissAll ? "EMBED_MISSING_TITLE" : !1,
          developer: e.checks.EMBED_MISSING_TITLE.developer || !0
        });
      }
    }
  }), e.checks.EMBED_GENERAL && M.Found.EmbeddedContent.forEach((s) => {
    const r = ["presentation", "none"].includes(s.getAttribute("role")), a = s.getAttribute("aria-hidden") === "true", i = s.getAttribute("tabindex") === "-1";
    Me(s) || a && i || r || s.tagName === "VIDEO" || s.tagName === "AUDIO" || t.push({
      test: "EMBED_GENERAL",
      element: s,
      type: e.checks.EMBED_GENERAL.type || "warning",
      content: f.sprintf(e.checks.EMBED_GENERAL.content || "EMBED_GENERAL"),
      dismiss: N(`IFRAMEGENERAL${n(s)}`),
      dismissAll: e.checks.EMBED_GENERAL.dismissAll ? "EMBED_GENERAL" : !1,
      developer: e.checks.EMBED_GENERAL.developer || !1
    });
  }), t;
}
function Or(t, e) {
  if (e.checks.QA_BAD_LINK && M.Found.CustomErrorLinks.forEach((i) => {
    t.push({
      test: "QA_BAD_LINK",
      element: i,
      type: e.checks.QA_BAD_LINK.type || "error",
      content: f.sprintf(e.checks.QA_BAD_LINK.content || "QA_BAD_LINK", i),
      inline: !0,
      dismiss: N(i.tagName + i.textContent),
      dismissAll: e.checks.QA_BAD_LINK.dismissAll ? "QA_BAD_LINK" : !1,
      developer: e.checks.QA_BAD_LINK.developer || !1
    });
  }), e.checks.QA_STRONG_ITALICS && M.Found.StrongItalics.forEach((i) => {
    const l = j(i);
    l.length !== 0 && l.length > 400 && t.push({
      test: "QA_STRONG_ITALICS",
      element: i.parentNode,
      type: e.checks.QA_STRONG_ITALICS.type || "warning",
      content: f.sprintf(e.checks.QA_STRONG_ITALICS.content || "QA_STRONG_ITALICS"),
      dismiss: N(i.tagName + i.textContent),
      dismissAll: e.checks.QA_STRONG_ITALICS.dismissAll ? "QA_STRONG_ITALICS" : !1,
      developer: e.checks.QA_STRONG_ITALICS.developer || !1
    });
  }), M.Found.Links.forEach((i) => {
    if (i.hasAttribute("href")) {
      const l = i.getAttribute("href"), c = i.matches(u.Global.documentSources), p = i.matches('a[href$=".pdf"], a[href*=".pdf?"]');
      if (e.checks.QA_IN_PAGE_LINK) {
        const o = j(i).length !== 0, d = i.ariaHidden === "true" && i.getAttribute("tabindex") === "-1", m = i.hasAttribute("role") || i.hasAttribute("aria-haspopup") || i.hasAttribute("aria-expanded") || i.hasAttribute("onclick") || i.hasAttribute("disabled") || i.closest('nav, [role="navigation"]');
        if ((l.startsWith("#") || l === "") && o && !d && !m) {
          const h = l.substring(1), A = i.getAttribute("aria-controls");
          h && (document.getElementById(h) || document.getElementById(decodeURIComponent(h)) || document.getElementById(encodeURIComponent(h)) || document.getElementById(A) || document.querySelector(`a[name="${h}"]`)) || t.push({
            test: "QA_IN_PAGE_LINK",
            element: i,
            type: e.checks.QA_IN_PAGE_LINK.type || "error",
            content: f.sprintf(e.checks.QA_IN_PAGE_LINK.content || "QA_IN_PAGE_LINK"),
            inline: !0,
            dismiss: N(`QAINPAGE${l}`),
            dismissAll: e.checks.QA_IN_PAGE_LINK.dismissAll ? "QA_IN_PAGE_LINK" : !1,
            developer: e.checks.QA_IN_PAGE_LINK.developer || !1
          });
        }
      }
      e.checks.QA_DOCUMENT && c ? t.push({
        test: "QA_DOCUMENT",
        element: i,
        type: e.checks.QA_DOCUMENT.type || "warning",
        content: f.sprintf(e.checks.QA_DOCUMENT.content || "QA_DOCUMENT"),
        inline: !0,
        dismiss: N(`DOC${l}`),
        dismissAll: e.checks.QA_DOCUMENT.dismissAll ? "QA_DOCUMENT" : !1,
        developer: e.checks.QA_DOCUMENT.developer || !1
      }) : e.checks.QA_PDF && p && t.push({
        test: "QA_PDF",
        element: i,
        type: e.checks.QA_PDF.type || "warning",
        content: f.sprintf(e.checks.QA_PDF.content || "QA_PDF"),
        inline: !0,
        dismiss: N(`PDF${l}`),
        dismissAll: e.checks.QA_PDF.dismissAll ? "QA_PDF" : !1,
        developer: e.checks.QA_PDF.developer || !1
      });
    }
  }), e.checks.QA_BLOCKQUOTE && M.Found.Blockquotes.forEach((i) => {
    const l = j(i);
    if (l.length !== 0 && l.length < 25) {
      const c = q(l);
      t.push({
        test: "QA_BLOCKQUOTE",
        element: i,
        type: e.checks.QA_BLOCKQUOTE.type || "warning",
        content: f.sprintf(
          e.checks.QA_BLOCKQUOTE.content || "QA_BLOCKQUOTE",
          c
        ),
        dismiss: N(`BLOCKQUOTE${c}`),
        dismissAll: e.checks.QA_BLOCKQUOTE.dismissAll ? "QA_BLOCKQUOTE" : !1,
        developer: e.checks.QA_BLOCKQUOTE.developer || !1
      });
    }
  }), M.Found.Tables.forEach((i) => {
    if (Me(i) === !1) {
      const l = i.querySelectorAll("th"), c = i.querySelectorAll("h1, h2, h3, h4, h5, h6"), p = N(`TABLE${i.textContent}`);
      e.checks.TABLES_MISSING_HEADINGS && l.length === 0 && t.push({
        test: "TABLES_MISSING_HEADINGS",
        element: i,
        type: e.checks.TABLES_MISSING_HEADINGS.type || "error",
        content: f.sprintf(
          e.checks.TABLES_MISSING_HEADINGS.content || "TABLES_MISSING_HEADINGS"
        ),
        dismiss: p,
        dismissAll: e.checks.TABLES_MISSING_HEADINGS.dismissAll ? "TABLES_MISSING_HEADINGS" : !1,
        developer: e.checks.TABLES_MISSING_HEADINGS.developer || !1
      }), e.checks.TABLES_SEMANTIC_HEADING && c.length > 0 && c.forEach((o) => {
        t.push({
          test: "TABLES_SEMANTIC_HEADING",
          element: o,
          type: e.checks.TABLES_SEMANTIC_HEADING.type || "error",
          content: f.sprintf(
            e.checks.TABLES_SEMANTIC_HEADING.content || "TABLES_SEMANTIC_HEADING"
          ),
          dismiss: p,
          dismissAll: e.checks.TABLES_SEMANTIC_HEADING.dismissAll ? "TABLES_SEMANTIC_HEADING" : !1,
          developer: e.checks.TABLES_SEMANTIC_HEADING.developer || !1
        });
      }), l.forEach((o) => {
        e.checks.TABLES_EMPTY_HEADING && o.textContent.trim().length === 0 && t.push({
          test: "TABLES_EMPTY_HEADING",
          element: o,
          type: e.checks.TABLES_EMPTY_HEADING.type || "error",
          content: f.sprintf(
            e.checks.TABLES_EMPTY_HEADING.content || "TABLES_EMPTY_HEADING"
          ),
          position: "afterbegin",
          dismiss: p,
          dismissAll: e.checks.TABLES_EMPTY_HEADING.dismissAll ? "TABLES_EMPTY_HEADING" : !1,
          developer: e.checks.TABLES_EMPTY_HEADING.developer || !1
        });
      });
    }
  }), e.checks.QA_FAKE_HEADING) {
    const i = (d, m) => {
      t.push({
        test: "QA_FAKE_HEADING",
        element: d,
        type: e.checks.QA_FAKE_HEADING.type || "warning",
        content: f.sprintf(
          e.checks.QA_FAKE_HEADING.content || "QA_FAKE_HEADING",
          m
        ),
        dismiss: N(`BOLD${m}`),
        inline: !0,
        dismissAll: e.checks.QA_FAKE_HEADING.dismissAll ? "QA_FAKE_HEADING" : !1,
        developer: e.checks.QA_FAKE_HEADING.developer || !1
      });
    }, l = (d) => {
      const m = d.previousElementSibling;
      return m ? ["H1", "H2", "H3", "H4", "H5", "H6"].includes(m.tagName) : !1;
    }, c = 'h1, h2, h3, h4, h5, h6, [role="heading"][aria-level], blockquote, table', p = (d) => {
      const m = getComputedStyle(d).fontSize.replace("px", ""), h = j(d), A = h.match(/[.;?!"]/) === null, E = h.length >= 4 && h.length <= 120;
      if (m >= 24 && !d.closest(c) && E && A && !l(d)) {
        const y = q(h);
        i(d, y);
      }
    }, o = (d) => {
      if (/^<\s*(strong|b)(\s+[^>]*)?>/i.test(d.innerHTML.trim()) && !d.closest(c)) {
        const h = d.querySelector("strong, b"), A = j(h), E = A.match(/[.:;?!"']/) === null;
        if (A.length >= 3 && A.length <= 120 && E) {
          const b = qe(d, ["strong", "b"]).textContent.trim().length;
          if (b !== 0 && b <= 250)
            return;
          const v = q(A);
          i(h, v);
        }
      }
    };
    M.Found.Paragraphs.forEach((d) => {
      p(d), o(d);
    });
  }
  if (e.checks.QA_FAKE_LIST) {
    const i = new RegExp(/(([023456789][\d\s])|(1\d))/, ""), l = new RegExp(/(^[aA1αаΑ]|[^p{Alphabetic}\s])[-\s.)]/, "u"), c = new RegExp(/\p{Extended_Pictographic}/, "u"), p = ["a", "A", "α", "Α", "а", "А", "1"], o = /[([{#]/, d = {
      2: "1",
      b: "a",
      B: "A",
      β: "α",
      Β: "Α",
      б: "а",
      Б: "А"
    }, m = (y) => y.replace(/^b|^B|^б|^Б|^β|^В|^2/, (b) => d[b]);
    let h = "", A = "", E = !1;
    M.Found.Paragraphs.forEach((y, b) => {
      let v = !1, L = !1;
      A = A || j(y).replace("(", "");
      const g = A.substring(0, 2), _ = g.match(l), I = g.match(i), S = g.match(c), x = o.test(g.charAt(0));
      if (g.length > 0 && g !== h && !I && (_ || S || x)) {
        const C = M.Found.Paragraphs[b + 1];
        if (C) {
          if (v = j(C).replace("(", "").substring(0, 2), p.includes(v?.toLowerCase().trim()))
            return;
          const k = m(v);
          _ ? g !== "A " && g === k && (L = !0) : S && !E && k.match(c) && (L = !0, E = !0);
        }
        if (!L) {
          let k = y?.querySelector("br")?.nextSibling?.nodeValue;
          k && (k = k.replace(/<\/?[^>]+(>|$)/g, "").trim().substring(0, 2), (o.test(k.charAt(0)) || g === m(k) || !E && k.match(c)) && (L = !0));
        }
        L ? (t.push({
          test: "QA_FAKE_LIST",
          element: y,
          type: e.checks.QA_FAKE_LIST.type || "warning",
          content: f.sprintf(
            e.checks.QA_FAKE_LIST.content || "QA_FAKE_LIST",
            g
          ),
          dismiss: N(`LIST${y.textContent}`),
          dismissAll: e.checks.QA_FAKE_LIST.dismissAll ? "QA_FAKE_LIST" : !1,
          developer: e.checks.QA_FAKE_LIST.developer || !1
        }), h = g) : h = "";
      }
      A = v && "";
    });
  }
  if (e.checks.QA_UPPERCASE) {
    const i = (l) => {
      let c = "";
      l.tagName === "LI" ? l.childNodes.forEach((d) => {
        d.nodeType === 3 && (c += d.textContent);
      }) : c = j(l);
      const p = /([A-Z]{2,}[ ])([A-Z]{2,}[ ])([A-Z]{2,}[ ])([A-Z]{2,})/g, o = c.match(p);
      o && o[0].length > 10 && t.push({
        test: "QA_UPPERCASE",
        element: l,
        type: e.checks.QA_UPPERCASE.type || "warning",
        content: f.sprintf(e.checks.QA_UPPERCASE.content || "QA_UPPERCASE"),
        dismiss: N(`UPPERCASE${c}`),
        dismissAll: e.checks.QA_UPPERCASE.dismissAll ? "QA_UPPERCASE" : !1,
        developer: e.checks.QA_UPPERCASE.developer || !1
      });
    };
    M.Found.Paragraphs.forEach((l) => {
      i(l);
    }), M.Found.Headings.forEach((l) => {
      i(l);
    }), M.Found.Lists.forEach((l) => {
      i(l);
    }), M.Found.Blockquotes.forEach((l) => {
      i(l);
    });
  }
  const n = (i) => {
    t.push({
      test: "QA_UNDERLINE",
      element: i,
      type: e.checks.QA_UNDERLINE.type || "warning",
      content: f.sprintf(e.checks.QA_UNDERLINE.content || "QA_UNDERLINE"),
      inline: !0,
      dismiss: N(`UNDERLINE${i.textContent}`),
      dismissAll: e.checks.QA_UNDERLINE.dismissAll ? "QA_UNDERLINE" : !1,
      developer: e.checks.QA_UNDERLINE.developer || !1
    });
  }, s = (i) => {
    t.push({
      test: "QA_JUSTIFY",
      element: i,
      type: e.checks.QA_JUSTIFY.type || "warning",
      content: f.sprintf(e.checks.QA_JUSTIFY.content || "QA_JUSTIFY"),
      dismiss: N(`JUSTIFIED${i.textContent}`),
      dismissAll: e.checks.QA_JUSTIFY.dismissAll ? "QA_JUSTIFY" : !1,
      developer: e.checks.QA_JUSTIFY.developer || !1
    });
  }, r = (i) => {
    t.push({
      test: "QA_SMALL_TEXT",
      element: i,
      type: e.checks.QA_SMALL_TEXT.type || "warning",
      content: f.sprintf(e.checks.QA_SMALL_TEXT.content || "QA_SMALL_TEXT"),
      dismiss: N(`SMALL${i.textContent}`),
      dismissAll: e.checks.QA_SMALL_TEXT.dismissAll ? "QA_SMALL_TEXT" : !1,
      developer: e.checks.QA_SMALL_TEXT.developer || !1
    });
  }, a = (i) => {
    const l = getComputedStyle(i), { textDecorationLine: c, textAlign: p, fontSize: o } = l, d = 'a[href], button, abbr, [role="link"], [role="button"], [tabindex="0"], [onclick]';
    e.checks.QA_UNDERLINE && (i.closest("u") || c === "underline") && !i.closest(d) && !i.matches(d) && n(i);
    const m = e.checks.QA_SMALL_TEXT.fontSize || 10, h = parseFloat(o), y = !((i.parentElement ? parseFloat(getComputedStyle(i.parentElement).fontSize) : null) === h) && h > 1 && h <= m;
    e.checks.QA_SMALL_TEXT && y && r(i);
    const v = (i.parentElement ? getComputedStyle(i.parentElement).textAlign : null) === p;
    e.checks.QA_JUSTIFY && p === "justify" && !v && s(i);
  };
  if (e.checks.QA_UNDERLINE || e.checks.QA_JUSTIFY || e.checks.QA_SMALL_TEXT)
    for (let i = 0; i < M.Found.Everything.length; i++) {
      const l = M.Found.Everything[i];
      Array.from(l.childNodes).filter((o) => o.nodeType === 3).map((o) => o.textContent).join("").trim().length !== 0 && a(l);
    }
  return e.checks.QA_SUBSCRIPT && M.Found.Subscripts.forEach((i) => {
    const l = j(i);
    l.length >= 80 && t.push({
      test: "QA_SUBSCRIPT",
      element: i,
      type: e.checks.QA_SUBSCRIPT.type || "warning",
      content: f.sprintf(e.checks.QA_SUBSCRIPT.content || "QA_SUBSCRIPT"),
      inline: !0,
      dismiss: N(i.tagName + l),
      dismissAll: e.checks.QA_SUBSCRIPT.dismissAll ? "QA_SUBSCRIPT" : !1,
      developer: e.checks.QA_SUBSCRIPT.developer || !1
    });
  }), e.checks.QA_NESTED_COMPONENTS && M.Found.NestedComponents.forEach((i) => {
    const l = e.checks.QA_NESTED_COMPONENTS.sources || '[role="tablist"], details';
    i.querySelector(l) && t.push({
      test: "QA_NESTED_COMPONENTS",
      element: i,
      type: e.checks.QA_NESTED_COMPONENTS.type || "warning",
      content: f.sprintf(
        e.checks.QA_NESTED_COMPONENTS.content || "QA_NESTED_COMPONENTS"
      ),
      dismiss: N(`NESTED${i.textContent}`),
      dismissAll: e.checks.QA_NESTED_COMPONENTS.dismissAll ? "QA_NESTED_COMPONENTS" : !1,
      developer: e.checks.QA_NESTED_COMPONENTS.developer || !1
    });
  }), t;
}
function Pr(t, e) {
  if (e.checks.META_LANG && (!M.Found.Language || M.Found.Language.length < 2) && t.push({
    test: "META_LANG",
    type: e.checks.META_LANG.type || "error",
    content: f.sprintf(e.checks.META_LANG.content || "META_LANG"),
    dismiss: N("LANG"),
    developer: e.checks.META_LANG.developer || !0
  }), e.checks.META_TITLE) {
    const n = document.querySelector("title:not(svg title)");
    (!n || n.textContent.trim().length === 0) && t.push({
      test: "META_TITLE",
      type: e.checks.META_TITLE.type || "error",
      content: f.sprintf(e.checks.META_TITLE.content || "META_TITLE"),
      dismiss: N("TITLE"),
      developer: e.checks.META_TITLE.developer || !0
    });
  }
  if (e.checks.META_SCALABLE || e.checks.META_MAX) {
    const n = document.querySelector('meta[name="viewport"]');
    if (n) {
      const s = n.getAttribute("content");
      if (s) {
        const r = s.split(",").reduce((i, l) => {
          const [c, p] = l.split("=").map((o) => o.trim());
          return i[c] = p, i;
        }, {});
        e.checks.META_SCALABLE && (r["user-scalable"] === "no" || r["user-scalable"] === "0") && t.push({
          test: "META_SCALABLE",
          type: e.checks.META_SCALABLE.type || "error",
          content: f.sprintf(e.checks.META_SCALABLE.content || "META_SCALABLE"),
          dismiss: N("SCALABLE"),
          developer: e.checks.META_SCALABLE.developer || !0
        });
        const a = parseFloat(r["maximum-scale"]);
        e.checks.META_MAX && !Number.isNaN(a) && a < 2 && t.push({
          test: "META_MAX",
          type: e.checks.META_MAX.type || "error",
          content: f.sprintf(e.checks.META_MAX.content || "META_MAX"),
          dismiss: N("MAXSCALE"),
          developer: e.checks.META_MAX.developer || !0
        });
      }
    }
  }
  return e.checks.META_REFRESH && document.querySelector('meta[http-equiv="refresh"]') && t.push({
    test: "META_REFRESH",
    type: e.checks.META_REFRESH.type || "error",
    content: f.sprintf(e.checks.META_REFRESH.content || "META_REFRESH"),
    dismiss: N("REFRESH"),
    developer: e.checks.META_REFRESH.developer || !0
  }), e.checks.DUPLICATE_ID && document.querySelectorAll("body, [data-sa11y-has-shadow-root]").forEach((s) => {
    const r = /* @__PURE__ */ new Set(), a = (l, c) => {
      l.forEach((p) => {
        const { id: o } = p;
        typeof o != "string" || o.trim().length === 0 || (o && !r.has(o) ? r.add(o) : Array.from(
          c.querySelectorAll(`
                a[href*="${o}"],
                label[for*="${o}"],
                [aria-labelledby*="${o}"],
                [aria-controls*="${o}"],
                [aria-owns*="${o}"]`)
        ).length > 0 && t.push({
          test: "DUPLICATE_ID",
          element: p,
          type: e.checks.DUPLICATE_ID.type || "error",
          content: f.sprintf(e.checks.DUPLICATE_ID.content || "DUPLICATE_ID", o),
          dismiss: N(`DUPLICATEID${o}${p.textContent}`),
          dismissAll: e.checks.DUPLICATE_ID.dismissAll ? "DUPLICATE_ID" : !1,
          developer: e.checks.DUPLICATE_ID.developer || !0
        }));
      });
    };
    if (s.shadowRoot) {
      const l = Array.from(
        s.shadowRoot.querySelectorAll(`[id]:not(${u.Exclusions.Container})`)
      );
      a(l, s.shadowRoot);
    }
    const i = Array.from(
      s.querySelectorAll(`[id]:not(${u.Exclusions.Container})`)
    );
    a(i, s);
  }), (e.checks.BTN_EMPTY || e.checks.BTN_EMPTY_LABELLEDBY || e.checks.BTN_LABEL || e.checks.HIDDEN_FOCUSABLE || e.checks.LABEL_IN_NAME) && M.Found.Buttons.forEach((n) => {
    const s = Te(n), r = s.replace(/'|"|-|\.|\s+/g, "").toLowerCase(), a = N(`BTN${n.tagName + n.id + n.className + s}`), i = n.querySelector(":scope [aria-labelledby], :scope [aria-label]") || n.getAttribute("aria-labelledby") || n.getAttribute("aria-label"), l = n.querySelector(":scope [aria-labelledby]") || n.getAttribute("aria-labelledby"), c = n.getAttribute("aria-hidden") === "true", p = n.getAttribute("tabindex") === "-1";
    if (c) {
      p || e.checks.HIDDEN_FOCUSABLE && t.push({
        test: "HIDDEN_FOCUSABLE",
        element: n,
        type: e.checks.HIDDEN_FOCUSABLE.type || "error",
        content: f.sprintf(e.checks.HIDDEN_FOCUSABLE.content || "HIDDEN_FOCUSABLE"),
        dismiss: a,
        dismissAll: e.checks.HIDDEN_FOCUSABLE.dismissAll ? "BTN_HIDDEN_FOCUSABLE" : !1,
        developer: e.checks.HIDDEN_FOCUSABLE.developer || !0
      });
      return;
    }
    if (r.length === 0) {
      e.checks.BTN_EMPTY_LABELLEDBY && l ? t.push({
        test: "BTN_EMPTY_LABELLEDBY",
        element: n,
        type: e.checks.BTN_EMPTY_LABELLEDBY.type || "error",
        content: e.checks.BTN_EMPTY_LABELLEDBY.content ? f.sprintf(e.checks.BTN_EMPTY_LABELLEDBY.content) : `${f.sprintf("BTN_EMPTY_LABELLEDBY")} ${f.sprintf("BTN_TIP")}`,
        dismiss: N(a),
        dismissAll: e.checks.BTN_EMPTY_LABELLEDBY.dismissAll ? "BTN_EMPTY_LABELLEDBY" : !1,
        developer: e.checks.BTN_EMPTY_LABELLEDBY.developer || !0
      }) : e.checks.BTN_EMPTY && t.push({
        test: "BTN_EMPTY",
        element: n,
        type: e.checks.BTN_EMPTY.type || "error",
        content: e.checks.BTN_EMPTY.content ? f.sprintf(e.checks.BTN_EMPTY.content) : `${f.sprintf("BTN_EMPTY")} ${f.sprintf("BTN_TIP")}`,
        dismiss: a,
        dismissAll: e.checks.BTN_EMPTY.dismissAll ? "BTN_EMPTY" : !1,
        developer: e.checks.BTN_EMPTY.developer || !0
      });
      return;
    }
    const o = is(n, s);
    if (e.checks.LABEL_IN_NAME && i && o) {
      const d = q(s);
      t.push({
        test: "LABEL_IN_NAME",
        element: n,
        type: e.checks.LABEL_IN_NAME.type || "warning",
        content: e.checks.LABEL_IN_NAME.content ? f.sprintf(e.checks.LABEL_IN_NAME.content, d) : `${f.sprintf("LABEL_IN_NAME", d)} ${f.sprintf("ACC_NAME_TIP")}`,
        dismiss: a,
        dismissAll: e.checks.LABEL_IN_NAME.dismissAll ? "BTN_LABEL_IN_NAME" : !1,
        developer: e.checks.LABEL_IN_NAME.developer || !0
      });
      return;
    }
    e.checks.BTN_ROLE_IN_NAME && s.includes(f._("BTN")) && t.push({
      test: "BTN_ROLE_IN_NAME",
      element: n,
      type: e.checks.BTN_ROLE_IN_NAME.type || "warning",
      content: e.checks.BTN_ROLE_IN_NAME.content ? f.sprintf(e.checks.BTN_ROLE_IN_NAME.content) : `${f.sprintf("BTN_ROLE_IN_NAME")} ${f.sprintf("BTN_TIP")}`,
      dismiss: a,
      dismissAll: e.checks.BTN_ROLE_IN_NAME.dismissAll ? "BTN_ROLE_IN_NAME" : !1,
      developer: e.checks.BTN_ROLE_IN_NAME.developer || !0
    });
  }), e.checks.UNCONTAINED_LI && M.Found.Lists.forEach((n) => {
    n.closest("ul, ol, menu") || t.push({
      test: "UNCONTAINED_LI",
      element: n,
      type: e.checks.UNCONTAINED_LI.type || "error",
      content: f.sprintf(e.checks.UNCONTAINED_LI.content || "UNCONTAINED_LI"),
      dismiss: N(`UNCONTAINEDLI${n.textContent}`),
      dismissAll: e.checks.UNCONTAINED_LI.dismissAll ? "UNCONTAINED_LI" : !1,
      developer: e.checks.UNCONTAINED_LI.developer || !0
    });
  }), e.checks.TABINDEX_ATTR && M.Found.TabIndex.forEach((n) => {
    t.push({
      test: "TABINDEX_ATTR",
      element: n,
      type: e.checks.TABINDEX_ATTR.type || "error",
      content: f.sprintf(e.checks.TABINDEX_ATTR.content || "TABINDEX_ATTR"),
      dismiss: N(`TABINDEX${n.tagName + n.id + n.className}`),
      dismissAll: e.checks.TABINDEX_ATTR.dismissAll ? "TABINDEX_ATTR" : !1,
      developer: e.checks.TABINDEX_ATTR.developer || !0
    });
  }), t;
}
class Rr {
  constructor(e) {
    const n = {
      ..._n,
      ...e,
      checks: {
        ..._n.checks,
        ...e.checks
      }
    };
    this.initialize = () => {
      (() => {
        const { doNotRun: r } = n;
        return r.trim().length > 0 ? document.querySelector(r) : !1;
      })() || (customElements.define("sa11y-heading-label", dr), customElements.define("sa11y-heading-anchor", cr), customElements.define("sa11y-annotation", or), customElements.define("sa11y-tooltips", Zn), customElements.define("sa11y-panel-tooltips", es), customElements.define("sa11y-control-panel", Sn), customElements.define("sa11y-console-error", Nn), u.initializeGlobal(n), u.initializeReadability(n), u.initializeExclusions(n), n.developerChecksOnByDefault && (P.getItem("sa11y-developer") === null || n.checkAllHideToggles) && P.setItem("sa11y-developer", "On"), Ks(() => {
        if (n.headless)
          this.checkAll(), P.removeItem("sa11y-dismissed");
        else {
          const r = P.getItem("sa11y-position"), { panelPosition: a } = n;
          n.showMovePanelToggle && (!r || !r.includes("top") != !a.includes("top")) && P.setItem("sa11y-position", a);
          const i = new Sn();
          document.body.appendChild(i), ha(this.checkAll, this.resetAll), ga(), ia(), Zs(n.detectSPArouting, this.checkAll, this.resetAll), this.panelTooltips = new es(), document.body.appendChild(this.panelTooltips), u.Panel.toggle.disabled = !1, setTimeout(() => {
            this.resetAll(), this.checkAll();
          }, n.delayCheck), n.delayCheck >= 700 && (u.Panel.toggle.disabled = !0), ua(this.checkAll, this.resetAll);
        }
      }));
    }, this.checkAll = async (s = n.checkRoot, r = n.readabilityRoot, a = n.fixedRoots) => {
      try {
        this.results = [], this.headingOutline = [], this.errorCount = 0, this.warningCount = 0, this.customChecksRunning = !1, u.initializeRoot(s, r, a), Fs(n), M.initializeElements(n), yr(this.results, n, this.headingOutline), xr(this.results, n), br(this.results, n), Sr(this.results, n), Or(this.results, n), Pr(this.results, n), n.embeddedContentPlugin && Cr(this.results, n), n.contrastPlugin && Nr(this.results, n), n.readabilityPlugin && P.getItem("sa11y-readability") === "On" && wr(this.results), this.imageResults = M.Found.Images.map((i) => {
          const l = this.results.find((c) => c.element === i);
          return l && {
            element: i,
            type: l.type,
            dismiss: l.dismiss,
            developer: l.developer
          };
        }).filter(Boolean), n.customChecks === !0 ? this.results : typeof n.customChecks == "object" ? this.results.push(...n.customChecks) : n.customChecks === "listen" && (this.customChecksRunning = !0, this.customChecksFinished = 0, document.addEventListener("sa11y-resume", () => {
          this.customChecksFinished += 1, this.customChecksFinished === 1 && (this.customChecksRunning = !1, this.updateResults());
        }), window.setTimeout(() => {
          if (this.customChecksRunning === !0)
            throw this.customChecksRunning = !1, this.updateResults(), Error("Sa11y: No custom checks were returned.");
        }, n.delayCustomCheck), window.setTimeout(() => {
          const i = new CustomEvent("sa11y-custom-checks");
          document.dispatchEvent(i);
        }, 0)), this.customChecksRunning || this.updateResults();
      } catch (i) {
        const l = new Nn(i);
        throw document.body.appendChild(l), Error(i);
      }
    }, this.updateResults = () => {
      this.results = this.results.filter((a) => a.isWithinRoot !== !1);
      const s = P.getItem("sa11y-developer") === "Off" || P.getItem("sa11y-developer") === null;
      if ((s || n.externalDeveloperChecks === !0) && (this.results = this.results.filter((a) => a.developer !== !0)), s && (this.results = this.results.filter((a) => a.external !== !0)), this.results.forEach((a, i) => {
        const l = n.selectorPath ? Ys(a.element) : "", c = a.element?.outerHTML.replace(/\s{2,}/g, " ").trim() || "";
        Object.assign(a, { htmlPath: c, cssPath: l, id: i });
      }), n.headless === !1) {
        const a = ea(
          this.results,
          this.panelTooltips,
          this.checkAll,
          this.resetAll
        );
        this.results = a.updatedResults, this.dismissed = a.dismissedIssues, this.dismissedPageResults = a.dismissedResults;
        const i = va(this.results, this.errorCount, this.warningCount);
        if (Ea(i.error, i.warning), P.getItem("sa11y-panel") === "Opened") {
          const l = /* @__PURE__ */ new Map();
          this.results.forEach((p) => {
            let o = p;
            if (p.element && !p.margin) {
              const d = l.get(p.element) || 0;
              l.set(p.element, d + 1);
              const m = p.inline ? 0 : 15;
              o = { ...p, margin: `${d * 20 + m}px` };
            }
            lr(o, n);
          }), M.initializeAnnotations();
          const c = new Zn();
          document.body.appendChild(c), sa(this.results, this.dismissed, this.checkAll, this.resetAll), ma(this.dismissedPageResults, this.headingOutline, n), n.showImageOutline && ba(this.dismissedPageResults, this.imageResults, n), ya(a.dismissCount, i.error, i.warning), gr(this.results), n.exportResultsPlugin && da(this.results, a.dismissedResults), gt(u.Panel.pageIssuesList, u.Panel.pageIssuesContent);
        }
        u.Panel.toggle.disabled = !1;
      }
      window.sa11yCheckComplete = null;
      const r = new CustomEvent("sa11y-check-complete", {
        detail: {
          results: this.results,
          page: window.location.pathname
        }
      });
      window.sa11yCheckComplete = r.detail, document.dispatchEvent(r);
    }, this.resetAll = (s = !0) => {
      for (u.Global.html.removeAttribute("data-sa11y-active"), ns(
        [
          "sa11y-annotation",
          "sa11y-heading-label",
          "sa11y-heading-anchor",
          "sa11y-image-anchor",
          "sa11y-tooltips"
        ],
        "document"
      ), os() && te("[data-sa11y-error], [data-sa11y-warning], [data-sa11y-good]", "document").forEach(
        (r) => {
          const a = r, i = (a.style.anchorName || "").split(",").map((l) => l.trim()).filter((l) => l && !l.startsWith("--sa11y-anchor"));
          i.length ? a.style.anchorName = i.join(", ") : (a.style.removeProperty("anchor-name"), a.style.length || a.removeAttribute("style"));
        }
      ), ts(
        [
          "data-sa11y-parent",
          "data-sa11y-error",
          "data-sa11y-warning",
          "data-sa11y-good",
          "data-sa11y-overflow",
          "data-sa11y-image",
          "data-sa11y-pulse-border",
          "data-sa11y-filter",
          "data-sa11y-has-shadow-root"
        ],
        "document"
      ), u.Panel.outlineList.innerHTML = "", n.showImageOutline && (u.Panel.imagesList.innerHTML = ""), u.Panel.pageIssuesList.innerHTML = "", u.Panel.readabilityInfo.innerHTML = "", u.Panel.readabilityDetails.innerHTML = "", u.Panel.panel.classList.remove("has-page-issues"), u.Panel.pageIssues.classList.remove("active"), u.Panel.settingsContent.classList.remove("hide-settings-border"), u.Panel.panel.querySelector("#readability-alert")?.remove(), We(), mr(), pa(), aa(), ls(); u.Panel.status.firstChild; )
        u.Panel.status.removeChild(u.Panel.status.firstChild);
      document.querySelectorAll("[data-sa11y-has-shadow-root]").forEach((r) => {
        r.shadowRoot.querySelectorAll("style.sa11y-css-utilities").forEach((a) => {
          a.remove();
        }), r.removeAttribute("data-sa11y-has-shadow-root");
      }), s && u.Panel.panel.classList.remove("active");
    }, this.disabled = () => {
      setTimeout(() => {
        P.getItem("sa11y-panel") === "Opened" && u.Panel.toggle.click(), u.Panel.toggle.disabled = !0;
      }, n.delayCheck + 10);
    }, this.enabled = () => {
      u.Panel.toggle && (u.Panel.toggle.disabled = !1);
    }, this.find = (s, r, a) => te(s, r, a), this.prepareDismissal = (s) => N(s), this.sanitizeHTML = (s) => q(s), this.truncateString = (s, r) => Se(s, r), this.initialize();
  }
}
export {
  f as Lang,
  Rr as Sa11y
};
